/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.ftbteams;

import aztech.modern_industrialization.compat.ftbteams.FTBTeamsFacade;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;

public class FTBTeamsFacadeImpl
implements FTBTeamsFacade {
    private final Map<UUID, Collection<UUID>> cachedPlayersInTeam = new HashMap<UUID, Collection<UUID>>();

    public FTBTeamsFacadeImpl() {
        TeamEvent.PLAYER_CHANGED.register(event -> this.cachedPlayersInTeam.clear());
        NeoForge.EVENT_BUS.addListener(ServerStoppedEvent.class, event -> this.cachedPlayersInTeam.clear());
    }

    @Override
    public Collection<UUID> getOtherPlayersInTeam(UUID playerUuid) {
        return this.cachedPlayersInTeam.computeIfAbsent(playerUuid, uuid -> {
            Optional team = FTBTeamsAPI.api().getManager().getTeamForPlayerID(uuid);
            if (team.isEmpty()) {
                return List.of();
            }
            HashSet keys = new HashSet(((Team)team.get()).getMembers());
            keys.remove(uuid);
            return keys;
        });
    }
}

