/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.ae2.pipe;

import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.util.AEColor;
import appeng.me.GridConnection;
import aztech.modern_industrialization.compat.ae2.pipe.MENetworkData;
import aztech.modern_industrialization.compat.ae2.pipe.MENetworkNode;
import aztech.modern_industrialization.compat.ae2.pipe.NetworkInternalNode;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.api.PipeNetwork;
import aztech.modern_industrialization.pipes.api.PipeNetworkData;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jspecify.annotations.Nullable;

public class MENetwork
extends PipeNetwork {
    final AEColor color;

    public MENetwork(int id, @Nullable PipeNetworkData data, AEColor color) {
        super(id, data == null ? new MENetworkData() : data);
        this.color = color;
    }

    @Override
    public void setNode(BlockPos pos, @Nullable PipeNetworkNode maybeNode) {
        if (maybeNode instanceof MENetworkNode) {
            MENetworkNode node = (MENetworkNode)maybeNode;
            IManagedGridNode aeManagedNode = node.mainNode;
            if (aeManagedNode != null && aeManagedNode.isReady()) {
                MENetworkData meData;
                PipeNetworkData pipeNetworkData;
                for (IGridConnection connection : aeManagedNode.getNode().getConnections()) {
                    IGridNode otherSide = connection.getOtherSide(aeManagedNode.getNode());
                    if (otherSide.getService(NetworkInternalNode.class) == null) continue;
                    connection.destroy();
                    break;
                }
                if ((pipeNetworkData = this.data) instanceof MENetworkData && (meData = (MENetworkData)pipeNetworkData).getMainNode().isReady()) {
                    GridHelper.createConnection((IGridNode)meData.getMainNode().getNode(), (IGridNode)aeManagedNode.getNode());
                }
            }
        }
        super.setNode(pos, maybeNode);
    }

    @Override
    public void onRemove() {
        PipeNetworkData pipeNetworkData = this.data;
        if (pipeNetworkData instanceof MENetworkData) {
            MENetworkData meData = (MENetworkData)pipeNetworkData;
            meData.getMainNode().destroy();
        }
        for (PipeNetworkNode node : this.getRawNodeMap().values()) {
            if (node == null) continue;
            node.onUnload();
        }
    }

    @Override
    public void tick(ServerLevel world) {
        IManagedGridNode mainNode = ((MENetworkData)this.data).getMainNode();
        if (!mainNode.isReady()) {
            mainNode.create((Level)world, null);
        }
        for (PipeNetwork.PosNode posNode : this.iterateTickingNodes()) {
            MENetworkNode node = (MENetworkNode)posNode.getNode();
            if (node.connectDelay-- > 0) continue;
            node.connectDelay = 100;
            node.updateNode();
            if (node.mainNode == null) continue;
            boolean wasReady = node.mainNode.isReady();
            boolean hasInternalConnection = false;
            if (node.mainNode.isReady()) {
                for (IGridConnection conn : node.mainNode.getNode().getConnections()) {
                    if (conn.getOtherSide(node.mainNode.getNode()).getService(NetworkInternalNode.class) == null) continue;
                    hasInternalConnection = true;
                    break;
                }
            } else {
                node.mainNode.setVisualRepresentation((ItemLike)MIPipes.INSTANCE.getPipeItem(this.manager.getType()));
                node.mainNode.create((Level)world, posNode.getPos());
            }
            if (!wasReady || !hasInternalConnection) {
                GridHelper.createConnection((IGridNode)mainNode.getNode(), (IGridNode)node.mainNode.getNode());
            }
            HashSet<Direction> failedConnections = new HashSet<Direction>();
            for (Direction missingConnection : Sets.difference(node.connections, (Set)node.mainNode.getNode().getConnectedSides())) {
                IGridNode otherNode = GridHelper.getExposedNode((Level)world, (BlockPos)posNode.getPos().relative(missingConnection), (Direction)missingConnection.getOpposite());
                if (otherNode == null) continue;
                if (!MENetworkNode.areColorsCompatible(this.color, otherNode.getGridColor())) {
                    failedConnections.add(missingConnection);
                    continue;
                }
                GridConnection.create((IGridNode)node.mainNode.getNode(), (IGridNode)otherNode, (Direction)missingConnection);
            }
            node.connections.removeAll(failedConnections);
            node.updateNode();
            world.blockEntityChanged(posNode.getPos());
            world.getChunkSource().blockChanged(posNode.getPos());
        }
    }

    @Override
    public PipeNetworkData merge(PipeNetwork other) {
        throw new UnsupportedOperationException("Unreachable!");
    }
}

