/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.ae2;

import appeng.api.config.PowerUnit;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.AEBasePart;
import appeng.parts.PartAdjacentApi;
import appeng.parts.p2p.P2PTunnelPart;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.compat.ae2.P2PModels;
import aztech.modern_industrialization.config.MIServerConfig;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.StoragePreconditions;
import dev.technici4n.grandpower.api.DelegatingEnergyStorage;
import dev.technici4n.grandpower.api.EnergyStorageUtil;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;

public class EnergyP2PTunnelPart
extends P2PTunnelPart<EnergyP2PTunnelPart>
implements IGridTickable {
    private static final P2PModels MODELS = new P2PModels("part/energy_p2p_tunnel");
    private final PartAdjacentApi<MIEnergyStorage> adjacentCapability;
    private final MIEnergyStorage inputStorage = new InputEnergyStorage();
    private final EnergyBuffer outputBuffer = new EnergyBuffer();
    private final MIEnergyStorage exposedOutput = new OutputEnergyStorage(this);

    public EnergyP2PTunnelPart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().addService(IGridTickable.class, (IGridNodeService)this);
        this.adjacentCapability = new PartAdjacentApi((AEBasePart)this, EnergyApi.SIDED);
    }

    public MIEnergyStorage getExposedApi() {
        if (this.isOutput()) {
            return this.exposedOutput;
        }
        return this.inputStorage;
    }

    public void readFromNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.readFromNBT(data, registries);
        this.outputBuffer.energy = data.getLong("energy");
    }

    public void writeToNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.writeToNBT(data, registries);
        if (this.outputBuffer.energy > 0L) {
            data.putLong("energy", this.outputBuffer.energy);
        }
    }

    public void onTunnelNetworkChange() {
        this.getBlockEntity().invalidateCapabilities();
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 20, false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.isOutput()) {
            long moved;
            MIEnergyStorage adjacentEnergy = (MIEnergyStorage)this.adjacentCapability.find();
            if (adjacentEnergy == null || !adjacentEnergy.canConnect(CableTier.SUPERCONDUCTOR)) {
                adjacentEnergy = EnergyApi.EMPTY;
            }
            return (moved = EnergyStorageUtil.move((ILongEnergyStorage)this.outputBuffer, (ILongEnergyStorage)adjacentEnergy, (long)Long.MAX_VALUE)) > 0L ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
        }
        return TickRateModulation.IDLE;
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    private class InputEnergyStorage
    implements MIEnergyStorage.NoExtract {
        private InputEnergyStorage() {
        }

        public boolean canReceive() {
            return true;
        }

        public long receive(long maxAmount, boolean simulate) {
            StoragePreconditions.notNegative(maxAmount);
            long total = 0L;
            int outputTunnels = EnergyP2PTunnelPart.this.getOutputs().size();
            long amount = maxAmount;
            if (outputTunnels == 0 || amount == 0L) {
                return 0L;
            }
            long amountPerOutput = amount / (long)outputTunnels;
            long overflow = amountPerOutput == 0L ? amount : amount % amountPerOutput;
            for (EnergyP2PTunnelPart target : EnergyP2PTunnelPart.this.getOutputs()) {
                long toSend = amountPerOutput + overflow;
                long received = target.outputBuffer.receive(toSend, simulate);
                overflow = toSend - received;
                total += received;
            }
            if (!simulate) {
                EnergyP2PTunnelPart.this.queueTunnelDrain(PowerUnit.FE, total * (long)MIServerConfig.INSTANCE.forgeEnergyPerEu.getAsInt());
            }
            return total;
        }

        public long getAmount() {
            long tot = 0L;
            for (EnergyP2PTunnelPart output : EnergyP2PTunnelPart.this.getOutputs()) {
                tot += output.outputBuffer.getAmount();
            }
            return tot;
        }

        public long getCapacity() {
            long tot = 0L;
            for (EnergyP2PTunnelPart output : EnergyP2PTunnelPart.this.getOutputs()) {
                tot += output.outputBuffer.getCapacity();
            }
            return tot;
        }

        @Override
        public boolean canConnect(CableTier cableTier) {
            return cableTier == CableTier.SUPERCONDUCTOR;
        }
    }

    private class EnergyBuffer
    implements ILongEnergyStorage {
        private long energy;

        private EnergyBuffer() {
        }

        public long receive(long maxReceive, boolean simulate) {
            long inserted = Math.min(this.getCapacity() - this.energy, maxReceive);
            if (inserted > 0L) {
                if (!simulate) {
                    this.energy += inserted;
                    EnergyP2PTunnelPart.this.getHost().markForSave();
                }
                return inserted;
            }
            return 0L;
        }

        public long extract(long maxExtract, boolean simulate) {
            long extracted = Math.min(this.energy, maxExtract);
            if (extracted > 0L) {
                if (!simulate) {
                    this.energy -= extracted;
                    EnergyP2PTunnelPart.this.getHost().markForSave();
                }
                return extracted;
            }
            return 0L;
        }

        public long getAmount() {
            return this.energy;
        }

        public long getCapacity() {
            return EnergyP2PTunnelPart.this.isActive() ? CableTier.SUPERCONDUCTOR.getMaxTransfer() : 0L;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    }

    private class OutputEnergyStorage
    extends DelegatingEnergyStorage
    implements MIEnergyStorage {
        public OutputEnergyStorage(EnergyP2PTunnelPart energyP2PTunnelPart) {
            super((ILongEnergyStorage)energyP2PTunnelPart.outputBuffer);
        }

        public boolean canReceive() {
            return false;
        }

        public long receive(long maxReceive, boolean simulate) {
            return 0L;
        }

        @Override
        public boolean canConnect(CableTier cableTier) {
            return cableTier == CableTier.SUPERCONDUCTOR;
        }
    }
}

