/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client.pipes.impl;

import aztech.modern_industrialization.client.thirdparty.fabricrendering.EncodingFormat;
import aztech.modern_industrialization.client.thirdparty.fabricrendering.MutableQuadView;
import aztech.modern_industrialization.client.thirdparty.fabricrendering.MutableQuadViewImpl;
import aztech.modern_industrialization.client.thirdparty.fabricrendering.QuadEmitter;
import aztech.modern_industrialization.client.thirdparty.fabricrendering.SpriteFinder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;

public class PipeRenderContext {
    private final SpriteFinder spriteFinder;
    private final boolean acceptNormalQuads;
    private final boolean acceptFluidQuads;
    private final List<QuadTransform> transforms = new ArrayList<QuadTransform>();
    final List<BakedQuad> quads = new ArrayList<BakedQuad>();
    private final MutableQuadViewImpl editorQuad = new MutableQuadViewImpl(){
        {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.clear();
        }

        @Override
        public void emitDirectly() {
            int tag = this.tag();
            if (!PipeRenderContext.this.acceptNormalQuads && tag == 0 || !PipeRenderContext.this.acceptFluidQuads && tag == 1) {
                return;
            }
            if (!PipeRenderContext.this.passTransforms(this)) {
                return;
            }
            PipeRenderContext.this.quads.add(PipeRenderContext.this.editorQuad.toBakedQuad(PipeRenderContext.this.spriteFinder.find(PipeRenderContext.this.editorQuad)));
        }
    };

    public PipeRenderContext(SpriteFinder spriteFinder, boolean acceptNormalQuads, boolean acceptFluidQuads) {
        this.spriteFinder = spriteFinder;
        this.acceptNormalQuads = acceptNormalQuads;
        this.acceptFluidQuads = acceptFluidQuads;
    }

    private boolean passTransforms(MutableQuadView q) {
        int i = this.transforms.size() - 1;
        while (i >= 0) {
            if (this.transforms.get(i--).transform(q)) continue;
            return false;
        }
        return true;
    }

    public void pushTransform(QuadTransform transform) {
        this.transforms.add(transform);
    }

    public void popTransform() {
        this.transforms.remove(this.transforms.size() - 1);
    }

    public QuadEmitter getEmitter() {
        return this.editorQuad;
    }

    public static interface QuadTransform {
        public boolean transform(MutableQuadView var1);
    }
}

