/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client.pipes.gui;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.client.DynamicTooltip;
import aztech.modern_industrialization.pipes.gui.iface.ConnectionTypeInterface;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

class ConnectionTypeButton
extends Button {
    private final ConnectionTypeInterface connectionType;

    public ConnectionTypeButton(int x, int y, Button.OnPress onPress, Supplier<List<Component>> tooltipSupplier, ConnectionTypeInterface connectionType) {
        super(x, y, 20, 20, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.connectionType = connectionType;
        this.setTooltip(new DynamicTooltip(tooltipSupplier));
    }

    public Component getMessage() {
        return switch (this.connectionType.getConnectionType()) {
            case 0 -> MIText.PipeConnectionIn.text();
            case 1 -> MIText.PipeConnectionIO.text();
            case 2 -> MIText.PipeConnectionOut.text();
            default -> throw new IllegalArgumentException("Connection type must be either 0, 1 or 2");
        };
    }

    public void renderString(GuiGraphics guiGraphics, Font font, int color) {
        this.renderScrollingString(guiGraphics, font, 0, color);
    }
}

