/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client.machines.guicomponents;

import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.client.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.client.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.client.machines.gui.MachineScreen;
import aztech.modern_industrialization.inventory.BackgroundRenderedSlot;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.util.Rectangle;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Unit;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SlotPanelClient
extends GuiComponentClient<List<SlotPanel.SlotType>, Unit> {
    public SlotPanelClient(List<SlotPanel.SlotType> params, Unit data) {
        super(params, data);
    }

    @Override
    public void setupMenu(final GuiComponent.MenuFacade menu) {
        for (int i = 0; i < ((List)this.params).size(); ++i) {
            final SlotPanel.SlotType type = (SlotPanel.SlotType)((Object)((List)this.params).get(i));
            class ClientSlot
            extends SlotWithBackground
            implements SlotTooltip {
                public ClientSlot(int i) {
                    super((Container)new SimpleContainer(1), 0, SlotPanel.getSlotX(menuFacade.getGuiParams()), SlotPanel.getSlotY(i));
                }

                public boolean mayPlace(ItemStack stack) {
                    return type.mayPlace(stack);
                }

                public int getMaxStackSize() {
                    return type.slotLimit;
                }

                @Override
                public int getBackgroundU() {
                    return !this.hasItem() ? type.u : 0;
                }

                @Override
                public int getBackgroundV() {
                    return !this.hasItem() ? type.v : 0;
                }

                @Override
                public Component getTooltip() {
                    return MITooltips.line(type.tooltip).build();
                }
            }
            menu.addSlotToMenu(new ClientSlot(i), type.group);
        }
    }

    @Override
    public ClientComponentRenderer createRenderer(final MachineScreen machineScreen) {
        return new ClientComponentRenderer(){

            private Rectangle getBox(int leftPos, int topPos) {
                return new Rectangle(leftPos + machineScreen.getGuiParams().backgroundWidth, topPos + 10, 31, 14 + 20 * ((List)SlotPanelClient.this.params).size());
            }

            @Override
            public void addExtraBoxes(List<Rectangle> rectangles, int leftPos, int topPos) {
                rectangles.add(this.getBox(leftPos, topPos));
            }

            @Override
            public void renderBackground(GuiGraphics guiGraphics, int x, int y) {
                Rectangle box = this.getBox(x, y);
                int textureX = box.x() - x - box.w();
                guiGraphics.blit(MachineScreen.BACKGROUND, box.x(), box.y(), textureX, 0, box.w(), box.h() - 4);
                guiGraphics.blit(MachineScreen.BACKGROUND, box.x(), box.y() + box.h() - 4, textureX, 252, box.w(), 4);
            }

            @Override
            public void renderTooltip(MachineScreen screen, Font font, GuiGraphics guiGraphics, int x, int y, int cursorX, int cursorY) {
                Slot slot = screen.getFocusedSlot();
                if (slot instanceof SlotTooltip) {
                    SlotTooltip st = (SlotTooltip)slot;
                    if (!screen.getFocusedSlot().hasItem()) {
                        guiGraphics.renderTooltip(font, st.getTooltip(), cursorX, cursorY);
                    }
                }
            }
        };
    }

    public static class SlotWithBackground
    extends Slot
    implements BackgroundRenderedSlot {
        public SlotWithBackground(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }
    }

    static interface SlotTooltip {
        public Component getTooltip();
    }
}

