/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client.machines.guicomponents;

import aztech.modern_industrialization.client.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.client.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.client.machines.gui.MachineMenuClient;
import aztech.modern_industrialization.client.machines.gui.MachineScreen;
import aztech.modern_industrialization.client.machines.guicomponents.ShapeSelectionClient;
import aztech.modern_industrialization.client.util.RenderHelper;
import aztech.modern_industrialization.machines.blockentities.multiblocks.LargeTankMultiblockBlockEntity;
import aztech.modern_industrialization.machines.guicomponents.LargeTankFluidDisplay;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.util.FluidHelper;
import aztech.modern_industrialization.util.Rectangle;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Unit;

public class LargeTankFluidDisplayClient
extends GuiComponentClient<Unit, LargeTankFluidDisplay.Data> {
    public LargeTankFluidDisplayClient(Unit params, LargeTankFluidDisplay.Data data) {
        super(params, data);
    }

    @Override
    public ClientComponentRenderer createRenderer(final MachineScreen machineScreen) {
        return new ClientComponentRenderer(){
            private static final int posX = 70;
            private static final int posY = 12;

            @Override
            public void renderBackground(GuiGraphics guiGraphics, int leftPos, int topPos) {
                FluidVariant fluid = ((LargeTankFluidDisplay.Data)LargeTankFluidDisplayClient.this.data).fluid();
                float fracFull = (float)((LargeTankFluidDisplay.Data)LargeTankFluidDisplayClient.this.data).amount() / (float)((LargeTankFluidDisplay.Data)LargeTankFluidDisplayClient.this.data).capacity();
                guiGraphics.blit(MachineScreen.SLOT_ATLAS, leftPos + 70, topPos + 12, 92, 38, 46, 62);
                RenderSystem.disableBlend();
                if (!fluid.isBlank()) {
                    for (int i = 0; i < 2; ++i) {
                        for (int j = 0; j < 3; ++j) {
                            float localFullness = Math.min(Math.max(3.0f * fracFull - (float)(2 - j), 0.0f), 1.0f);
                            RenderHelper.drawFluidInGui(guiGraphics, fluid, leftPos + 70 + 7 + i * 16, (float)(topPos + 12 + 7 + j * 16) + (1.0f - localFullness) * 16.0f, 16, localFullness);
                        }
                    }
                }
                RenderSystem.enableBlend();
                guiGraphics.blit(MachineScreen.SLOT_ATLAS, leftPos + 70 + 7, topPos + 12 + 7, 60, 38, 32, 48);
                ShapeSelectionClient shapeSelection = ((MachineMenuClient)machineScreen.getMenu()).getComponent(ShapeSelectionClient.class);
                ShapeSelectionClient.Renderer renderer = Objects.requireNonNull(shapeSelection).getRenderer();
                if (renderer.isPanelOpen) {
                    Rectangle shapePanelBox = renderer.getBox(leftPos, topPos);
                    List<Integer> selectedShape = shapeSelection.getData();
                    long capacity = LargeTankMultiblockBlockEntity.getCapacityFromComponents(selectedShape.get(0), selectedShape.get(1), selectedShape.get(2));
                    MutableComponent capacityText = FluidHelper.getFluidAmountLarge(capacity);
                    guiGraphics.drawString(Minecraft.getInstance().font, (Component)capacityText, shapePanelBox.x() + 14, shapePanelBox.y() + 14, 0x404040, false);
                }
            }

            @Override
            public void renderTooltip(MachineScreen screen, Font font, GuiGraphics guiGraphics, int x, int y, int cursorX, int cursorY) {
                if (RenderHelper.isPointWithinRectangle(77, 19, 32, 48, cursorX - x, cursorY - y)) {
                    guiGraphics.renderTooltip(font, FluidHelper.getTooltipForFluidStorage(((LargeTankFluidDisplay.Data)LargeTankFluidDisplayClient.this.data).fluid(), ((LargeTankFluidDisplay.Data)LargeTankFluidDisplayClient.this.data).amount(), ((LargeTankFluidDisplay.Data)LargeTankFluidDisplayClient.this.data).capacity()), Optional.empty(), cursorX, cursorY);
                }
            }
        };
    }
}

