/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client.machines.guicomponents;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.client.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.client.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.client.machines.gui.MachineScreen;
import aztech.modern_industrialization.client.util.RenderHelper;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.util.TextHelper;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.MutableComponent;

public class EnergyBarClient
extends GuiComponentClient<EnergyBar.Params, EnergyBar.Data> {
    public EnergyBarClient(EnergyBar.Params parameters, EnergyBar.Data data) {
        super(parameters, data);
    }

    @Override
    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new Renderer();
    }

    public class Renderer
    implements ClientComponentRenderer {
        public static final int WIDTH = 13;
        public static final int HEIGHT = 18;

        public static void renderEnergy(GuiGraphics guiGraphics, int px, int py, float fill) {
            guiGraphics.blit(MachineScreen.SLOT_ATLAS, px, py, 230, 0, 13, 18);
            int fillPixels = (int)((double)(fill * 18.0f) * 0.9 + 1.8);
            if ((double)fill > 0.95) {
                fillPixels = 18;
            }
            guiGraphics.blit(MachineScreen.SLOT_ATLAS, px, py + 18 - fillPixels, 243, 18 - fillPixels, 13, fillPixels);
        }

        @Override
        public void renderBackground(GuiGraphics guiGraphics, int x, int y) {
            Renderer.renderEnergy(guiGraphics, x + ((EnergyBar.Params)EnergyBarClient.this.params).renderX(), y + ((EnergyBar.Params)EnergyBarClient.this.params).renderY(), (float)((EnergyBar.Data)EnergyBarClient.this.data).eu() / (float)((EnergyBar.Data)EnergyBarClient.this.data).maxEu());
        }

        @Override
        public void renderTooltip(MachineScreen screen, Font font, GuiGraphics guiGraphics, int x, int y, int cursorX, int cursorY) {
            if (RenderHelper.isPointWithinRectangle(((EnergyBar.Params)EnergyBarClient.this.params).renderX(), ((EnergyBar.Params)EnergyBarClient.this.params).renderY(), 13, 18, cursorX - x, cursorY - y)) {
                MutableComponent tooltip;
                if (Screen.hasShiftDown()) {
                    tooltip = MIText.EuMaxed.text(((EnergyBar.Data)EnergyBarClient.this.data).eu(), ((EnergyBar.Data)EnergyBarClient.this.data).maxEu(), "");
                } else {
                    TextHelper.MaxedAmount maxedAmount = TextHelper.getMaxedAmount(((EnergyBar.Data)EnergyBarClient.this.data).eu(), ((EnergyBar.Data)EnergyBarClient.this.data).maxEu());
                    tooltip = MIText.EuMaxed.text(maxedAmount.digit(), maxedAmount.maxDigit(), maxedAmount.unit());
                }
                guiGraphics.renderTooltip(font, Collections.singletonList(tooltip), Optional.empty(), cursorX, cursorY);
            }
        }
    }
}

