/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client.blocks.storage.barrel;

import aztech.modern_industrialization.blocks.storage.barrel.BarrelBlockEntity;
import aztech.modern_industrialization.client.blocks.storage.barrel.DeferredBarrelTextRenderer;
import aztech.modern_industrialization.client.util.RenderHelper;
import aztech.modern_industrialization.config.MIClientConfig;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BarrelRenderer
implements BlockEntityRenderer<BarrelBlockEntity> {
    private static final ThreadLocal<Integer> barrelNesting = ThreadLocal.withInitial(() -> 0);
    private final int itemNameColor;

    public BarrelRenderer(int itemNameColor) {
        this.itemNameColor = itemNameColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(BarrelBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (entity.isLocked()) {
            RenderHelper.drawLockedTexture(entity, matrices, vertexConsumers, this.itemNameColor);
        }
        if (!MIClientConfig.INSTANCE.barrelContentRendering.getAsBoolean()) {
            return;
        }
        int nesting = barrelNesting.get();
        if (nesting >= 4) {
            return;
        }
        barrelNesting.set(nesting + 1);
        try {
            BlockState state = entity.getBlockState();
            BlockPos pos = entity.getBlockPos();
            ItemVariant item = (ItemVariant)entity.getResource();
            if (!item.isBlank()) {
                ItemStack toRender = item.toStack();
                int sideMask = 0;
                for (int i = 0; i < 4; ++i) {
                    Direction direction = Direction.from2DDataValue((int)i);
                    if (entity.getLevel() != null && !Block.shouldRenderFace((BlockState)state, (BlockGetter)entity.getLevel(), (BlockPos)pos, (Direction)direction, (BlockPos)pos.relative(direction))) continue;
                    sideMask |= 1 << i;
                    matrices.pushPose();
                    matrices.translate(0.5, 0.0, 0.5);
                    matrices.mulPose(Axis.YP.rotationDegrees((float)(-i) * 90.0f));
                    matrices.scale(0.5f, 0.5f, 0.5f);
                    matrices.translate(0.0, 1.125, 1.01);
                    matrices.last().pose().scale(1.0f, 1.0f, 0.01f);
                    matrices.last().normal().rotate(0.7853982f, -1.0f, 0.0f, 0.0f);
                    Minecraft.getInstance().getItemRenderer().renderStatic(toRender, ItemDisplayContext.GUI, 0xF000F0, OverlayTexture.NO_OVERLAY, matrices, vertexConsumers, entity.getLevel(), 0);
                    matrices.popPose();
                }
                DeferredBarrelTextRenderer.enqueueBarrelForRendering(pos, sideMask, this.itemNameColor);
            }
        }
        finally {
            barrelNesting.set(nesting);
        }
    }
}

