/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization;

import aztech.modern_industrialization.blocks.storage.barrel.BarrelBlockEntity;
import aztech.modern_industrialization.blocks.storage.tank.AbstractTankBlockEntity;
import aztech.modern_industrialization.machines.gui.MachineMenuCommon;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariantAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import org.jspecify.annotations.Nullable;

public class MICommonProxy {
    public static MICommonProxy INSTANCE = MICommonProxy.instantiateProxy();
    private static @Nullable MinecraftServer currentServer = null;

    private static MICommonProxy instantiateProxy() {
        if (FMLEnvironment.dist.isClient()) {
            try {
                Class<?> clientProxy = Class.forName("aztech.modern_industrialization.client.MIClientProxy");
                return (MICommonProxy)clientProxy.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create Modern Industrialization ClientProxy.", e);
            }
        }
        return new MICommonProxy();
    }

    public static void initEvents() {
        NeoForge.EVENT_BUS.addListener(ServerAboutToStartEvent.class, e -> {
            currentServer = e.getServer();
        });
        NeoForge.EVENT_BUS.addListener(ServerStoppedEvent.class, e -> {
            currentServer = null;
        });
    }

    public Player getClientPlayer() {
        throw new UnsupportedOperationException("Client player is not available on the server!");
    }

    public @Nullable Player findUser(ItemStack mainHand) {
        if (currentServer != null) {
            for (ServerPlayer player : currentServer.getPlayerList().getPlayers()) {
                if (player.getMainHandItem() != mainHand) continue;
                return player;
            }
        }
        return null;
    }

    public boolean shouldSteamDrillForceBreakReset() {
        return false;
    }

    public void delayNextBlockAttack(Player player) {
    }

    public boolean hasShiftDown() {
        return false;
    }

    public List<Component> getFluidTooltip(FluidVariant variant) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add(FluidVariantAttributes.getName(variant));
        return list;
    }

    public void withStandardItemRenderer(Consumer<?> stupidClientProperties) {
    }

    public void registerPartTankClient(Supplier<? extends BlockEntityType<? extends AbstractTankBlockEntity>> blockEntityType, int meanRgb) {
    }

    public void registerPartBarrelClient(Supplier<BlockEntityType<BarrelBlockEntity>> blockEntityType, int meanRgb) {
    }

    public MachineMenuCommon createClientMachineMenu(int syncId, Inventory playerInventory, RegistryFriendlyByteBuf buf) {
        throw new UnsupportedOperationException("Only supported on the server");
    }

    public BlockState getMachineCasingBlockState(BlockState state, BlockAndTintGetter renderView, BlockPos pos) {
        return state;
    }
}

