/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.herbsandharvest.init;

import com.google.common.collect.ImmutableList;
import com.mamailes.herbsandharvest.HerbsAndHarvest;
import com.mamailes.herbsandharvest.init.MHHBlocks;
import com.mamailes.herbsandharvest.init.MHHConfiguredFeatures;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;

public class MHHPlacements {
    public static final ResourceKey<PlacedFeature> AVOCADO_FRUIT_PLACEMENT = MHHPlacements.registerKey("avocado_fruit_placement");
    public static final ResourceKey<PlacedFeature> CHERRY_FRUIT_PLACEMENT = MHHPlacements.registerKey("cherry_fruit_placement");
    public static final ResourceKey<PlacedFeature> LEMON_FRUIT_PLACEMENT = MHHPlacements.registerKey("lemon_fruit_placement");
    public static final ResourceKey<PlacedFeature> LIME_FRUIT_PLACEMENT = MHHPlacements.registerKey("lime_fruit_placement");
    public static final ResourceKey<PlacedFeature> ORANGE_FRUIT_PLACEMENT = MHHPlacements.registerKey("orange_fruit_placement");
    public static final ResourceKey<PlacedFeature> PEACH_FRUIT_PLACEMENT = MHHPlacements.registerKey("peach_fruit_placement");
    public static final ResourceKey<PlacedFeature> PEAR_FRUIT_PLACEMENT = MHHPlacements.registerKey("pear_fruit_placement");
    public static final ResourceKey<PlacedFeature> PLUM_FRUIT_PLACEMENT = MHHPlacements.registerKey("plum_fruit_placement");

    public static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)HerbsAndHarvest.prefix(name));
    }

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter features = context.lookup(Registries.CONFIGURED_FEATURE);
        HolderGetter biomes = context.lookup(Registries.BIOME);
        context.register(AVOCADO_FRUIT_PLACEMENT, (Object)new PlacedFeature((Holder)features.getOrThrow(MHHConfiguredFeatures.AVOCADO_FRUIT_TREE), MHHPlacements.ModTreeCheckArea((PlacementModifier)RarityFilter.onAverageOnceEvery((int)100), ((Block)MHHBlocks.AVOCADO_FRUIT_SAPLING.get()).defaultBlockState())));
        context.register(CHERRY_FRUIT_PLACEMENT, (Object)new PlacedFeature((Holder)features.getOrThrow(MHHConfiguredFeatures.CHERRY_FRUIT_TREE), MHHPlacements.ModTreeCheckArea((PlacementModifier)RarityFilter.onAverageOnceEvery((int)100), ((Block)MHHBlocks.CHERRY_FRUIT_SAPLING.get()).defaultBlockState())));
        context.register(LEMON_FRUIT_PLACEMENT, (Object)new PlacedFeature((Holder)features.getOrThrow(MHHConfiguredFeatures.LEMON_FRUIT_TREE), MHHPlacements.ModTreeCheckArea((PlacementModifier)RarityFilter.onAverageOnceEvery((int)100), ((Block)MHHBlocks.LEMON_FRUIT_SAPLING.get()).defaultBlockState())));
        context.register(LIME_FRUIT_PLACEMENT, (Object)new PlacedFeature((Holder)features.getOrThrow(MHHConfiguredFeatures.LIME_FRUIT_TREE), MHHPlacements.ModTreeCheckArea((PlacementModifier)RarityFilter.onAverageOnceEvery((int)100), ((Block)MHHBlocks.LIME_FRUIT_SAPLING.get()).defaultBlockState())));
        context.register(ORANGE_FRUIT_PLACEMENT, (Object)new PlacedFeature((Holder)features.getOrThrow(MHHConfiguredFeatures.ORANGE_FRUIT_TREE), MHHPlacements.ModTreeCheckArea((PlacementModifier)RarityFilter.onAverageOnceEvery((int)100), ((Block)MHHBlocks.ORANGE_FRUIT_SAPLING.get()).defaultBlockState())));
        context.register(PEACH_FRUIT_PLACEMENT, (Object)new PlacedFeature((Holder)features.getOrThrow(MHHConfiguredFeatures.PEACH_FRUIT_TREE), MHHPlacements.ModTreeCheckArea((PlacementModifier)RarityFilter.onAverageOnceEvery((int)100), ((Block)MHHBlocks.PEACH_FRUIT_SAPLING.get()).defaultBlockState())));
        context.register(PEAR_FRUIT_PLACEMENT, (Object)new PlacedFeature((Holder)features.getOrThrow(MHHConfiguredFeatures.PEAR_FRUIT_TREE), MHHPlacements.ModTreeCheckArea((PlacementModifier)RarityFilter.onAverageOnceEvery((int)100), ((Block)MHHBlocks.PEAR_FRUIT_SAPLING.get()).defaultBlockState())));
        context.register(PLUM_FRUIT_PLACEMENT, (Object)new PlacedFeature((Holder)features.getOrThrow(MHHConfiguredFeatures.PLUM_FRUIT_TREE), MHHPlacements.ModTreeCheckArea((PlacementModifier)RarityFilter.onAverageOnceEvery((int)100), ((Block)MHHBlocks.PLUM_FRUIT_SAPLING.get()).defaultBlockState())));
    }

    private static List<PlacementModifier> ModTreeCheckArea(PlacementModifier count, BlockState sapling) {
        return ImmutableList.of((Object)count, (Object)InSquarePlacement.spread(), (Object)SurfaceWaterDepthFilter.forMaxDepth((int)0), (Object)PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, (Object)PlacementUtils.filteredByBlockSurvival((Block)sapling.getBlock()), (Object)BiomeFilter.biome());
    }
}

