/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.packet;

import de.ellpeck.naturesaura.items.ItemRangeVisualizer;
import de.ellpeck.naturesaura.items.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketClient(int packetType, CompoundTag data) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketClient> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"naturesaura", (String)"client"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketClient> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, PacketClient::packetType, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, PacketClient::data, PacketClient::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onMessage(PacketClient message, IPayloadContext ctx) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null) {
            switch (message.packetType) {
                case 0: {
                    ResourceLocation goalDim = ResourceLocation.parse((String)message.data.getString("dim"));
                    BlockPos goalPos = BlockPos.of((long)message.data.getLong("pos"));
                    ItemRangeVisualizer.visualize((Player)mc.player, ItemRangeVisualizer.VISUALIZED_RAILS, goalDim, goalPos);
                }
                case 1: {
                    Entity entity = mc.level.getEntity(message.data.getInt("id"));
                    mc.particleEngine.createTrackingEmitter(entity, (ParticleOptions)ParticleTypes.TOTEM_OF_UNDYING, 30);
                    mc.level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), SoundEvents.TOTEM_USE, entity.getSoundSource(), 1.0f, 1.0f, false);
                    if (entity != mc.player) break;
                    mc.gameRenderer.displayItemActivation(new ItemStack((ItemLike)ModItems.DEATH_RING));
                }
            }
        }
    }
}

