/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import com.google.common.base.Strings;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.misc.ILevelData;
import de.ellpeck.naturesaura.blocks.BlockEnderCrate;
import de.ellpeck.naturesaura.gui.ContainerEnderCrate;
import de.ellpeck.naturesaura.gui.ModContainers;
import de.ellpeck.naturesaura.items.ItemImpl;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class ItemEnderAccess
extends ItemImpl {
    public ItemEnderAccess() {
        super("ender_access");
    }

    public InteractionResultHolder<ItemStack> use(Level levelIn, Player playerIn, InteractionHand handIn) {
        if (handIn != InteractionHand.MAIN_HAND) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)playerIn.getItemInHand(handIn));
        }
        ItemStack stack = playerIn.getMainHandItem();
        final String name = BlockEnderCrate.getEnderName(stack);
        if (!Strings.isNullOrEmpty((String)name)) {
            if (!levelIn.isClientSide && NaturesAuraAPI.instance().extractAuraFromPlayer(playerIn, 10000, false)) {
                playerIn.openMenu(new MenuProvider(){

                    public Component getDisplayName() {
                        return Component.translatable((String)"info.naturesaura.ender_access", (Object[])new Object[]{String.valueOf(ChatFormatting.ITALIC) + name + String.valueOf(ChatFormatting.RESET)});
                    }

                    @Nullable
                    public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
                        IItemHandlerModifiable handler = ILevelData.getOverworldData(inv.player.level()).getEnderStorage(name);
                        return new ContainerEnderCrate(ModContainers.ENDER_ACCESS, windowId, player, (IItemHandler)handler);
                    }
                }, buffer -> buffer.writeUtf(name));
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        BlockEnderCrate.addEnderNameInfo(stack, tooltipComponents);
    }
}

