/*
 * Decompiled with CFR 0.152.
 */
package lyrellion.ars_elemancy.datagen;

import java.util.concurrent.CompletableFuture;
import lyrellion.ars_elemancy.common.items.armor.ArmorSet;
import lyrellion.ars_elemancy.registry.ModItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.DamageTypeTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AETagsProvider {

    public static class AEDamageTypeProvider
    extends DamageTypeTagsProvider {
        public AEDamageTypeProvider(DataGenerator pGenerator, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
            super(pGenerator.getPackOutput(), provider, "ars_elemancy", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
        }
    }

    public static class AEEntityTagProvider
    extends EntityTypeTagsProvider {
        public AEEntityTagProvider(DataGenerator pGenerator, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
            super(pGenerator.getPackOutput(), provider, "ars_elemancy", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
        }

        @NotNull
        public String getName() {
            return "Ars Elemental Entity Tags";
        }
    }

    public static class AEBlockTagsProvider
    extends BlockTagsProvider {
        final TagKey<Block> ARCHWOOD_LEAVES = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"leaves/archwood_leaves"));
        public static final TagKey<Block> FLASHING_LOGS = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_elemancy", (String)"logs/flashing_archwood"));

        public AEBlockTagsProvider(DataGenerator gen, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
            super(gen.getPackOutput(), provider, "ars_elemancy", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
        }

        void logsTag(Block ... blocks) {
            this.tag(BlockTags.LOGS).add((Object[])blocks);
            this.tag(BlockTags.LOGS_THAT_BURN).add((Object[])blocks);
            this.tag(BlockTags.MINEABLE_WITH_AXE).add((Object[])blocks);
        }

        void addPickMineable(int level, Block ... blocks) {
            block6: for (Block block : blocks) {
                this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object)block);
                switch (level) {
                    case 1: {
                        this.tag(BlockTags.NEEDS_STONE_TOOL).add((Object)block);
                        continue block6;
                    }
                    case 2: {
                        this.tag(BlockTags.NEEDS_IRON_TOOL).add((Object)block);
                        continue block6;
                    }
                    case 3: {
                        this.tag(BlockTags.NEEDS_DIAMOND_TOOL).add((Object)block);
                        continue block6;
                    }
                    case 4: {
                        this.tag(Tags.Blocks.NEEDS_NETHERITE_TOOL).add((Object)block);
                    }
                }
            }
        }

        @NotNull
        public String getName() {
            return "Ars Elemental Block Tags";
        }
    }

    public static class AEItemTagsProvider
    extends ItemTagsProvider {
        String[] curioSlots = new String[]{"curio", "back", "belt", "body", "bracelet", "charm", "feet", "head", "hands", "necklace", "ring"};
        public static final TagKey<Item> CURIO_SPELL_FOCUS = AEItemTagsProvider.curiosTag("an_focus");
        public static final TagKey<Item> CURIO_BANGLE = AEItemTagsProvider.curiosTag("bracelet");
        public static final TagKey<Item> SUMMON_SHARDS = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"magic_shards"));
        public static final TagKey<Item> SPELLBOOK = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"spellbook"));
        public static final TagKey<Item> PRISM_LENS = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"spell_prism_lens"));
        public static final TagKey<Item> MAGIC_HOOD = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"hood"));
        public static final TagKey<Item> MAGIC_ROBE = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"robe"));
        public static final TagKey<Item> MAGIC_LEG = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"legs"));
        public static final TagKey<Item> MAGIC_BOOT = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"boot"));
        public static final TagKey<Item> STRIPPED_LOGS = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"stripped_logs"));
        public static final TagKey<Item> STRIPPED_WOODS = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"stripped_wood"));

        static TagKey<Item> curiosTag(String key) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"curios", (String)key));
        }

        public AEItemTagsProvider(DataGenerator gen, CompletableFuture<HolderLookup.Provider> provider, BlockTagsProvider blockTagsProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(gen.getPackOutput(), provider, blockTagsProvider.contentsGetter(), "ars_elemancy", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            this.tag(CURIO_SPELL_FOCUS).add((Object)((Item)ModItems.TEMPEST_FOCUS.get())).add((Object)((Item)ModItems.MIRE_FOCUS.get())).add((Object)((Item)ModItems.SILT_FOCUS.get())).add((Object)((Item)ModItems.LAVA_FOCUS.get())).add((Object)((Item)ModItems.VAPOR_FOCUS.get())).add((Object)((Item)ModItems.CINDER_FOCUS.get())).add((Object)((Item)ModItems.ELEMANCER_FOCUS.get()));
            this.tag(CURIO_BANGLE).add((Object)((Item)ModItems.TEMPEST_BANGLE.get())).add((Object)((Item)ModItems.MIRE_BANGLE.get())).add((Object)((Item)ModItems.SILT_BANGLE.get())).add((Object)((Item)ModItems.LAVA_BANGLE.get())).add((Object)((Item)ModItems.VAPOR_BANGLE.get())).add((Object)((Item)ModItems.CINDER_BANGLE.get())).add((Object)((Item)ModItems.ELEMANCER_BANGLE.get()));
            this.addArmorTags(ModItems.TEMPEST_ARMOR);
            this.addArmorTags(ModItems.MIRE_ARMOR);
            this.addArmorTags(ModItems.SILT_ARMOR);
            this.addArmorTags(ModItems.LAVA_ARMOR);
            this.addArmorTags(ModItems.VAPOR_ARMOR);
            this.addArmorTags(ModItems.CINDER_ARMOR);
            this.addArmorTags(ModItems.ELEMANCER_ARMOR);
        }

        public void addArmorTags(ArmorSet set) {
            this.tag(ItemTags.ARMOR_ENCHANTABLE).add((Object[])new Item[]{set.getHat(), set.getChest(), set.getLegs(), set.getBoots()});
            this.tag(ItemTags.EQUIPPABLE_ENCHANTABLE).add((Object[])new Item[]{set.getHat(), set.getChest(), set.getLegs(), set.getBoots()});
            this.tag(ItemTags.DURABILITY_ENCHANTABLE).add((Object[])new Item[]{set.getHat(), set.getChest(), set.getLegs(), set.getBoots()});
            this.tag(ItemTags.HEAD_ARMOR_ENCHANTABLE).add((Object)set.getHat());
            this.tag(ItemTags.HEAD_ARMOR).add((Object)set.getHat());
            this.tag(ItemTags.CHEST_ARMOR_ENCHANTABLE).add((Object)set.getChest());
            this.tag(ItemTags.CHEST_ARMOR).add((Object)set.getChest());
            this.tag(ItemTags.LEG_ARMOR_ENCHANTABLE).add((Object)set.getLegs());
            this.tag(ItemTags.LEG_ARMOR).add((Object)set.getLegs());
            this.tag(ItemTags.FOOT_ARMOR_ENCHANTABLE).add((Object)set.getBoots());
            this.tag(ItemTags.FOOT_ARMOR).add((Object)set.getBoots());
        }

        @NotNull
        public String getName() {
            return "Ars Elemental Item Tags";
        }
    }
}

