/*
 * Decompiled with CFR 0.152.
 */
package lyrellion.ars_elemancy.datagen;

import com.hollingsworth.arsnouveau.common.block.ArchfruitPod;
import com.hollingsworth.arsnouveau.common.block.StrippableLog;
import java.util.HashSet;
import lyrellion.ars_elemancy.ArsElemancy;
import lyrellion.ars_elemancy.datagen.Datagen;
import lyrellion.ars_elemancy.registry.ModItems;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class AEBlockStateProvider
extends BlockStateProvider {
    public AEBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "ars_elemancy", exFileHelper);
    }

    protected void registerStatesAndModels() {
        HashSet blocks = new HashSet(ModItems.BLOCKS.getEntries());
        Datagen.takeAll(blocks, b -> b.get() instanceof FlowerPotBlock).forEach(this::registerOnlyState);
        Datagen.takeAll(blocks, b -> b.get() instanceof RotatedPillarBlock || b.get() instanceof StrippableLog).forEach(this::logBlock);
        Datagen.takeAll(blocks, b -> b.get() instanceof SlabBlock).forEach(this::slabBlock);
        Datagen.takeAll(blocks, b -> b.get() instanceof StairBlock).forEach(this::stairsBlock);
        Datagen.takeAll(blocks, b -> b.get() instanceof LeavesBlock);
        Datagen.takeAll(blocks, b -> b.get() instanceof SaplingBlock);
        Datagen.takeAll(blocks, b -> b.get() instanceof ArchfruitPod);
        blocks.forEach(this::basicBlock);
    }

    public void registerOnlyState(DeferredHolder<Block, ? extends Block> obj) {
        this.simpleBlock((Block)obj.get(), (ModelFile)new ModelFile.UncheckedModelFile(ArsElemancy.prefix("block/" + obj.getId().getPath())));
    }

    public void slabBlock(DeferredHolder<Block, ? extends Block> blockRegistryObject) {
        String name = blockRegistryObject.getId().getPath();
        String baseName = name.substring(0, name.length() - 5);
        this.slabBlock((SlabBlock)blockRegistryObject.get(), ArsElemancy.prefix(baseName), ArsElemancy.prefix("block/" + baseName));
    }

    public void logBlock(DeferredHolder<Block, ? extends Block> blockRegistryObject) {
    }

    public void stairsBlock(DeferredHolder<Block, ? extends Block> blockRegistryObject) {
        String name = blockRegistryObject.getId().getPath();
        String baseName = name.substring(0, name.length() - 7);
        this.stairsBlock((StairBlock)blockRegistryObject.get(), ArsElemancy.prefix("block/" + baseName));
    }

    public void basicBlock(DeferredHolder<Block, ? extends Block> blockRegistryObject) {
        this.simpleBlock((Block)blockRegistryObject.get());
    }

    @NotNull
    public String getName() {
        return "Ars Elemental BlockStates";
    }
}

