/*
 * Decompiled with CFR 0.152.
 */
package lyrellion.ars_elemancy.datagen;

import alexthw.ars_elemental.common.items.armor.ArmorSet;
import alexthw.ars_elemental.registry.ModItems;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeBuilder;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeProvider;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import lyrellion.ars_elemancy.ArsElemancy;
import lyrellion.ars_elemancy.recipe.ElemancyArmorRecipe;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;

public class AEApparatusProvider
extends ApparatusRecipeProvider {
    public static List<ApparatusRecipeBuilder.RecipeWrapper<? extends EnchantingApparatusRecipe>> RECIPES = List.of();
    static Object2IntArrayMap<Item> OUTPUT_COUNTER = new Object2IntArrayMap();

    public AEApparatusProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void collectJsons(CachedOutput cache) {
        this.addCombinedRecipes(lyrellion.ars_elemancy.registry.ModItems.TEMPEST_BANGLE, lyrellion.ars_elemancy.registry.ModItems.TEMPEST_ESSENCE, 7000, List.of(ModItems.AIR_BANGLE, ModItems.WATER_BANGLE));
        this.addCombinedRecipes(lyrellion.ars_elemancy.registry.ModItems.CINDER_BANGLE, lyrellion.ars_elemancy.registry.ModItems.CINDER_ESSENCE, 7000, List.of(ModItems.AIR_BANGLE, ModItems.FIRE_BANGLE));
        this.addCombinedRecipes(lyrellion.ars_elemancy.registry.ModItems.SILT_BANGLE, lyrellion.ars_elemancy.registry.ModItems.SILT_ESSENCE, 7000, List.of(ModItems.AIR_BANGLE, ModItems.EARTH_BANGLE));
        this.addCombinedRecipes(lyrellion.ars_elemancy.registry.ModItems.MIRE_BANGLE, lyrellion.ars_elemancy.registry.ModItems.MIRE_ESSENCE, 7000, List.of(ModItems.EARTH_BANGLE, ModItems.WATER_BANGLE));
        this.addCombinedRecipes(lyrellion.ars_elemancy.registry.ModItems.VAPOR_BANGLE, lyrellion.ars_elemancy.registry.ModItems.VAPOR_ESSENCE, 7000, List.of(ModItems.FIRE_BANGLE, ModItems.WATER_BANGLE));
        this.addCombinedRecipes(lyrellion.ars_elemancy.registry.ModItems.LAVA_BANGLE, lyrellion.ars_elemancy.registry.ModItems.LAVA_ESSENCE, 7000, List.of(ModItems.FIRE_BANGLE, ModItems.EARTH_BANGLE));
        this.addCombinedRecipes(lyrellion.ars_elemancy.registry.ModItems.ELEMANCER_BANGLE, lyrellion.ars_elemancy.registry.ModItems.ELEMANCER_ESSENCE, 7000, List.of(lyrellion.ars_elemancy.registry.ModItems.TEMPEST_BANGLE, lyrellion.ars_elemancy.registry.ModItems.LAVA_BANGLE));
        this.addCombinedRecipes(lyrellion.ars_elemancy.registry.ModItems.ELEMANCER_BANGLE, lyrellion.ars_elemancy.registry.ModItems.ELEMANCER_ESSENCE, 7000, List.of(lyrellion.ars_elemancy.registry.ModItems.CINDER_BANGLE, lyrellion.ars_elemancy.registry.ModItems.MIRE_BANGLE));
        this.addCombinedRecipes(lyrellion.ars_elemancy.registry.ModItems.ELEMANCER_BANGLE, lyrellion.ars_elemancy.registry.ModItems.ELEMANCER_ESSENCE, 7000, List.of(lyrellion.ars_elemancy.registry.ModItems.SILT_BANGLE, lyrellion.ars_elemancy.registry.ModItems.VAPOR_BANGLE));
        this.recipes.add(this.builder().withResult((ItemLike)lyrellion.ars_elemancy.registry.ModItems.CINDER_FOCUS.get()).withReagent((ItemLike)lyrellion.ars_elemancy.registry.ModItems.CINDER_ESSENCE).withPedestalItem((ItemLike)ModItems.FIRE_FOCUS).withPedestalItem((ItemLike)ModItems.AIR_FOCUS).build());
        this.recipes.add(this.builder().withResult((ItemLike)lyrellion.ars_elemancy.registry.ModItems.LAVA_FOCUS.get()).withReagent((ItemLike)lyrellion.ars_elemancy.registry.ModItems.LAVA_ESSENCE).withPedestalItem((ItemLike)ModItems.FIRE_FOCUS).withPedestalItem((ItemLike)ModItems.EARTH_FOCUS).build());
        this.recipes.add(this.builder().withResult((ItemLike)lyrellion.ars_elemancy.registry.ModItems.VAPOR_FOCUS.get()).withReagent((ItemLike)lyrellion.ars_elemancy.registry.ModItems.VAPOR_ESSENCE).withPedestalItem((ItemLike)ModItems.FIRE_FOCUS).withPedestalItem((ItemLike)ModItems.WATER_FOCUS).build());
        this.recipes.add(this.builder().withResult((ItemLike)lyrellion.ars_elemancy.registry.ModItems.SILT_FOCUS.get()).withReagent((ItemLike)lyrellion.ars_elemancy.registry.ModItems.SILT_ESSENCE).withPedestalItem((ItemLike)ModItems.EARTH_FOCUS).withPedestalItem((ItemLike)ModItems.AIR_FOCUS).build());
        this.recipes.add(this.builder().withResult((ItemLike)lyrellion.ars_elemancy.registry.ModItems.MIRE_FOCUS.get()).withReagent((ItemLike)lyrellion.ars_elemancy.registry.ModItems.MIRE_ESSENCE).withPedestalItem((ItemLike)ModItems.EARTH_FOCUS).withPedestalItem((ItemLike)ModItems.WATER_FOCUS).build());
        this.recipes.add(this.builder().withResult((ItemLike)lyrellion.ars_elemancy.registry.ModItems.TEMPEST_FOCUS.get()).withReagent((ItemLike)lyrellion.ars_elemancy.registry.ModItems.TEMPEST_ESSENCE).withPedestalItem((ItemLike)ModItems.WATER_FOCUS).withPedestalItem((ItemLike)ModItems.AIR_FOCUS).build());
        this.recipes.add(this.builder().withResult((ItemLike)lyrellion.ars_elemancy.registry.ModItems.ELEMANCER_FOCUS.get()).withReagent((ItemLike)lyrellion.ars_elemancy.registry.ModItems.ELEMANCER_ESSENCE).withPedestalItem((ItemLike)ModItems.FIRE_FOCUS).withPedestalItem((ItemLike)ModItems.AIR_FOCUS).withPedestalItem((ItemLike)ModItems.EARTH_FOCUS).withPedestalItem((ItemLike)ModItems.WATER_FOCUS).build());
        this.addArmorRecipes(lyrellion.ars_elemancy.registry.ModItems.TEMPEST_ARMOR, lyrellion.ars_elemancy.registry.ModItems.TEMPEST_ESSENCE, List.of(this.armorSet(ModItems.AIR_ARMOR), this.armorSet(ModItems.WATER_ARMOR)));
        this.addArmorRecipes(lyrellion.ars_elemancy.registry.ModItems.CINDER_ARMOR, lyrellion.ars_elemancy.registry.ModItems.CINDER_ESSENCE, List.of(this.armorSet(ModItems.AIR_ARMOR), this.armorSet(ModItems.FIRE_ARMOR)));
        this.addArmorRecipes(lyrellion.ars_elemancy.registry.ModItems.SILT_ARMOR, lyrellion.ars_elemancy.registry.ModItems.SILT_ESSENCE, List.of(this.armorSet(ModItems.AIR_ARMOR), this.armorSet(ModItems.EARTH_ARMOR)));
        this.addArmorRecipes(lyrellion.ars_elemancy.registry.ModItems.MIRE_ARMOR, lyrellion.ars_elemancy.registry.ModItems.MIRE_ESSENCE, List.of(this.armorSet(ModItems.EARTH_ARMOR), this.armorSet(ModItems.WATER_ARMOR)));
        this.addArmorRecipes(lyrellion.ars_elemancy.registry.ModItems.VAPOR_ARMOR, lyrellion.ars_elemancy.registry.ModItems.VAPOR_ESSENCE, List.of(this.armorSet(ModItems.FIRE_ARMOR), this.armorSet(ModItems.WATER_ARMOR)));
        this.addArmorRecipes(lyrellion.ars_elemancy.registry.ModItems.LAVA_ARMOR, lyrellion.ars_elemancy.registry.ModItems.LAVA_ESSENCE, List.of(this.armorSet(ModItems.FIRE_ARMOR), this.armorSet(ModItems.EARTH_ARMOR)));
        this.addArmorRecipes(lyrellion.ars_elemancy.registry.ModItems.ELEMANCER_ARMOR, lyrellion.ars_elemancy.registry.ModItems.ELEMANCER_ESSENCE, List.of(this.armorSet(lyrellion.ars_elemancy.registry.ModItems.TEMPEST_ARMOR), this.armorSet(lyrellion.ars_elemancy.registry.ModItems.LAVA_ARMOR)));
        this.addArmorRecipes(lyrellion.ars_elemancy.registry.ModItems.ELEMANCER_ARMOR, lyrellion.ars_elemancy.registry.ModItems.ELEMANCER_ESSENCE, List.of(this.armorSet(lyrellion.ars_elemancy.registry.ModItems.CINDER_ARMOR), this.armorSet(lyrellion.ars_elemancy.registry.ModItems.MIRE_ARMOR)));
        this.addArmorRecipes(lyrellion.ars_elemancy.registry.ModItems.ELEMANCER_ARMOR, lyrellion.ars_elemancy.registry.ModItems.ELEMANCER_ESSENCE, List.of(this.armorSet(lyrellion.ars_elemancy.registry.ModItems.SILT_ARMOR), this.armorSet(lyrellion.ars_elemancy.registry.ModItems.VAPOR_ARMOR)));
        Path output = this.generator.getPackOutput().getOutputFolder();
        for (ApparatusRecipeBuilder.RecipeWrapper g : this.recipes) {
            if (g == null) continue;
            Path path = AEApparatusProvider.getRecipePath(output, g.id().getPath());
            this.saveStable(cache, g.serialize(), path);
        }
        RECIPES = new ArrayList<ApparatusRecipeBuilder.RecipeWrapper<? extends EnchantingApparatusRecipe>>(this.recipes);
        RECIPES.sort(Comparator.comparing(w -> w.id().getPath()));
    }

    ArmorSetData armorSet(ArmorSet set) {
        return new ArmorSetData(set.getHat(), set.getChest(), set.getLegs(), set.getBoots());
    }

    ArmorSetData armorSet(lyrellion.ars_elemancy.common.items.armor.ArmorSet set) {
        return new ArmorSetData(set.getHat(), set.getChest(), set.getLegs(), set.getBoots());
    }

    protected void addArmorRecipes(lyrellion.ars_elemancy.common.items.armor.ArmorSet armorSet, DeferredHolder<Item, ?> essenceHolder, List<ArmorSetData> bases) {
        if (bases.size() < 2) {
            throw new IllegalArgumentException("needs at least 2 armor bases");
        }
        Item essence = (Item)essenceHolder.get();
        ArrayList[] pieceTypes = new ArrayList[4];
        for (int i = 0; i < 4; ++i) {
            pieceTypes[i] = new ArrayList();
        }
        pieceTypes[0].add(armorSet.getHat());
        pieceTypes[1].add(armorSet.getChest());
        pieceTypes[2].add(armorSet.getLegs());
        pieceTypes[3].add(armorSet.getBoots());
        for (ArmorSetData base : bases) {
            pieceTypes[0].add(base.hat);
            pieceTypes[1].add(base.chest);
            pieceTypes[2].add(base.legs);
            pieceTypes[3].add(base.boots);
        }
        for (int i = 0; i < 4; ++i) {
            ArrayList pieces = pieceTypes[i];
            Item piece = (Item)pieces.getFirst();
            for (int j = 1; j < pieces.size(); ++j) {
                Item reagent = (Item)pieces.get(j);
                ApparatusRecipeBuilder builder = this.Abuilder().withResult((ItemLike)piece).withReagent((ItemLike)reagent).withPedestalItem((ItemLike)ModItems.MARK_OF_MASTERY).withPedestalItem(2, (ItemLike)essence).withSourceCost(7000).keepNbtOfReagent(true).withId(ArsElemancy.prefix(BuiltInRegistries.ITEM.getKey((Object)piece).getPath() + "_" + String.valueOf(OUTPUT_COUNTER.compute((Object)piece, (k, v) -> v == null ? 1 : v + 1))));
                for (int k2 = 1; k2 < pieces.size(); ++k2) {
                    if (j == k2) continue;
                    builder = builder.withPedestalItem((ItemLike)pieces.get(k2));
                }
                this.recipes.add(builder.build());
            }
        }
    }

    protected void addCombinedRecipes(DeferredHolder<Item, ?> resultHolder, DeferredHolder<Item, ?> essenceHolder, int source, List<DeferredHolder<Item, ?>> bases) {
        if (bases.size() < 2) {
            throw new IllegalArgumentException("needs at least 2 bases");
        }
        Item result = (Item)resultHolder.get();
        Item essence = (Item)essenceHolder.get();
        for (int j = 0; j < bases.size(); ++j) {
            Item reagent = (Item)bases.get(j).get();
            ApparatusRecipeBuilder builder = this.Abuilder().withResult((ItemLike)result).withReagent((ItemLike)reagent).withPedestalItem((ItemLike)ModItems.MARK_OF_MASTERY).withPedestalItem(2, (ItemLike)essence).withSourceCost(source).keepNbtOfReagent(true).withId(ArsElemancy.prefix(BuiltInRegistries.ITEM.getKey((Object)result).getPath() + "_" + String.valueOf(OUTPUT_COUNTER.compute((Object)result, (k, v) -> v == null ? 1 : v + 1))));
            for (int k2 = 0; k2 < bases.size(); ++k2) {
                if (j == k2) continue;
                builder = builder.withPedestalItem((ItemLike)bases.get(k2).get());
            }
            this.recipes.add(builder.build());
        }
    }

    protected static Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/ars_elemancy/recipe/" + str + ".json");
    }

    public String getName() {
        return "Ars Elemancy Apparatus";
    }

    ArmorBuilder Abuilder() {
        return new ArmorBuilder();
    }

    public record ArmorSetData(Item hat, Item chest, Item legs, Item boots) {
    }

    public static class ArmorBuilder
    extends ApparatusRecipeBuilder {
        public ApparatusRecipeBuilder.RecipeWrapper<EnchantingApparatusRecipe> build() {
            ApparatusRecipeBuilder.RecipeWrapper wrapper = super.build();
            return new ApparatusRecipeBuilder.RecipeWrapper(wrapper.id(), (EnchantingApparatusRecipe)new ElemancyArmorRecipe(wrapper.recipe().reagent(), wrapper.recipe().result(), wrapper.recipe().pedestalItems(), wrapper.recipe().sourceCost()), ElemancyArmorRecipe.CODEC);
        }
    }
}

