/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.client.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mrcrayfish.framework.platform.ClientServices;
import com.mrcrayfish.framework.util.GsonUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.util.GsonHelper;
import org.joml.Vector3f;

public class OpenModelDeserializer
extends BlockModel.Deserializer {
    public static final OpenModelDeserializer INSTANCE = new OpenModelDeserializer();

    public List<BlockElement> getElements(JsonDeserializationContext context, JsonObject object) {
        try {
            ArrayList<BlockElement> list = new ArrayList<BlockElement>();
            for (JsonElement element : GsonHelper.getAsJsonArray((JsonObject)object, (String)"components", (JsonArray)new JsonArray())) {
                list.add(this.readBlockElement(element, context));
            }
            return list;
        }
        catch (Exception e) {
            throw new JsonParseException((Throwable)e);
        }
    }

    private BlockElement readBlockElement(JsonElement element, JsonDeserializationContext context) throws Exception {
        JsonObject object = element.getAsJsonObject();
        Vector3f from = GsonUtils.getVector3f(object, "from");
        Vector3f to = GsonUtils.getVector3f(object, "to");
        JsonObject rotation = GsonHelper.getAsJsonObject((JsonObject)object, (String)"rotation", (JsonObject)new JsonObject());
        float angle = GsonHelper.getAsFloat((JsonObject)rotation, (String)"angle", (float)0.0f);
        JsonArray zero = new JsonArray();
        zero.add((Number)Float.valueOf(0.0f));
        zero.add((Number)Float.valueOf(0.0f));
        zero.add((Number)Float.valueOf(0.0f));
        object.add("from", (JsonElement)zero);
        object.add("to", (JsonElement)zero);
        rotation.addProperty("angle", (Number)Float.valueOf(0.0f));
        BlockElement e = ClientServices.CLIENT.deserializeBlockElement(element, context);
        BlockElementRotation r = e.rotation != null ? new BlockElementRotation(e.rotation.origin(), e.rotation.axis(), angle, e.rotation.rescale()) : null;
        return new BlockElement(from, to, e.faces, r, e.shade);
    }
}

