/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.config;

import com.electronwill.nightconfig.core.ConfigSpec;
import com.google.common.base.Preconditions;
import com.mrcrayfish.framework.api.config.AbstractProperty;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public final class BoolProperty
extends AbstractProperty<Boolean> {
    BoolProperty(boolean defaultValue) {
        super(defaultValue);
    }

    @Override
    public StreamCodec<ByteBuf, Boolean> streamCodec() {
        return ByteBufCodecs.BOOL;
    }

    @Override
    public void defineSpec(ConfigSpec spec) {
        Preconditions.checkState((this.data != null ? 1 : 0) != 0, (Object)"Config property is not initialized yet");
        spec.define(this.data.getPath(), this.defaultValue);
    }

    @Override
    public boolean isValid(Boolean value) {
        return value != null;
    }

    @Override
    public String getAllowedValuesString() {
        return "Valid values: true, false";
    }

    public static BoolProperty create(boolean defaultValue) {
        return new BoolProperty(defaultValue);
    }
}

