/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.collect.Sets;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.Date;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.TraceableException;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.ModIdentification;

public class WailaExceptionHandler {
    private static final Set<IJadeProvider> ERRORS = Sets.newConcurrentHashSet();
    private static boolean NULL_ERROR = false;
    private static final File ERROR_OUTPUT = new File("logs", "JadeErrorOutput.txt");

    public static void handleErr(Throwable e, @Nullable IJadeProvider provider, @Nullable Consumer<Component> tooltip) {
        if (CommonProxy.isDevEnv()) {
            ExceptionUtils.wrapAndThrow((Throwable)e);
            return;
        }
        if (provider == null) {
            if (!NULL_ERROR) {
                NULL_ERROR = true;
                WailaExceptionHandler.writeLog(e, null);
            }
        } else if (!ERRORS.contains(provider)) {
            ERRORS.add(provider);
            WailaExceptionHandler.writeLog(e, provider);
        }
        if (tooltip != null) {
            String modid = null;
            if (e instanceof TraceableException) {
                TraceableException traceableException = (TraceableException)e;
                modid = traceableException.getNamespace();
            } else if (provider != null) {
                modid = provider.getUid().getNamespace();
            }
            if (modid == null || "minecraft".equals(modid)) {
                modid = "jade";
            } else if (modid.startsWith("jadeaddons.")) {
                modid = "jadeaddons";
            }
            tooltip.accept((Component)Component.translatable((String)"jade.error", (Object[])new Object[]{ModIdentification.getModName(modid).orElse(modid)}).withStyle(ChatFormatting.DARK_RED));
        }
    }

    private static void writeLog(Throwable e, IJadeProvider provider) {
        Jade.LOGGER.error("Caught unhandled exception : [{}] {}", (Object)provider, (Object)e);
        Jade.LOGGER.error("See JadeErrorOutput.txt for more information");
        Jade.LOGGER.error("", e);
        try {
            FileUtils.writeStringToFile((File)ERROR_OUTPUT, (String)(DateFormat.getDateTimeInstance().format(new Date()) + "\n" + String.valueOf(provider) + "\n" + ExceptionUtils.getStackTrace((Throwable)e) + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

