/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.access;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.ZombieVillager;
import snownee.jade.JadeClient;
import snownee.jade.addon.access.AccessibilityPlugin;
import snownee.jade.addon.core.ObjectNameProvider;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;

public class EntityDetailsProvider
implements IEntityComponentProvider {
    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        Saddleable saddleable;
        Shearable shearable;
        LivingEntity livingEntity;
        Goat goat;
        ZombieVillager zombieVillager;
        WitherBoss witherBoss;
        Creeper creeper;
        Entity entity = accessor.getEntity();
        if (entity instanceof Creeper && (creeper = (Creeper)entity).isPowered()) {
            AccessibilityPlugin.replaceTitle(tooltip, "creeper.powered");
        } else if (entity instanceof WitherBoss && (witherBoss = (WitherBoss)entity).isPowered()) {
            AccessibilityPlugin.replaceTitle(tooltip, "wither.powered");
        } else if (entity instanceof ZombieVillager && (zombieVillager = (ZombieVillager)entity).isConverting()) {
            AccessibilityPlugin.replaceTitle(tooltip, "zombie_villager.curing");
        } else if (entity instanceof Goat && !(goat = (Goat)entity).hasLeftHorn() && !goat.hasRightHorn()) {
            AccessibilityPlugin.replaceTitle(tooltip, "goat.hornless");
        } else if (entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            AccessibilityPlugin.replaceTitle(tooltip, "entity." + sheep.getColor().getSerializedName());
        } else if (entity instanceof Bee) {
            Bee bee = (Bee)entity;
            if (bee.hasNectar()) {
                AccessibilityPlugin.replaceTitle(tooltip, "bee.nectar");
            }
            if (bee.isAngry()) {
                AccessibilityPlugin.replaceTitle(tooltip, "entity.angry");
            }
        } else if (entity instanceof Slime) {
            Slime slime = (Slime)entity;
            String message = tooltip.getMessage(JadeIds.CORE_OBJECT_NAME);
            MutableComponent title = IThemeHelper.get().title(JadeClient.format("jade.access.slime.size", message, slime.getSize()));
            tooltip.replace(JadeIds.CORE_OBJECT_NAME, (Component)title);
        }
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isBaby()) {
            AccessibilityPlugin.replaceTitle(tooltip, "entity.baby");
        }
        if (entity instanceof Shearable && !(shearable = (Shearable)entity).readyForShearing()) {
            AccessibilityPlugin.replaceTitle(tooltip, "entity.sheared");
        }
        if (entity instanceof Saddleable && (saddleable = (Saddleable)entity).isSaddled()) {
            AccessibilityPlugin.replaceTitle(tooltip, "entity.saddled");
        }
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.ACCESS_ENTITY_DETAILS;
    }

    @Override
    public int getDefaultPriority() {
        return ObjectNameProvider.getEntity().getDefaultPriority() + 10;
    }
}

