/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.world.util;

import com.google.common.collect.ImmutableList;
import com.yungnickyoung.minecraft.betterendisland.BetterEndIslandCommon;
import com.yungnickyoung.minecraft.betterendisland.world.feature.BetterSpikeFeature;
import com.yungnickyoung.minecraft.betterendisland.world.util.WorldgenUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.SpikeConfiguration;
import net.minecraft.world.phys.AABB;

public class EndSpikeUtils {
    public static void resetSpikes(ServerLevel serverLevel, List<SpikeFeature.EndSpike> spikes) {
        spikes.forEach(spike -> {
            int resetRadius = 11;
            int verticalRadius = BetterEndIslandCommon.betterEnd ? 40 : 30;
            for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)new BlockPos(spike.getCenterX() - resetRadius, spike.getHeight() - verticalRadius, spike.getCenterZ() - resetRadius), (BlockPos)new BlockPos(spike.getCenterX() + resetRadius, spike.getHeight() + verticalRadius, spike.getCenterZ() + resetRadius))) {
                if (serverLevel.getBlockState(blockPos).is(Blocks.END_STONE)) continue;
                serverLevel.removeBlock(blockPos, false);
            }
            SpikeConfiguration spikeConfig = new SpikeConfiguration(true, (List)ImmutableList.of((Object)spike), null);
            BetterSpikeFeature.placeSpike((ServerLevelAccessor)serverLevel, RandomSource.create(), spikeConfig, spike, true);
        });
    }

    public static void removeVanillaPillars(ServerLevel serverLevel) {
        int obsidianRemoved = 0;
        RandomSource randomSource = RandomSource.create((long)serverLevel.getSeed());
        long seed = randomSource.nextLong() & 0xFFFFL;
        IntArrayList indexes = Util.toShuffledList((IntStream)IntStream.range(0, 10), (RandomSource)RandomSource.create((long)seed));
        for (int i = 0; i < 10; ++i) {
            int x = Mth.floor((double)(42.0 * Math.cos(2.0 * (-Math.PI + 0.3141592653589793 * (double)i))));
            int z = Mth.floor((double)(42.0 * Math.sin(2.0 * (-Math.PI + 0.3141592653589793 * (double)i))));
            int index = indexes.get(i);
            int radius = 2 + index / 3;
            int height = 76 + index * 3;
            boolean isGuarded = index == 1 || index == 2;
            AABB topBoundingBox = new AABB((double)(x - radius), (double)DimensionType.MIN_Y, (double)(z - radius), (double)(x + radius), (double)DimensionType.MAX_Y, (double)(z + radius));
            serverLevel.getEntitiesOfClass(EndCrystal.class, topBoundingBox).forEach(Entity::discard);
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)new BlockPos(x - radius, serverLevel.getMinBuildHeight(), z - radius), (BlockPos)new BlockPos(x + radius, height + 20, z + radius))) {
                BlockState blockState;
                if (!(pos.distToLowCornerSqr((double)x, (double)pos.getY(), (double)z) <= (double)(radius * radius + 1)) || !(blockState = serverLevel.getBlockState(pos)).is(Blocks.OBSIDIAN) && !blockState.is(Blocks.BEDROCK)) continue;
                serverLevel.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                if (!blockState.is(Blocks.OBSIDIAN)) continue;
                ++obsidianRemoved;
            }
            if (obsidianRemoved > 10) {
                int offset = radius + 1;
                int topY = -1;
                int surfaceY = WorldgenUtils.getSurfacePosAt((Level)serverLevel, x - offset, z - offset);
                if (surfaceY > topY) {
                    topY = surfaceY;
                }
                if ((surfaceY = WorldgenUtils.getSurfacePosAt((Level)serverLevel, x - offset, z + offset)) > topY) {
                    topY = surfaceY;
                }
                if ((surfaceY = WorldgenUtils.getSurfacePosAt((Level)serverLevel, x + offset, z - offset)) > topY) {
                    topY = surfaceY;
                }
                if ((surfaceY = WorldgenUtils.getSurfacePosAt((Level)serverLevel, x + offset, z + offset)) > topY) {
                    topY = surfaceY;
                }
                int bottomY = 255;
                surfaceY = WorldgenUtils.getLowestBlockPosAt((Level)serverLevel, x - offset, z - offset);
                if (surfaceY < bottomY) {
                    bottomY = surfaceY;
                }
                if ((surfaceY = WorldgenUtils.getLowestBlockPosAt((Level)serverLevel, x - offset, z + offset)) < bottomY) {
                    bottomY = surfaceY;
                }
                if ((surfaceY = WorldgenUtils.getLowestBlockPosAt((Level)serverLevel, x + offset, z - offset)) < bottomY) {
                    bottomY = surfaceY;
                }
                if ((surfaceY = WorldgenUtils.getLowestBlockPosAt((Level)serverLevel, x + offset, z + offset)) < bottomY) {
                    bottomY = surfaceY;
                }
                if (topY != -1 && bottomY != 255) {
                    for (BlockPos pos : BlockPos.betweenClosed((BlockPos)new BlockPos(x - radius, bottomY, z - radius), (BlockPos)new BlockPos(x + radius, topY, z + radius))) {
                        BlockState blockState;
                        if (!(pos.distToLowCornerSqr((double)x, (double)pos.getY(), (double)z) <= (double)(radius * radius + 1)) || !(blockState = serverLevel.getBlockState(pos)).is(Blocks.AIR) || pos.getY() > topY || pos.getY() < bottomY) continue;
                        serverLevel.setBlockAndUpdate(pos, Blocks.END_STONE.defaultBlockState());
                    }
                }
            }
            if (!isGuarded) continue;
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (int fenceX = -2; fenceX <= 2; ++fenceX) {
                for (int fenceZ = -2; fenceZ <= 2; ++fenceZ) {
                    for (int fenceY = 0; fenceY <= 3; ++fenceY) {
                        if (Mth.abs((int)fenceX) != 2 && Mth.abs((int)fenceZ) != 2 && fenceY != 3) continue;
                        mutable.set(x + fenceX, height + fenceY, z + fenceZ);
                        serverLevel.setBlockAndUpdate((BlockPos)mutable, Blocks.AIR.defaultBlockState());
                    }
                }
            }
        }
    }
}

