/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.render;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.render.RenderConfiguration;
import com.supermartijn642.core.render.RenderStateConfiguration;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;

public class RenderUtils {
    private static final RenderConfiguration LINES = RenderConfiguration.create("supermartijn642corelib", "lines", DefaultVertexFormat.POSITION_COLOR_NORMAL, RenderConfiguration.PrimitiveType.TRIANGLE_LINES, 128, true, true, RenderStateConfiguration.builder().useShader(GameRenderer::getRendertypeLinesShader).useDefaultLineWidth().useTranslucentTransparency().useViewOffsetZLayering().disableCulling().useLessThanOrEqualDepthTest().disableDepthMask().build());
    private static final RenderConfiguration LINES_NO_DEPTH = RenderConfiguration.create("supermartijn642corelib", "lines_no_depth", DefaultVertexFormat.POSITION_COLOR_NORMAL, RenderConfiguration.PrimitiveType.TRIANGLE_LINES, 128, true, true, RenderStateConfiguration.builder().useShader(GameRenderer::getRendertypeLinesShader).useDefaultLineWidth().useTranslucentTransparency().useViewOffsetZLayering().disableCulling().disableDepthTest().disableDepthMask().build());
    private static final RenderConfiguration QUADS = RenderConfiguration.create("supermartijn642corelib", "quads", DefaultVertexFormat.POSITION_COLOR, RenderConfiguration.PrimitiveType.QUADS, 256, false, true, RenderStateConfiguration.builder().useShader(GameRenderer::getPositionColorShader).useTranslucentTransparency().disableCulling().useLessThanOrEqualDepthTest().disableDepthMask().build());
    private static final RenderConfiguration QUADS_NO_DEPTH = RenderConfiguration.create("supermartijn642corelib", "quads_no_depth", DefaultVertexFormat.POSITION_COLOR, RenderConfiguration.PrimitiveType.QUADS, 256, false, true, RenderStateConfiguration.builder().useShader(GameRenderer::getPositionColorShader).useTranslucentTransparency().disableCulling().disableDepthTest().disableDepthMask().build());

    public static Vec3 getCameraPosition() {
        return ClientUtils.getMinecraft().getEntityRenderDispatcher().camera.getPosition();
    }

    public static MultiBufferSource.BufferSource getMainBufferSource() {
        return ClientUtils.getMinecraft().renderBuffers().bufferSource();
    }

    public static void renderShape(PoseStack poseStack, BlockShape shape, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderConfiguration renderConfiguration = depthTest ? LINES : LINES_NO_DEPTH;
        MultiBufferSource.BufferSource bufferSource = RenderUtils.getMainBufferSource();
        VertexConsumer builder = renderConfiguration.begin((MultiBufferSource)bufferSource);
        PoseStack.Pose pose = poseStack.last();
        Matrix4f matrix = pose.pose();
        shape.forEachEdge((x1, y1, z1, x2, y2, z2) -> {
            Vec3 normal = new Vec3(x2 - x1, y2 - y1, z2 - z1);
            normal.normalize();
            builder.addVertex(matrix, (float)x1, (float)y1, (float)z1).setColor(red, green, blue, alpha).setNormal(pose, (float)normal.x, (float)normal.y, (float)normal.z);
            builder.addVertex(matrix, (float)x2, (float)y2, (float)z2).setColor(red, green, blue, alpha).setNormal(pose, (float)normal.x, (float)normal.y, (float)normal.z);
        });
        renderConfiguration.end(bufferSource);
    }

    public static void renderShapeSides(PoseStack poseStack, BlockShape shape, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderConfiguration renderConfiguration = depthTest ? QUADS : QUADS_NO_DEPTH;
        MultiBufferSource.BufferSource bufferSource = RenderUtils.getMainBufferSource();
        VertexConsumer builder = renderConfiguration.begin((MultiBufferSource)bufferSource);
        Matrix4f matrix = poseStack.last().pose();
        shape.forEachBox(box -> {
            float minX = (float)box.minX;
            float maxX = (float)box.maxX;
            float minY = (float)box.minY;
            float maxY = (float)box.maxY;
            float minZ = (float)box.minZ;
            float maxZ = (float)box.maxZ;
            builder.addVertex(matrix, minX, minY, minZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, minX, maxY, minZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, maxX, maxY, minZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, maxX, minY, minZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, minX, minY, maxZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, maxX, minY, maxZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, maxX, maxY, maxZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, minX, maxY, maxZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, minX, minY, minZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, maxX, minY, minZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, maxX, minY, maxZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, minX, minY, maxZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, minX, maxY, minZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, minX, maxY, maxZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, maxX, maxY, maxZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, maxX, maxY, minZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, minX, minY, minZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, minX, minY, maxZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, minX, maxY, maxZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, minX, maxY, minZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, maxX, minY, minZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, maxX, maxY, minZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, maxX, maxY, maxZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, maxX, minY, maxZ).setColor(red, green, blue, alpha);
        });
        renderConfiguration.end(bufferSource);
    }

    public static void renderShape(PoseStack poseStack, VoxelShape shape, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderUtils.renderShape(poseStack, BlockShape.create(shape), red, green, blue, alpha, depthTest);
    }

    public static void renderShapeSides(PoseStack poseStack, VoxelShape shape, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(shape), red, green, blue, alpha, depthTest);
    }

    public static void renderBox(PoseStack poseStack, AABB box, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderUtils.renderShape(poseStack, BlockShape.create(box), red, green, blue, alpha, depthTest);
    }

    public static void renderBoxSides(PoseStack poseStack, AABB box, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(box), red, green, blue, alpha, depthTest);
    }

    public static void renderShape(PoseStack poseStack, BlockShape shape, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShape(poseStack, shape, red, green, blue, 1.0f, depthTest);
    }

    public static void renderShapeSides(PoseStack poseStack, BlockShape shape, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, shape, red, green, blue, 1.0f, depthTest);
    }

    public static void renderShape(PoseStack poseStack, VoxelShape shape, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShape(poseStack, BlockShape.create(shape), red, green, blue, 1.0f, depthTest);
    }

    public static void renderShapeSides(PoseStack poseStack, VoxelShape shape, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(shape), red, green, blue, 1.0f, depthTest);
    }

    public static void renderBox(PoseStack poseStack, AABB box, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShape(poseStack, BlockShape.create(box), red, green, blue, 1.0f, depthTest);
    }

    public static void renderBoxSides(PoseStack poseStack, AABB box, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(box), red, green, blue, 1.0f, depthTest);
    }
}

