/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.raytracer;

import codechicken.lib.raytracer.IndexedVoxelShape;
import codechicken.lib.raytracer.SubHitBlockHitResult;
import codechicken.lib.vec.Vector3;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class VoxelShapeBlockHitResult
extends SubHitBlockHitResult {
    public IndexedVoxelShape shape;

    public VoxelShapeBlockHitResult(BlockHitResult other, IndexedVoxelShape shape, double dist) {
        super(other.getLocation(), other.getDirection(), other.getBlockPos(), other.isInside(), shape.getData(), dist);
        this.shape = shape;
    }

    public VoxelShapeBlockHitResult(Vector3 hit, Direction side, BlockPos pos, boolean isInside, IndexedVoxelShape shape, double dist) {
        super(hit, side, pos, isInside, shape.getData(), dist);
        this.shape = shape;
    }

    public VoxelShapeBlockHitResult(Vector3 hit, Direction side, boolean isInside, IndexedVoxelShape shape, double dist) {
        super(hit, side, BlockPos.ZERO, isInside, shape.getData(), dist);
        this.shape = shape;
    }

    protected VoxelShapeBlockHitResult(boolean isMissIn, Vec3 hit, Direction side, BlockPos pos, boolean isInside, IndexedVoxelShape shape, double dist) {
        super(isMissIn, hit, side, pos, isInside, shape.getData(), dist);
        this.shape = shape;
    }

    @Override
    public SubHitBlockHitResult withDirection(Direction newFace) {
        return new VoxelShapeBlockHitResult(this.getType() == HitResult.Type.MISS, this.getLocation(), newFace, this.getBlockPos(), this.isInside(), this.shape, this.dist);
    }

    public SubHitBlockHitResult getAsDistanceResult() {
        return new SubHitBlockHitResult(this.getType() == HitResult.Type.MISS, this.getLocation(), this.getDirection(), this.getBlockPos(), this.isInside(), this.hitInfo, this.dist);
    }

    @Override
    public String toString() {
        return super.toString().replace("}", "") + ", cuboid=" + this.shape.toString() + "}";
    }
}

