/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.raytracer;

import codechicken.lib.raytracer.IndexedVoxelShape;
import codechicken.lib.raytracer.VoxelShapeBlockHitResult;
import codechicken.lib.raytracer.VoxelShapeCache;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MultiIndexedVoxelShape
extends VoxelShape {
    private final VoxelShape merged;
    private final ImmutableSet<IndexedVoxelShape> shapes;

    public MultiIndexedVoxelShape(ImmutableSet<IndexedVoxelShape> shapes) {
        this(VoxelShapeCache.merge((ImmutableSet<VoxelShape>)((ImmutableSet)SneakyUtils.unsafeCast(shapes))), shapes);
    }

    public MultiIndexedVoxelShape(VoxelShape merged, ImmutableSet<IndexedVoxelShape> shapes) {
        super(merged.shape);
        this.merged = merged;
        this.shapes = shapes;
    }

    public DoubleList getCoords(Direction.Axis axis) {
        return this.merged.getCoords(axis);
    }

    @Nullable
    public VoxelShapeBlockHitResult clip(Vec3 start, Vec3 end, BlockPos pos) {
        VoxelShapeBlockHitResult closest = null;
        double dist = Double.MAX_VALUE;
        for (IndexedVoxelShape shape : this.shapes) {
            VoxelShapeBlockHitResult hit = shape.clip(start, end, pos);
            if (hit == null || !(dist >= hit.dist)) continue;
            closest = hit;
            dist = hit.dist;
        }
        return closest;
    }
}

