/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory.container;

import codechicken.lib.data.MCDataByteBuf;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.neoforge.network.IContainerFactory;
import org.jetbrains.annotations.Nullable;

public interface CCLMenuType<T extends AbstractContainerMenu>
extends IContainerFactory<T> {
    public static <T extends AbstractContainerMenu> MenuType<T> create(CCLMenuType<T> factory) {
        return new MenuType(factory, FeatureFlags.VANILLA_SET);
    }

    public static <T extends AbstractContainerMenu> MenuType<T> create(CCLMenuType<T> factory, FeatureFlag ... featureFlags) {
        return new MenuType(factory, FeatureFlags.REGISTRY.subset(featureFlags));
    }

    public static void openMenu(ServerPlayer player, MenuProvider provider) {
        CCLMenuType.openMenu(player, provider, null);
    }

    public static void openMenu(ServerPlayer player, MenuProvider provider, @Nullable Consumer<MCDataOutput> packet) {
        if (packet != null) {
            player.openMenu(provider, (T e) -> packet.accept(new MCDataByteBuf((ByteBuf)e)));
        } else {
            player.openMenu(provider);
        }
    }

    public T create(int var1, Inventory var2, @Nullable MCDataInput var3);

    default public T create(int windowId, Inventory inv, @Nullable RegistryFriendlyByteBuf data) {
        return this.create(windowId, inv, data != null ? new MCDataByteBuf((ByteBuf)data) : null);
    }
}

