/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.lib.geometry;

import codechicken.lib.gui.modular.ModularGui;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GeoRef;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import org.jetbrains.annotations.ApiStatus;

public interface GuiParent<T extends GuiParent<?>> {
    public double xMin();

    public double xMax();

    public double xSize();

    public double yMin();

    public double yMax();

    public double ySize();

    default public GeoRef get(GeoParam param) {
        return new GeoRef(this, param);
    }

    default public double getValue(GeoParam param) {
        return switch (param) {
            default -> throw new MatchException(null, null);
            case GeoParam.LEFT -> this.xMin();
            case GeoParam.RIGHT -> this.xMax();
            case GeoParam.WIDTH -> this.xSize();
            case GeoParam.TOP -> this.yMin();
            case GeoParam.BOTTOM -> this.yMax();
            case GeoParam.HEIGHT -> this.ySize();
        };
    }

    public List<GuiElement<?>> getChildren();

    public void addChild(GuiElement<?> var1);

    @ApiStatus.Experimental
    default public T addChild(Consumer<T> createChild) {
        createChild.accept(this);
        return (T)this;
    }

    public void adoptChild(GuiElement<?> var1);

    public void removeChild(GuiElement<?> var1);

    default public boolean isDescendantOf(GuiElement<?> ancestor) {
        return false;
    }

    public Minecraft mc();

    public Font font();

    public int scaledScreenWidth();

    public int scaledScreenHeight();

    public ModularGui getModularGui();

    default public void onScreenInit(Minecraft mc, Font font, int screenWidth, int screenHeight) {
        this.getChildren().forEach(e -> e.onScreenInit(mc, font, screenWidth, screenHeight));
    }

    default public boolean blockMouseOver(GuiElement<?> element, double mouseX, double mouseY) {
        return false;
    }
}

