/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.elements;

import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.lib.BackgroundRender;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.gui.modular.sprite.GuiTextures;
import codechicken.lib.gui.modular.sprite.Material;
import codechicken.lib.util.FormatUtil;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class GuiEnergyBar
extends GuiElement<GuiEnergyBar>
implements BackgroundRender {
    public static final DecimalFormat COMMA_FORMAT = new DecimalFormat("###,###,###,###,###", DecimalFormatSymbols.getInstance(Locale.ROOT));
    public static final Material EMPTY = GuiTextures.CCL.getUncached("widgets/energy_empty");
    public static final Material FULL = GuiTextures.CCL.getUncached("widgets/energy_full");
    private Supplier<Long> energy = () -> 0L;
    private Supplier<Long> capacity = () -> 0L;
    private Material emptyTexture = EMPTY;
    private Material fullTexture = FULL;
    private BiFunction<Long, Long, List<Component>> toolTipFormatter;

    public GuiEnergyBar(@NotNull GuiParent<?> parent) {
        super(parent);
        this.setTooltipDelay(0);
        this.setToolTipFormatter(GuiEnergyBar.defaultFormatter());
    }

    public static EnergyBar simpleBar(@NotNull GuiParent<?> parent) {
        GuiRectangle container = GuiRectangle.vanillaSlot(parent);
        GuiEnergyBar energyBar = new GuiEnergyBar(container);
        Constraints.bind(energyBar, container, 1.0);
        return new EnergyBar(container, energyBar);
    }

    public static BiFunction<Long, Long, List<Component>> defaultFormatter() {
        return (energy, capacity) -> {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.translatable((String)"ccl.energy_bar.energy_storage").withStyle(ChatFormatting.DARK_AQUA));
            boolean shift = Screen.hasShiftDown();
            tooltip.add(Component.translatable((String)"ccl.energy_bar.capacity").withStyle(ChatFormatting.GOLD).append(" ").append((Component)Component.literal((String)(shift ? FormatUtil.addCommas(capacity) : FormatUtil.formatNumber(capacity))).withStyle(ChatFormatting.GRAY).append(" ").append((Component)Component.translatable((String)"ccl.energy_bar.rf").withStyle(ChatFormatting.GRAY))));
            tooltip.add(Component.translatable((String)"ccl.energy_bar.stored").withStyle(ChatFormatting.GOLD).append(" ").append((Component)Component.literal((String)(shift ? FormatUtil.addCommas(energy) : FormatUtil.formatNumber(energy))).withStyle(ChatFormatting.GRAY)).append(" ").append((Component)Component.translatable((String)"ccl.energy_bar.rf").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.format(" (%.2f%%)", (double)energy.longValue() / (double)capacity.longValue() * 100.0)).withStyle(ChatFormatting.GRAY)));
            return tooltip;
        };
    }

    public GuiEnergyBar setEmptyTexture(Material emptyTexture) {
        this.emptyTexture = emptyTexture;
        return this;
    }

    public GuiEnergyBar setFullTexture(Material fullTexture) {
        this.fullTexture = fullTexture;
        return this;
    }

    public GuiEnergyBar setCapacity(long capacity) {
        return this.setCapacity(() -> capacity);
    }

    public GuiEnergyBar setCapacity(Supplier<Long> capacity) {
        this.capacity = capacity;
        return this;
    }

    public GuiEnergyBar setEnergy(long energy) {
        return this.setEnergy(() -> energy);
    }

    public GuiEnergyBar setEnergy(Supplier<Long> energy) {
        this.energy = energy;
        return this;
    }

    public long getEnergy() {
        return this.energy.get();
    }

    public long getCapacity() {
        return this.capacity.get();
    }

    public GuiEnergyBar setToolTipFormatter(BiFunction<Long, Long, List<Component>> toolTipFormatter) {
        this.toolTipFormatter = toolTipFormatter;
        this.setTooltip(() -> this.toolTipFormatter.apply(this.getEnergy(), this.getCapacity()));
        return this;
    }

    @Override
    public void renderBackground(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        float p = 0.0078125f;
        float height = this.getCapacity() <= 0L ? 0.0f : (float)this.ySize() * ((float)this.getEnergy() / (float)this.getCapacity());
        float texHeight = height * p;
        render.partialSprite(EMPTY.renderType(GuiRender::texColType), this.xMin(), this.yMin(), this.xMax(), this.yMax(), EMPTY.sprite(), 0.0f, 1.0f - p * (float)this.ySize(), p * (float)this.xSize(), 1.0f, -1);
        render.partialSprite(FULL.renderType(GuiRender::texColType), this.xMin(), this.yMin() + (this.ySize() - (double)height), this.xMax(), this.yMax(), FULL.sprite(), 0.0f, 1.0f - texHeight, p * (float)this.xSize(), 1.0f, -1);
    }

    public record EnergyBar(GuiRectangle container, GuiEnergyBar bar) {
    }
}

