/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.datagen.recipe;

import codechicken.lib.datagen.recipe.AbstractItemStackRecipeBuilder;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShapelessRecipeBuilder
extends AbstractItemStackRecipeBuilder<ShapelessRecipeBuilder> {
    private static final Logger logger = LogManager.getLogger();
    private final Factory factory;
    private final NonNullList<Ingredient> ingredients = NonNullList.create();
    private CraftingBookCategory category = CraftingBookCategory.MISC;

    protected ShapelessRecipeBuilder(ResourceLocation id, ItemStack result, Factory factory) {
        super(id, result);
        this.factory = factory;
    }

    public static ShapelessRecipeBuilder builder(ItemLike result) {
        return ShapelessRecipeBuilder.builder(result, 1);
    }

    public static ShapelessRecipeBuilder builder(ItemLike result, int count) {
        return ShapelessRecipeBuilder.builder(new ItemStack(result, count));
    }

    public static ShapelessRecipeBuilder builder(ItemLike result, int count, ResourceLocation id) {
        return ShapelessRecipeBuilder.builder(new ItemStack(result, count), id);
    }

    public static ShapelessRecipeBuilder builder(Supplier<? extends ItemLike> result) {
        return ShapelessRecipeBuilder.builder(result.get(), 1);
    }

    public static ShapelessRecipeBuilder builder(Supplier<? extends ItemLike> result, int count) {
        return ShapelessRecipeBuilder.builder(new ItemStack(result.get(), count));
    }

    public static ShapelessRecipeBuilder builder(Supplier<? extends ItemLike> result, int count, ResourceLocation id) {
        return ShapelessRecipeBuilder.builder(new ItemStack(result.get(), count), id);
    }

    public static ShapelessRecipeBuilder builder(ItemStack result) {
        return ShapelessRecipeBuilder.builder(result, BuiltInRegistries.ITEM.getKey((Object)result.getItem()));
    }

    public static ShapelessRecipeBuilder builder(ItemStack result, ResourceLocation id) {
        return new ShapelessRecipeBuilder(id, result, ShapelessRecipe::new);
    }

    public static ShapelessRecipeBuilder custom(ItemLike result, Factory factory) {
        return ShapelessRecipeBuilder.custom(result, 1, factory);
    }

    public static ShapelessRecipeBuilder custom(ItemLike result, int count, Factory factory) {
        return ShapelessRecipeBuilder.custom(new ItemStack(result, count), factory);
    }

    public static ShapelessRecipeBuilder custom(ItemLike result, int count, ResourceLocation id, Factory factory) {
        return ShapelessRecipeBuilder.custom(new ItemStack(result, count), id, factory);
    }

    public static ShapelessRecipeBuilder custom(ItemStack result, Factory factory) {
        return ShapelessRecipeBuilder.custom(result, BuiltInRegistries.ITEM.getKey((Object)result.getItem()), factory);
    }

    public static ShapelessRecipeBuilder custom(ItemStack result, ResourceLocation id, Factory factory) {
        return new ShapelessRecipeBuilder(id, result, factory);
    }

    public ShapelessRecipeBuilder addIngredient(TagKey<Item> tag) {
        return this.addIngredient(tag, 1);
    }

    public ShapelessRecipeBuilder addIngredient(TagKey<Item> tag, int quantity) {
        this.addAutoCriteria(tag);
        Ingredient ingredient = Ingredient.of(tag);
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add((Object)ingredient);
        }
        return this;
    }

    public ShapelessRecipeBuilder addIngredient(Supplier<? extends ItemLike> item) {
        return this.addIngredient(item.get(), 1);
    }

    public ShapelessRecipeBuilder addIngredient(Supplier<? extends ItemLike> item, int quantity) {
        this.addAutoCriteria(item.get());
        Ingredient ingredient = Ingredient.of((ItemLike[])new ItemLike[]{item.get()});
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add((Object)ingredient);
        }
        return this;
    }

    public ShapelessRecipeBuilder addIngredient(ItemLike item) {
        return this.addIngredient(item, 1);
    }

    public ShapelessRecipeBuilder addIngredient(ItemLike item, int quantity) {
        this.addAutoCriteria(item);
        Ingredient ingredient = Ingredient.of((ItemLike[])new ItemLike[]{item});
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add((Object)ingredient);
        }
        return this;
    }

    public ShapelessRecipeBuilder addIngredient(Ingredient ingredient) {
        return this.addIngredient(ingredient, 1);
    }

    public ShapelessRecipeBuilder addIngredient(Ingredient ingredient, int quantity) {
        if (this.generateCriteria) {
            logger.warn("Criteria not automatically generated for raw ingredient.", new Throwable("Here, have a stack trace"));
        }
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add((Object)ingredient);
        }
        return this;
    }

    public ShapelessRecipeBuilder category(CraftingBookCategory category) {
        this.category = category;
        return this;
    }

    @Override
    public Recipe<?> _build() {
        return this.factory.build(this.group, this.category, (ItemStack)this.result, this.ingredients);
    }

    public static interface Factory {
        public Recipe<?> build(String var1, CraftingBookCategory var2, ItemStack var3, NonNullList<Ingredient> var4);
    }
}

