/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.jearchaeology.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.jearchaeology.JEArchaeology;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class BrushingRecipe
implements Recipe<RecipeInput> {
    public final Ingredient item;
    public final float chance;
    public final Ingredient brushableBlock;

    public BrushingRecipe(Ingredient item, float chance, Ingredient brushableBlock) {
        this.item = item;
        this.chance = chance;
        this.brushableBlock = brushableBlock;
    }

    public boolean matches(RecipeInput inv, Level levelIn) {
        return false;
    }

    @Nonnull
    public ItemStack assemble(RecipeInput inv, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)JEArchaeology.BRUSH.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return (RecipeType)JEArchaeology.BRUSH_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<BrushingRecipe> {
        private static final MapCodec<BrushingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("item").forGetter(recipe -> recipe.item), (App)Codec.FLOAT.fieldOf("chance").orElse((Object)Float.valueOf(0.05f)).forGetter(recipe -> Float.valueOf(recipe.chance)), (App)Ingredient.CODEC.fieldOf("brushableBlock").forGetter(recipe -> recipe.brushableBlock)).apply((Applicative)builder, BrushingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BrushingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<BrushingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BrushingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static BrushingRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            try {
                return new BrushingRecipe((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), buffer.readFloat(), (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            }
            catch (Exception e) {
                JEArchaeology.LOGGER.error("Error reading brush recipe from packet.", (Throwable)e);
                throw e;
            }
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, BrushingRecipe recipe) {
            try {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.item);
                buffer.writeFloat(recipe.chance);
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.brushableBlock);
            }
            catch (Exception e) {
                JEArchaeology.LOGGER.error("Error writing brush recipe to packet.", (Throwable)e);
                throw e;
            }
        }
    }
}

