/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.create.mechanical_chisel;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.saw.SawFilterSlot;
import com.simibubi.create.content.processing.recipe.ProcessingInventory;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipes;
import com.supermartijn642.rechiseled.create.RechiseledCreate;
import com.supermartijn642.rechiseled.create.mechanical_chisel.MechanicalChiselBlock;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;

public class MechanicalChiselBlockEntity
extends KineticBlockEntity {
    public ProcessingInventory inventory;
    private int recipeIndex;
    private FilteringBehaviour filtering;
    private ItemStack playEvent;

    public MechanicalChiselBlockEntity(BlockPos pos, BlockState state) {
        super(RechiseledCreate.mechanical_chisel_entity, pos, state);
        this.inventory = new ProcessingInventory(this::start).withSlotLimit((Boolean)AllConfigs.server().recipes.bulkCutting.get() == false);
        this.inventory.remainingTime = -1.0f;
        this.recipeIndex = 0;
        this.playEvent = ItemStack.EMPTY;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, RechiseledCreate.mechanical_chisel_entity, (be, context) -> {
            if (context != Direction.DOWN) {
                return be.inventory;
            }
            return null;
        });
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new SawFilterSlot()).forRecipes();
        behaviours.add((BlockEntityBehaviour)this.filtering);
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this).allowingBeltFunnelsWhen(this::canProcess));
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        compound.putInt("RecipeIndex", this.recipeIndex);
        super.write(compound, registries, clientPacket);
        if (!clientPacket || this.playEvent.isEmpty()) {
            return;
        }
        compound.put("PlayEvent", this.playEvent.saveOptional(registries));
        this.playEvent = ItemStack.EMPTY;
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.inventory.deserializeNBT(registries, compound.getCompound("Inventory"));
        this.recipeIndex = compound.getInt("RecipeIndex");
        if (compound.contains("PlayEvent")) {
            this.playEvent = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)compound.getCompound("PlayEvent"));
        }
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.worldPosition).inflate(0.125);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (!this.playEvent.isEmpty()) {
            boolean isWood = false;
            Item item = this.playEvent.getItem();
            if (item instanceof BlockItem) {
                Block block = ((BlockItem)item).getBlock();
                isWood = block.getSoundType(block.defaultBlockState(), (LevelReader)this.level, this.worldPosition, null) == SoundType.WOOD;
            }
            this.spawnEventParticles(this.playEvent);
            this.playEvent = ItemStack.EMPTY;
            if (!isWood) {
                AllSoundEvents.SAW_ACTIVATE_STONE.playAt(this.level, (Vec3i)this.worldPosition, 3.0f, 1.0f, true);
            } else {
                AllSoundEvents.SAW_ACTIVATE_WOOD.playAt(this.level, (Vec3i)this.worldPosition, 3.0f, 1.0f, true);
            }
        }
    }

    public void tick() {
        super.tick();
        if (!this.canProcess()) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.inventory.remainingTime == -1.0f) {
            if (!this.inventory.isEmpty() && !this.inventory.appliedRecipe) {
                this.start(this.inventory.getStackInSlot(0));
            }
            return;
        }
        float processingSpeed = Mth.clamp((float)(Math.abs(this.getSpeed()) / 24.0f), (float)1.0f, (float)128.0f);
        this.inventory.remainingTime -= processingSpeed;
        if (this.inventory.remainingTime < 5.0f && !this.inventory.appliedRecipe) {
            if (this.level.isClientSide && !this.isVirtual()) {
                return;
            }
            this.playEvent = this.inventory.getStackInSlot(0);
            this.applyRecipe();
            this.inventory.appliedRecipe = true;
            this.inventory.recipeDuration = 20.0f;
            this.inventory.remainingTime = 20.0f;
            this.sendData();
            return;
        }
        Vec3 itemMovement = this.getItemMovementVec();
        Direction itemMovementFacing = Direction.getNearest((double)itemMovement.x, (double)itemMovement.y, (double)itemMovement.z);
        if (this.inventory.remainingTime > 0.0f) {
            return;
        }
        this.inventory.remainingTime = 0.0f;
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack tryExportingToBeltFunnel;
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack.isEmpty() || (tryExportingToBeltFunnel = ((DirectBeltInputBehaviour)this.getBehaviour(DirectBeltInputBehaviour.TYPE)).tryExportingToBeltFunnel(stack, itemMovementFacing.getOpposite(), false)) == null) continue;
            if (tryExportingToBeltFunnel.getCount() != stack.getCount()) {
                this.inventory.setStackInSlot(slot, tryExportingToBeltFunnel);
                this.notifyUpdate();
                return;
            }
            if (tryExportingToBeltFunnel.isEmpty()) continue;
            return;
        }
        BlockPos nextPos = this.worldPosition.offset((int)itemMovement.x, (int)itemMovement.y, (int)itemMovement.z);
        DirectBeltInputBehaviour behaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((BlockGetter)this.level, (BlockPos)nextPos, (BehaviourType)DirectBeltInputBehaviour.TYPE);
        if (behaviour != null) {
            boolean changed = false;
            if (!behaviour.canInsertFromSide(itemMovementFacing)) {
                return;
            }
            if (this.level.isClientSide && !this.isVirtual()) {
                return;
            }
            for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
                ItemStack remainder;
                ItemStack stack = this.inventory.getStackInSlot(slot);
                if (stack.isEmpty() || ItemStack.matches((ItemStack)(remainder = behaviour.handleInsertion(stack, itemMovementFacing, false)), (ItemStack)stack)) continue;
                this.inventory.setStackInSlot(slot, remainder);
                changed = true;
            }
            if (changed) {
                this.setChanged();
                this.sendData();
            }
            return;
        }
        Vec3 outPos = VecHelper.getCenterOf((Vec3i)this.worldPosition).add(itemMovement.scale(0.5).add(0.0, 0.5, 0.0));
        Vec3 outMotion = itemMovement.scale(0.0625).add(0.0, 0.125, 0.0);
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack.isEmpty()) continue;
            ItemEntity entityIn = new ItemEntity(this.level, outPos.x, outPos.y, outPos.z, stack);
            entityIn.setDeltaMovement(outMotion);
            this.level.addFreshEntity((Entity)entityIn);
        }
        this.inventory.clear();
        this.level.updateNeighbourForOutputSignal(this.worldPosition, this.getBlockState().getBlock());
        this.inventory.remainingTime = -1.0f;
        this.sendData();
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateCapabilities();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.inventory);
    }

    protected void spawnEventParticles(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return;
        }
        Object particleData = stack.getItem() instanceof BlockItem ? new BlockParticleOption(ParticleTypes.BLOCK, ((BlockItem)stack.getItem()).getBlock().defaultBlockState()) : new ItemParticleOption(ParticleTypes.ITEM, stack);
        RandomSource r = this.level.random;
        Vec3 v = VecHelper.getCenterOf((Vec3i)this.worldPosition).add(0.0, 0.3125, 0.0);
        for (int i = 0; i < 10; ++i) {
            Vec3 m = VecHelper.offsetRandomly((Vec3)new Vec3(0.0, 0.25, 0.0), (RandomSource)r, (float)0.125f);
            this.level.addParticle((ParticleOptions)particleData, v.x, v.y, v.z, m.x, m.y, m.y);
        }
    }

    public Vec3 getItemMovementVec() {
        boolean alongX = (Boolean)this.getBlockState().getValue((Property)MechanicalChiselBlock.AXIS_ALONG_FIRST_COORDINATE) == false;
        int offset = this.getSpeed() < 0.0f ? -1 : 1;
        return new Vec3((double)(offset * (alongX ? 1 : 0)), 0.0, (double)(offset * (alongX ? 0 : -1)));
    }

    private void applyRecipe() {
        List<ItemStack> recipes = this.getRecipes();
        if (recipes.isEmpty()) {
            return;
        }
        if (this.recipeIndex >= recipes.size()) {
            this.recipeIndex = 0;
        }
        ItemStack recipe = recipes.get(this.recipeIndex);
        int rolls = this.inventory.getStackInSlot(0).getCount();
        this.inventory.clear();
        ItemStack output = recipe.copy();
        output.setCount(rolls);
        this.inventory.setStackInSlot(1, output);
        this.award(AllAdvancements.SAW_PROCESSING);
    }

    private List<ItemStack> getRecipes() {
        ItemStack input = this.inventory.getStackInSlot(0);
        ChiselingRecipe recipe = ChiselingRecipes.getRecipe((ItemStack)input);
        if (recipe == null) {
            return Collections.emptyList();
        }
        if (this.filtering.isActive() && !this.filtering.getFilter().isEmpty()) {
            return recipe.getEntries().stream().flatMap(entry -> entry.hasConnectingItem() ? (entry.hasRegularItem() ? Stream.of(entry.getConnectingItem(), entry.getRegularItem()) : Stream.of(entry.getConnectingItem())) : Stream.of(entry.getRegularItem())).map(Item::getDefaultInstance).filter(arg_0 -> ((FilteringBehaviour)this.filtering).test(arg_0)).collect(Collectors.toList());
        }
        boolean connecting = false;
        for (ChiselingEntry entry2 : recipe.getEntries()) {
            if (entry2.getConnectingItem() == input.getItem()) {
                connecting = true;
                break;
            }
            if (entry2.getRegularItem() != input.getItem()) continue;
            break;
        }
        return recipe.getEntries().stream().filter(connecting ? ChiselingEntry::hasConnectingItem : ChiselingEntry::hasRegularItem).map(connecting ? ChiselingEntry::getConnectingItem : ChiselingEntry::getRegularItem).map(Item::getDefaultInstance).filter(arg_0 -> ((FilteringBehaviour)this.filtering).test(arg_0)).collect(Collectors.toList());
    }

    public void insertItem(ItemEntity entity) {
        if (!this.canProcess()) {
            return;
        }
        if (!this.inventory.isEmpty()) {
            return;
        }
        if (!entity.isAlive()) {
            return;
        }
        if (this.level.isClientSide) {
            return;
        }
        this.inventory.clear();
        ItemStack remainder = this.inventory.insertItem(0, entity.getItem().copy(), false);
        if (remainder.isEmpty()) {
            entity.discard();
        } else {
            entity.setItem(remainder);
        }
    }

    public void start(ItemStack inserted) {
        if (!this.canProcess()) {
            return;
        }
        if (this.inventory.isEmpty()) {
            return;
        }
        if (this.level.isClientSide && !this.isVirtual()) {
            return;
        }
        List<ItemStack> recipes = this.getRecipes();
        int time = 50;
        if (recipes.isEmpty()) {
            this.inventory.recipeDuration = 10.0f;
            this.inventory.remainingTime = 10.0f;
            this.inventory.appliedRecipe = false;
            this.sendData();
            return;
        }
        this.recipeIndex = this.level.getRandom().nextInt(recipes.size());
        if (inserted.getItem() == recipes.get(this.recipeIndex).getItem()) {
            ++this.recipeIndex;
            if (this.recipeIndex >= recipes.size()) {
                this.recipeIndex = 0;
            }
        }
        this.inventory.recipeDuration = this.inventory.remainingTime = (float)(time * Math.max(1, inserted.getCount() / 5));
        this.inventory.appliedRecipe = false;
        this.sendData();
    }

    protected boolean canProcess() {
        return this.getBlockState().getValue((Property)MechanicalChiselBlock.FACING) == Direction.UP;
    }
}

