/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings;

import com.tristankechlo.livingthings.entity.AncientBlazeEntity;
import com.tristankechlo.livingthings.entity.BabyEnderDragonEntity;
import com.tristankechlo.livingthings.entity.CrabEntity;
import com.tristankechlo.livingthings.entity.ElephantEntity;
import com.tristankechlo.livingthings.entity.FlamingoEntity;
import com.tristankechlo.livingthings.entity.GiraffeEntity;
import com.tristankechlo.livingthings.entity.KoalaEntity;
import com.tristankechlo.livingthings.entity.LionEntity;
import com.tristankechlo.livingthings.entity.MantarayEntity;
import com.tristankechlo.livingthings.entity.MonkeyEntity;
import com.tristankechlo.livingthings.entity.NetherKnightEntity;
import com.tristankechlo.livingthings.entity.OstrichEntity;
import com.tristankechlo.livingthings.entity.OwlEntity;
import com.tristankechlo.livingthings.entity.PeacockEntity;
import com.tristankechlo.livingthings.entity.PenguinEntity;
import com.tristankechlo.livingthings.entity.RaccoonEntity;
import com.tristankechlo.livingthings.entity.SeahorseEntity;
import com.tristankechlo.livingthings.entity.SharkEntity;
import com.tristankechlo.livingthings.entity.ShroomieEntity;
import com.tristankechlo.livingthings.entity.SnailEntity;
import com.tristankechlo.livingthings.init.ModArmorMaterial;
import com.tristankechlo.livingthings.init.ModBlocks;
import com.tristankechlo.livingthings.init.ModCreativeTabs;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModItems;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.mixin.SpawnPlacementsInvoker;
import java.util.function.BiConsumer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.levelgen.Heightmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LivingThings {
    public static final String MOD_ID = "livingthings";
    public static final String MOD_NAME = "Living Things";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Living Things");

    public static void init() {
        ModItems.init();
        ModBlocks.init();
        ModSounds.init();
        ModEntityTypes.init();
        ModCreativeTabs.init();
        ModArmorMaterial.init();
    }

    public static void registerMobAttributes(BiConsumer<EntityType<? extends LivingEntity>, AttributeSupplier.Builder> consumer) {
        LOGGER.info("Registering MobAttributes");
        consumer.accept(ModEntityTypes.ELEPHANT.get(), ElephantEntity.createAttributes());
        consumer.accept(ModEntityTypes.GIRAFFE.get(), GiraffeEntity.createAttributes());
        consumer.accept(ModEntityTypes.LION.get(), LionEntity.createAttributes());
        consumer.accept(ModEntityTypes.SHARK.get(), SharkEntity.createAttributes());
        consumer.accept(ModEntityTypes.PENGUIN.get(), PenguinEntity.createAttributes());
        consumer.accept(ModEntityTypes.OSTRICH.get(), OstrichEntity.createAttributes());
        consumer.accept(ModEntityTypes.FLAMINGO.get(), FlamingoEntity.createAttributes());
        consumer.accept(ModEntityTypes.CRAB.get(), CrabEntity.createAttributes());
        consumer.accept(ModEntityTypes.MANTARAY.get(), MantarayEntity.createAttributes());
        consumer.accept(ModEntityTypes.RACCOON.get(), RaccoonEntity.createAttributes());
        consumer.accept(ModEntityTypes.OWL.get(), OwlEntity.createAttributes());
        consumer.accept(ModEntityTypes.ANCIENT_BLAZE.get(), AncientBlazeEntity.createAttributes());
        consumer.accept(ModEntityTypes.KOALA.get(), KoalaEntity.createAttributes());
        consumer.accept(ModEntityTypes.SNAIL.get(), SnailEntity.createAttributes());
        consumer.accept(ModEntityTypes.MONKEY.get(), MonkeyEntity.createAttributes());
        consumer.accept(ModEntityTypes.NETHER_KNIGHT.get(), NetherKnightEntity.createAttributes());
        consumer.accept(ModEntityTypes.SHROOMIE.get(), ShroomieEntity.createAttributes());
        consumer.accept(ModEntityTypes.SEAHORSE.get(), SeahorseEntity.createAttributes());
        consumer.accept(ModEntityTypes.BABY_ENDER_DRAGON.get(), BabyEnderDragonEntity.createAttributes());
        consumer.accept(ModEntityTypes.PEACOCK.get(), PeacockEntity.createAttributes());
    }

    public static void registerSpawnPlacements() {
        LOGGER.info("Registering SpawnPlacements");
        SpawnPlacementsInvoker.register(ModEntityTypes.ELEPHANT.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ElephantEntity::checkElephantSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.GIRAFFE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GiraffeEntity::checkGiraffeSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.LION.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, LionEntity::checkLionSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.SHARK.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SharkEntity::checkSharkSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.PENGUIN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PenguinEntity::checkPenguinSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.OSTRICH.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, OstrichEntity::checkOstrichSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.FLAMINGO.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FlamingoEntity::checkFlamingoSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.CRAB.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CrabEntity::checkCrabSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.MANTARAY.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MantarayEntity::checkMantaraySpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.RACCOON.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RaccoonEntity::checkRaccoonSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.OWL.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, OwlEntity::checkOwlSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.ANCIENT_BLAZE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.KOALA.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, KoalaEntity::checkKoalaSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.SNAIL.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SnailEntity::checkSnailSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.MONKEY.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, MonkeyEntity::checkMonkeySpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.NETHER_KNIGHT.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.SHROOMIE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ShroomieEntity::checkShroomieSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.SEAHORSE.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SeahorseEntity::checkSeahorseSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.BABY_ENDER_DRAGON.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BabyEnderDragonEntity::checkBabyEnderDragonSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.PEACOCK.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PeacockEntity::checkPeacockSpawnRules);
    }

    public static void registerDispenserBehavior() {
        DispenserBlock.registerProjectileBehavior((ItemLike)((ItemLike)ModItems.OSTRICH_EGG.get()));
    }
}

