/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.spawner;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mcjty.incontrol.InControl;
import mcjty.incontrol.data.DataStorage;
import mcjty.incontrol.data.Statistics;
import mcjty.incontrol.mob.DefaultMob;
import mcjty.incontrol.spawner.SpawnerConditions;
import mcjty.incontrol.spawner.SpawnerParser;
import mcjty.incontrol.spawner.SpawnerRule;
import mcjty.incontrol.tools.varia.Box;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.jetbrains.annotations.NotNull;

public class SpawnerSystem {
    private static final Map<ResourceKey<Level>, WorldSpawnerData> worldData = new HashMap<ResourceKey<Level>, WorldSpawnerData>();
    private static final Random random = new Random();
    public static Mob busySpawning = null;

    public static void reloadRules() {
        worldData.clear();
        SpawnerParser.readRules("spawner.json");
    }

    public static void addRule(SpawnerRule rule) {
        for (ResourceKey<Level> dimension : rule.getConditions().getDimensions()) {
            SpawnerSystem.worldData.computeIfAbsent(dimension, (Function<ResourceKey, WorldSpawnerData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$addRule$0(net.minecraft.resources.ResourceKey ), (Lnet/minecraft/resources/ResourceKey;)Lmcjty/incontrol/spawner/SpawnerSystem$WorldSpawnerData;)()).rules.add(rule);
        }
    }

    public static void checkRules(LevelTickEvent.Pre event) {
        Level world = event.getLevel();
        WorldSpawnerData spawnerData = worldData.get(world.dimension());
        if (spawnerData == null) {
            return;
        }
        if (spawnerData.rules.isEmpty()) {
            return;
        }
        --spawnerData.counter;
        if (spawnerData.counter <= 0) {
            spawnerData.counter = 20;
            DataStorage data = DataStorage.getData((LevelAccessor)world);
            int i = 0;
            for (SpawnerRule rule : spawnerData.rules) {
                SpawnerSystem.executeRule(i, rule, world, data);
                ++i;
            }
        }
    }

    private static void executeRule(int ruleNr, SpawnerRule rule, Level world, DataStorage data) {
        int count;
        int count2;
        int count3;
        if (!data.getPhases().containsAll(rule.getPhases())) {
            return;
        }
        for (Map.Entry<String, Predicate<Integer>> entry : rule.getNumbers().entrySet()) {
            int value = data.getNumber(entry.getKey());
            if (entry.getValue().test(value)) continue;
            return;
        }
        SpawnerConditions conditions = rule.getConditions();
        if (conditions.getMaxtotal() != -1) {
            int count4 = InControl.setup.cache.getCountHostile((LevelAccessor)world);
            count4 += InControl.setup.cache.getCountPassive((LevelAccessor)world);
            if ((count4 += InControl.setup.cache.getCountNeutral((LevelAccessor)world)) >= conditions.getMaxtotal()) {
                return;
            }
        }
        if (conditions.getMaxhostile() != -1 && (count3 = InControl.setup.cache.getCountHostile((LevelAccessor)world)) >= conditions.getMaxhostile()) {
            return;
        }
        if (conditions.getMaxpeaceful() != -1 && (count2 = InControl.setup.cache.getCountPassive((LevelAccessor)world)) >= conditions.getMaxpeaceful()) {
            return;
        }
        if (conditions.getMaxneutral() != -1 && (count = InControl.setup.cache.getCountNeutral((LevelAccessor)world)) >= conditions.getMaxneutral()) {
            return;
        }
        int daycounter = data.getDaycounter();
        if (daycounter < conditions.getMindaycount() && daycounter >= conditions.getMaxdaycount()) {
            return;
        }
        if (rule.getMobsFromBiome() != null) {
            SpawnerSystem.executeRule(ruleNr, rule, (ServerLevel)world, null, rule.getMobsFromBiome(), 1.0f);
        } else {
            List<DefaultMob> mobs = rule.getMobs();
            List<Float> weights = rule.getWeights();
            float maxWeight = rule.getMaxWeight();
            for (int i = 0; i < mobs.size(); ++i) {
                DefaultMob mob = mobs.get(i);
                float weight = i < weights.size() ? weights.get(i).floatValue() : 1.0f;
                SpawnerSystem.executeRule(ruleNr, rule, (ServerLevel)world, mob, null, weight / maxWeight);
            }
        }
    }

    private static void executeRule(int ruleNr, SpawnerRule rule, ServerLevel world, @Nullable DefaultMob mob, @Nullable MobCategory classification, float weight) {
        if (random.nextFloat() > rule.getPersecond()) {
            return;
        }
        if (random.nextFloat() > weight) {
            return;
        }
        EntityType<?> entityType = null;
        if (mob != null) {
            entityType = mob.getType();
        }
        SpawnerConditions conditions = rule.getConditions();
        if (mob != null && SpawnerSystem.checkTooMany(world, entityType, conditions)) {
            return;
        }
        int minspawn = rule.getMinSpawn();
        int maxspawn = rule.getMaxSpawn();
        int groupDistance = rule.getGroupDistance();
        int desiredAmount = minspawn + (minspawn == maxspawn ? 0 : random.nextInt(maxspawn - minspawn));
        int spawned = 0;
        BlockPos groupCenterPos = null;
        for (int i = 0; i < rule.getAttempts(); ++i) {
            Entity entity;
            BlockPos pos = SpawnerSystem.getRandomPosition((Level)world, entityType, conditions, groupCenterPos, groupDistance);
            if (pos == null || !world.hasChunkAt(pos)) continue;
            if (mob == null) {
                EntityType<?> spawnable = SpawnerSystem.selectMob(world, classification, conditions, pos);
                if (spawnable == null) {
                    return;
                }
                entity = spawnable.create((Level)world);
            } else {
                entity = mob.getEntity(world);
                if (entity == null) {
                    return;
                }
            }
            entity.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), random.nextFloat() * 360.0f, 0.0f);
            boolean nocollisions = world.noCollision(entity.getBoundingBox());
            if (!nocollisions || !(entity instanceof Mob) || entity instanceof Enemy && world.getDifficulty() == Difficulty.PEACEFUL) continue;
            Mob mobEntity = (Mob)entity;
            for (String tag : rule.getScoreboardTags()) {
                entity.addTag(tag);
            }
            busySpawning = mobEntity;
            if (SpawnerSystem.canSpawn((Level)world, mobEntity, conditions) && SpawnerSystem.isNotColliding((Level)world, mobEntity, conditions)) {
                EventHooks.finalizeMobSpawn((Mob)mobEntity, (ServerLevelAccessor)world, (DifficultyInstance)world.getCurrentDifficultyAt(pos), (MobSpawnType)MobSpawnType.NATURAL, null);
                if (!((Mob)entity).isSpawnCancelled()) {
                    world.addFreshEntityWithPassengers(entity);
                    Statistics.addSpawnerStat(ruleNr);
                    ++spawned;
                    if (groupCenterPos == null) {
                        groupCenterPos = pos;
                    }
                    if (spawned >= desiredAmount) {
                        busySpawning = null;
                        return;
                    }
                }
            }
            busySpawning = null;
        }
    }

    private static EntityType<?> selectMob(ServerLevel world, MobCategory classification, SpawnerConditions conditions, BlockPos pos) {
        EntityType spawnable = null;
        if (classification != null) {
            WeightedRandomList spawners = ((Biome)world.getBiome(pos).value()).getMobSettings().getMobs(classification);
            if (spawners.isEmpty()) {
                return null;
            }
            spawnable = spawners.getRandom(world.random).map(item -> {
                EntityType type = item.type;
                if (SpawnerSystem.checkTooMany(world, type, conditions)) {
                    return null;
                }
                return type;
            }).orElse(null);
        }
        return spawnable;
    }

    private static boolean checkTooMany(ServerLevel world, EntityType<?> mob, SpawnerConditions conditions) {
        int count;
        return conditions.getMaxthis() != -1 && (count = InControl.setup.cache.getCount((LevelAccessor)world, mob)) >= conditions.getMaxthis();
    }

    private static boolean canSpawn(Level world, Mob mobEntity, SpawnerConditions conditions) {
        if (conditions.isNoRestrictions()) {
            return true;
        }
        return EventHooks.checkSpawnPosition((Mob)mobEntity, (ServerLevelAccessor)((ServerLevelAccessor)world), (MobSpawnType)MobSpawnType.NATURAL);
    }

    private static boolean isNotColliding(Level world, Mob mobEntity, SpawnerConditions conditions) {
        if (conditions.isInLiquid()) {
            return world.containsAnyLiquid(mobEntity.getBoundingBox()) && world.isUnobstructed((Entity)mobEntity);
        }
        if (conditions.isInWater()) {
            return SpawnerSystem.containsLiquid(world, mobEntity.getBoundingBox(), (TagKey<Fluid>)FluidTags.WATER);
        }
        if (conditions.isInLava()) {
            return SpawnerSystem.containsLiquid(world, mobEntity.getBoundingBox(), (TagKey<Fluid>)FluidTags.LAVA);
        }
        return mobEntity.checkSpawnObstruction((LevelReader)world);
    }

    private static boolean containsLiquid(Level world, AABB box, TagKey<Fluid> liquid) {
        int x1 = Mth.floor((double)box.minX);
        int x2 = Mth.ceil((double)box.maxX);
        int y1 = Mth.floor((double)box.minY);
        int y2 = Mth.ceil((double)box.maxY);
        int z1 = Mth.floor((double)box.minZ);
        int z2 = Mth.ceil((double)box.maxZ);
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        for (int x = x1; x < x2; ++x) {
            for (int y = y1; y < y2; ++y) {
                for (int z = z1; z < z2; ++z) {
                    BlockState blockstate = world.getBlockState((BlockPos)mpos.set(x, y, z));
                    if (!blockstate.getFluidState().is(liquid)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    private static BlockPos getRandomPosition(Level world, EntityType<?> mob, SpawnerConditions conditions, @Nullable BlockPos groupCenterPos, int groupDistance) {
        boolean inAir = conditions.isInAir();
        boolean inWater = conditions.isInWater();
        boolean inLava = conditions.isInLava();
        boolean inLiquid = conditions.isInLiquid();
        List players = world.players();
        Player player = (Player)players.get(random.nextInt(players.size()));
        BlockPos pos = inAir || inWater || inLava || inLiquid ? SpawnerSystem.getRandomPositionInBox(world, player, mob, conditions, groupCenterPos, groupDistance) : SpawnerSystem.getRandomPositionOnGround(world, player, mob, conditions, groupCenterPos, groupDistance);
        if (pos != null) {
            if (!((Boolean)conditions.getPositiveCheck().getExtraConditions().apply((Object)world, (Object)pos, (Object)player)).booleanValue()) {
                return null;
            }
            if (((Boolean)conditions.getNegativeCheck().getExtraConditions().apply((Object)world, (Object)pos, (Object)player)).booleanValue()) {
                return null;
            }
            return pos;
        }
        return null;
    }

    @Nullable
    private static BlockPos getRandomPositionInBox(Level world, Player player, EntityType<?> mob, SpawnerConditions conditions, @Nullable BlockPos groupCenterPos, int groupDistance) {
        Box box = SpawnerSystem.createSpawnBox(conditions, player.blockPosition());
        if (!box.isValid()) {
            return null;
        }
        if (SpawnerSystem.checkLocalCount((ServerLevel)world, mob, conditions, box)) {
            return null;
        }
        int verticalMindist = conditions.getVerticalMindist();
        int verticalMaxdist = conditions.getVerticalMaxdist();
        int mindist = conditions.getMindist();
        int maxdist = conditions.getMaxdist();
        BlockPos pos = null;
        double sqdist = Double.MAX_VALUE;
        int counter = 40;
        while (pos == null || sqdist < (double)(mindist * mindist) || sqdist > (double)(maxdist * maxdist)) {
            pos = box.randomPos(random, groupCenterPos, groupDistance);
            LevelChunk c = world.getChunkSource().getChunkNow(pos.getX() >> 4, pos.getZ() >> 4);
            if (c != null && c.getPersistedStatus() == ChunkStatus.FULL) {
                if (verticalMindist != -1 || verticalMaxdist != -1) {
                    int y = pos.getY();
                    int verticalDist = Math.abs(y - player.blockPosition().getY());
                    if (verticalMindist != -1 && verticalDist < verticalMindist) {
                        pos = null;
                        continue;
                    }
                    if (verticalMaxdist != -1 && verticalDist > verticalMaxdist) {
                        pos = null;
                        continue;
                    }
                }
                sqdist = pos.distToCenterSqr((double)player.blockPosition().getX(), (double)player.blockPosition().getY(), (double)player.blockPosition().getZ());
            }
            if (--counter > 0) continue;
            return null;
        }
        return pos;
    }

    @Nullable
    private static BlockPos getRandomPositionOnGround(Level world, Player player, EntityType<?> mob, SpawnerConditions conditions, @Nullable BlockPos groupCenterPos, int groupDistance) {
        Box box = SpawnerSystem.createSpawnBox(conditions, player.blockPosition());
        if (!box.isValid()) {
            return null;
        }
        if (SpawnerSystem.checkLocalCount((ServerLevel)world, mob, conditions, box)) {
            return null;
        }
        int minheight = conditions.getMinheight();
        int maxheight = conditions.getMaxheight();
        int verticalMindist = conditions.getVerticalMindist();
        int verticalMaxdist = conditions.getVerticalMaxdist();
        int mindist = conditions.getMindist();
        int maxdist = conditions.getMaxdist();
        BlockPos pos = null;
        double sqdist = Double.MAX_VALUE;
        Predicate<BlockPos> validSpawn = SpawnerSystem.getValidPosConditions(world, mob, conditions);
        int counter = 40;
        while (pos == null || sqdist < (double)(mindist * mindist) || sqdist > (double)(maxdist * maxdist)) {
            pos = box.randomPos(random, groupCenterPos, groupDistance);
            LevelChunk c = world.getChunkSource().getChunkNow(pos.getX() >> 4, pos.getZ() >> 4);
            if (c != null && c.getPersistedStatus() == ChunkStatus.FULL) {
                if ((pos = SpawnerSystem.getValidSpawnablePosition((LevelReader)world, pos.getX(), pos.getZ(), minheight, maxheight, validSpawn)) != null && (verticalMindist != -1 || verticalMaxdist != -1)) {
                    int y = pos.getY();
                    int verticalDist = Math.abs(y - player.blockPosition().getY());
                    if (verticalMindist != -1 && verticalDist < verticalMindist) {
                        pos = null;
                        continue;
                    }
                    if (verticalMaxdist != -1 && verticalDist > verticalMaxdist) {
                        pos = null;
                        continue;
                    }
                }
                double d = sqdist = pos == null ? Double.MAX_VALUE : pos.distToCenterSqr((double)player.blockPosition().getX(), (double)player.blockPosition().getY(), (double)player.blockPosition().getZ());
            }
            if (--counter > 0) continue;
            return null;
        }
        return pos;
    }

    @NotNull
    private static Predicate<BlockPos> getValidPosConditions(Level world, EntityType<?> mob, SpawnerConditions conditions) {
        Predicate<BlockPos> validSpawn = conditions.isValidSpawn() ? blockPos -> {
            if (!SpawnerSystem.isValidSpawnPos((LevelReader)world, blockPos)) {
                return false;
            }
            return SpawnerSystem.isValidSpawn((LevelReader)world, blockPos, mob);
        } : (conditions.isSturdy() ? blockPos -> {
            if (!SpawnerSystem.isValidSpawnPos((LevelReader)world, blockPos)) {
                return false;
            }
            return SpawnerSystem.isPositionSturdy((LevelReader)world, blockPos);
        } : blockPos -> SpawnerSystem.isValidSpawnPos((LevelReader)world, blockPos));
        return validSpawn;
    }

    private static boolean checkLocalCount(ServerLevel world, EntityType<?> mob, SpawnerConditions conditions, Box box) {
        if (conditions.getMaxlocal() != -1) {
            LevelEntityGetter entities = world.getEntities();
            long count = 0L;
            for (Entity entity : entities.getAll()) {
                if (entity.getType() != mob || !box.in(entity.blockPosition()) || ++count < (long)conditions.getMaxlocal()) continue;
                return true;
            }
        }
        return false;
    }

    private static Box createSpawnBox(SpawnerConditions conditions, BlockPos center) {
        int maxdist = conditions.getMaxdist();
        int minX = center.getX() - (maxdist + 1);
        int minY = center.getY() - (maxdist + 1);
        int minZ = center.getZ() - (maxdist + 1);
        int maxX = center.getX() + (maxdist + 1);
        int maxY = center.getY() + (maxdist + 1);
        int maxZ = center.getZ() + (maxdist + 1);
        minY = Math.max(minY, conditions.getMinheight() - 1);
        maxY = Math.min(maxY, conditions.getMaxheight() + 1);
        return new Box(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private static BlockPos getValidSpawnablePosition(LevelReader worldIn, int x, int z, int minHeight, int maxHeight, Predicate<BlockPos> validSpawn) {
        int height = worldIn.getHeight(Heightmap.Types.WORLD_SURFACE, x, z) + 1;
        height = Math.min(height, maxHeight);
        int minBuildHeight = worldIn.getMinBuildHeight();
        height = random.nextInt(height + 1 - minBuildHeight) + minBuildHeight;
        BlockPos blockPos = new BlockPos(x, height - 1, z);
        while (blockPos.getY() >= minHeight && !validSpawn.test(blockPos)) {
            blockPos = blockPos.below();
        }
        return blockPos.getY() < minHeight ? null : blockPos;
    }

    private static boolean isValidSpawn(LevelReader world, BlockPos pos, EntityType<?> entityType) {
        return world.getBlockState(pos.below()).isValidSpawn((BlockGetter)world, pos.below(), entityType);
    }

    private static boolean isPositionSturdy(LevelReader world, BlockPos pos) {
        return world.getBlockState(pos.below()).isFaceSturdy((BlockGetter)world, pos.below(), Direction.UP);
    }

    private static boolean isValidSpawnPos(LevelReader world, BlockPos pos) {
        if (!world.getBlockState(pos).isPathfindable(PathComputationType.LAND)) {
            return false;
        }
        return world.getBlockState(pos.below()).canOcclude();
    }

    private static /* synthetic */ WorldSpawnerData lambda$addRule$0(ResourceKey key) {
        return new WorldSpawnerData();
    }

    public static class WorldSpawnerData {
        private final List<SpawnerRule> rules = new ArrayList<SpawnerRule>();
        private int counter = 1;
    }
}

