/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.events;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import mcjty.incontrol.ForgeEventHandlers;
import mcjty.incontrol.InControl;
import mcjty.incontrol.rules.LootRule;
import mcjty.incontrol.rules.RulesManager;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class InControlLootModifier
extends LootModifier {
    public static final MapCodec<InControlLootModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(l -> l.conditions)).apply((Applicative)instance, InControlLootModifier::new));

    public InControlLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ServerLevel level = context.getLevel();
        int looting = 0;
        Iterator<LootRule> iterator = context.getParamOrNull(LootContextParams.ATTACKING_ENTITY);
        if (iterator instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)iterator;
            Optional holder = level.registryAccess().holder(Enchantments.LOOTING);
            if (holder.isPresent()) {
                looting = EnchantmentHelper.getTagEnchantmentLevel((Holder)((Holder)holder.get()), (ItemStack)attacker.getWeaponItem());
            }
        }
        int i = 0;
        for (LootRule rule : RulesManager.getFilteredLootRules((Level)level)) {
            if (rule.match(context)) {
                if (ForgeEventHandlers.debug) {
                    Entity entity = (Entity)context.getParam(LootContextParams.THIS_ENTITY);
                    InControl.setup.getLogger().log(org.apache.logging.log4j.Level.INFO, "Loot " + i + ":  entity: " + String.valueOf(entity.getName()));
                }
                if (rule.isRemoveAll()) {
                    generatedLoot.clear();
                } else {
                    for (Predicate<ItemStack> predicate : rule.getToRemoveItems()) {
                        for (int l = generatedLoot.size() - 1; l >= 0; --l) {
                            if (!predicate.test((ItemStack)generatedLoot.get(l))) continue;
                            generatedLoot.remove(l);
                        }
                    }
                }
                for (Pair pair : rule.getToAddItems()) {
                    ItemStack copy;
                    int amount;
                    ItemStack item = (ItemStack)pair.getLeft();
                    for (amount = ((Integer)((Function)pair.getValue()).apply(looting)).intValue(); amount > item.getMaxStackSize(); amount -= item.getMaxStackSize()) {
                        copy = item.copy();
                        copy.setCount(item.getMaxStackSize());
                        generatedLoot.add((Object)copy);
                    }
                    if (amount <= 0) continue;
                    copy = item.copy();
                    copy.setCount(amount);
                    generatedLoot.add((Object)copy);
                }
            }
            ++i;
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

