/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.hostilenetworks.data.ModelTierRegistry;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public record ModelTier(int requiredData, int dataPerKill, TextColor color, float accuracy, boolean canSim) implements CodecProvider<ModelTier>
{
    public static final Codec<ModelTier> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("required_data").forGetter(ModelTier::requiredData), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("data_per_kill").forGetter(ModelTier::dataPerKill), (App)TextColor.CODEC.fieldOf("color").forGetter(ModelTier::color), (App)Codec.floatRange((float)0.0f, (float)64.0f).fieldOf("accuracy").forGetter(ModelTier::accuracy), (App)Codec.BOOL.optionalFieldOf("can_sim", (Object)true).forGetter(ModelTier::canSim)).apply((Applicative)inst, ModelTier::new));

    public Component getComponent() {
        return Component.translatable((String)("hostilenetworks.tier." + ModelTierRegistry.INSTANCE.getKey(this).getPath())).withStyle(Style.EMPTY.withColor(this.color));
    }

    public boolean isMax() {
        return ModelTierRegistry.getMaxTier() == this;
    }

    public boolean isMin() {
        return ModelTierRegistry.getMinTier() == this;
    }

    public String name() {
        return ModelTierRegistry.INSTANCE.getKey(this).getPath();
    }

    public DynamicHolder<ModelTier> asHolder() {
        return ModelTierRegistry.INSTANCE.holder(this);
    }

    public int colorValue() {
        return 0xFF000000 | this.color().getValue();
    }

    public Codec<? extends ModelTier> getCodec() {
        return CODEC;
    }
}

