/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.shadowsoffire.hostilenetworks.HostileNetworks;
import dev.shadowsoffire.hostilenetworks.client.WeirdRenderThings;
import dev.shadowsoffire.hostilenetworks.client.WrappedRTBuffer;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.hostilenetworks.util.ClientEntityCache;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DataModelItemStackRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final MultiBufferSource.BufferSource GHOST_ENTITY_BUF = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(256));
    private static final ModelResourceLocation DATA_MODEL_BASE = ModelResourceLocation.standalone((ResourceLocation)HostileNetworks.loc("item/data_model_base"));

    public DataModelItemStackRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext type, PoseStack matrix, MultiBufferSource buf, int light, int overlay) {
        ItemRenderer irenderer = Minecraft.getInstance().getItemRenderer();
        BakedModel base = irenderer.getItemModelShaper().getModelManager().getModel(DATA_MODEL_BASE);
        matrix.pushPose();
        if (type == ItemDisplayContext.FIXED) {
            matrix.translate(1.0f, 1.0f, 0.0f);
            scale = 0.5f;
            matrix.scale(scale, scale, scale);
            matrix.translate(-1.5f, -0.5f, 0.5f);
            matrix.mulPose(Axis.XP.rotationDegrees(90.0f));
            matrix.mulPose(Axis.XP.rotationDegrees(90.0f));
            matrix.translate(0.0f, 0.0f, -1.0f);
        } else if (type != ItemDisplayContext.GUI) {
            matrix.translate(1.0f, 1.0f, 0.0f);
            scale = 0.5f;
            matrix.scale(scale, scale, scale);
            matrix.translate(-1.5f, -0.5f, 0.5f);
            matrix.mulPose(Axis.XP.rotationDegrees(90.0f));
        } else {
            matrix.translate(0.0f, -0.5f, -0.5f);
            matrix.mulPose(Axis.XN.rotationDegrees(75.0f));
            matrix.mulPose(Axis.ZP.rotationDegrees(45.0f));
            scale = 0.9f;
            matrix.scale(scale, scale, scale);
            matrix.translate(0.775, 0.0, -0.0825);
        }
        irenderer.renderModelLists(base, stack, light, overlay, matrix, ItemRenderer.getFoilBufferDirect((MultiBufferSource)GHOST_ENTITY_BUF, (RenderType)ItemBlockRenderTypes.getRenderType((ItemStack)stack, (boolean)true), (boolean)true, (boolean)false));
        GHOST_ENTITY_BUF.endBatch();
        matrix.popPose();
        DynamicHolder<DataModel> model = DataModelItem.getStoredModel(stack);
        if (model.isBound()) {
            Object ent = ClientEntityCache.computeIfAbsent(((DataModel)model.get()).entity(), (Level)Minecraft.getInstance().level, ((DataModel)model.get()).display().nbt());
            if (Minecraft.getInstance().player != null) {
                ((Entity)ent).tickCount = Minecraft.getInstance().player.tickCount;
            }
            if (ent != null) {
                this.renderEntityInInventory(matrix, type, (Entity)ent, (DataModel)model.get());
            }
        }
    }

    public void renderEntityInInventory(PoseStack matrix, ItemDisplayContext type, Entity entity, DataModel model) {
        matrix.pushPose();
        matrix.translate(0.5, 0.5, 0.5);
        float scale = model.display().scale();
        if (type == ItemDisplayContext.FIXED) {
            matrix.translate(0.0, -0.5, 0.0);
            matrix.scale(scale *= 0.4f, scale, scale);
            matrix.translate(0.0, 1.45, 0.0);
            matrix.mulPose(Axis.XN.rotationDegrees(90.0f));
            matrix.mulPose(Axis.YN.rotationDegrees(180.0f));
        } else if (type == ItemDisplayContext.GUI) {
            matrix.translate(0.0, -0.5, 0.0);
            matrix.scale(scale *= 0.4f, scale, scale);
            matrix.translate(0.0, 0.45, 0.0);
        } else {
            matrix.scale(scale *= 0.25f, scale, scale);
            matrix.translate(0.0, 0.12 + 0.05 * Math.sin(((float)entity.tickCount + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true)) / 12.0f), 0.0);
        }
        float rotation = -30.0f;
        if (type == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || type == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            rotation = 30.0f;
        }
        if (type == ItemDisplayContext.FIXED) {
            rotation = 180.0f;
        }
        matrix.mulPose(Axis.YP.rotationDegrees(rotation));
        entity.setYRot(0.0f);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.yBodyRot = entity.getYRot();
            living.yHeadRot = entity.getYRot();
            living.yHeadRotO = entity.getYRot();
        }
        EntityRenderDispatcher entityrenderermanager = Minecraft.getInstance().getEntityRenderDispatcher();
        entityrenderermanager.setRenderShadow(false);
        MultiBufferSource.BufferSource rtBuffer = GHOST_ENTITY_BUF;
        WeirdRenderThings.translucent = true;
        RenderSystem.runAsFancy(() -> entityrenderermanager.render(entity, (double)model.display().xOffset(), (double)model.display().yOffset(), (double)model.display().zOffset(), 0.0f, Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true), matrix, (MultiBufferSource)new WrappedRTBuffer((MultiBufferSource)rtBuffer), 0xF000F0));
        rtBuffer.endBatch();
        WeirdRenderThings.translucent = false;
        entityrenderermanager.setRenderShadow(true);
        matrix.popPose();
    }
}

