/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.lib;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.creeperhost.polylib.PolyLibClient;
import net.creeperhost.polylib.client.modulargui.lib.LegacyRender;
import net.creeperhost.polylib.client.modulargui.lib.ScissorHandler;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Borders;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Rectangle;
import net.creeperhost.polylib.client.modulargui.sprite.Material;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector2ic;

public class GuiRender
extends LegacyRender {
    public static final RenderType SOLID = RenderType.gui();
    private final RenderWrapper renderWrapper;
    private final Minecraft mc;
    private final PoseStack pose;
    private final ScissorHandler scissorHandler = new ScissorHandler();
    private final MultiBufferSource.BufferSource buffers;
    private boolean batchDraw;
    private Font fontOverride;
    private ItemStack tooltipStack = ItemStack.EMPTY;

    public GuiRender(Minecraft mc, PoseStack poseStack, MultiBufferSource.BufferSource buffers) {
        this.mc = mc;
        this.pose = poseStack;
        this.buffers = buffers;
        this.renderWrapper = new RenderWrapper(this);
    }

    public GuiRender(Minecraft mc, MultiBufferSource.BufferSource buffers) {
        this(mc, new PoseStack(), buffers);
    }

    public static GuiRender convert(GuiGraphics graphics) {
        return new GuiRender(Minecraft.getInstance(), graphics.pose(), graphics.bufferSource());
    }

    @Override
    public PoseStack pose() {
        return this.pose;
    }

    public MultiBufferSource.BufferSource buffers() {
        return this.buffers;
    }

    public Minecraft mc() {
        return this.mc;
    }

    public Font font() {
        return this.fontOverride == null ? this.mc().font : this.fontOverride;
    }

    public int guiWidth() {
        return this.mc().getWindow().getGuiScaledWidth();
    }

    public int guiHeight() {
        return this.mc().getWindow().getGuiScaledHeight();
    }

    public void overrideFont(@Nullable Font font) {
        this.fontOverride = font;
    }

    public void batchDraw(Runnable batch) {
        this.flush();
        this.batchDraw = true;
        batch.run();
        this.batchDraw = false;
        this.flush();
    }

    private void flushIfUnBatched() {
        if (!this.batchDraw) {
            this.flush();
        }
    }

    private void flushIfBatched() {
        if (this.batchDraw) {
            this.flush();
        }
    }

    public void flush() {
        RenderSystem.disableDepthTest();
        this.buffers.endBatch();
        RenderSystem.enableDepthTest();
    }

    @Deprecated
    public RenderWrapper guiGraphicsWrapper() {
        return this.renderWrapper;
    }

    public void rect(Rectangle rectangle, int colour) {
        this.rect(SOLID, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), colour);
    }

    public void rect(RenderType type, Rectangle rectangle, int colour) {
        this.rect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), colour);
    }

    public void rect(double x, double y, double width, double height, int colour) {
        this.fill(SOLID, x, y, x + width, y + height, colour);
    }

    public void rect(RenderType type, double x, double y, double width, double height, int colour) {
        this.fill(type, x, y, x + width, y + height, colour);
    }

    public void fill(double xMin, double yMin, double xMax, double yMax, int colour) {
        this.fill(SOLID, xMin, yMin, xMax, yMax, colour);
    }

    public void fill(RenderType type, double xMin, double yMin, double xMax, double yMax, int colour) {
        double min;
        if (xMax < xMin) {
            min = xMax;
            xMax = xMin;
            xMin = min;
        }
        if (yMax < yMin) {
            min = yMax;
            yMax = yMin;
            yMin = min;
        }
        Matrix4f mat = this.pose.last().pose();
        VertexConsumer buffer = this.buffers.getBuffer(type);
        buffer.addVertex(mat, (float)xMax, (float)yMax, 0.0f).setColor(colour);
        buffer.addVertex(mat, (float)xMax, (float)yMin, 0.0f).setColor(colour);
        buffer.addVertex(mat, (float)xMin, (float)yMin, 0.0f).setColor(colour);
        buffer.addVertex(mat, (float)xMin, (float)yMax, 0.0f).setColor(colour);
        this.flushIfUnBatched();
    }

    public void gradientFillV(double xMin, double yMin, double xMax, double yMax, int topColour, int bottomColour) {
        this.gradientFillV(SOLID, xMin, yMin, xMax, yMax, topColour, bottomColour);
    }

    public void gradientFillV(RenderType type, double xMin, double yMin, double xMax, double yMax, int topColour, int bottomColour) {
        VertexConsumer buffer = this.buffers().getBuffer(type);
        float sA = (float)FastColor.ARGB32.alpha((int)topColour) / 255.0f;
        float sR = (float)FastColor.ARGB32.red((int)topColour) / 255.0f;
        float sG = (float)FastColor.ARGB32.green((int)topColour) / 255.0f;
        float sB = (float)FastColor.ARGB32.blue((int)topColour) / 255.0f;
        float eA = (float)FastColor.ARGB32.alpha((int)bottomColour) / 255.0f;
        float eR = (float)FastColor.ARGB32.red((int)bottomColour) / 255.0f;
        float eG = (float)FastColor.ARGB32.green((int)bottomColour) / 255.0f;
        float eB = (float)FastColor.ARGB32.blue((int)bottomColour) / 255.0f;
        Matrix4f mat = this.pose.last().pose();
        buffer.addVertex(mat, (float)xMax, (float)yMax, 0.0f).setColor(eR, eG, eB, eA);
        buffer.addVertex(mat, (float)xMax, (float)yMin, 0.0f).setColor(sR, sG, sB, sA);
        buffer.addVertex(mat, (float)xMin, (float)yMin, 0.0f).setColor(sR, sG, sB, sA);
        buffer.addVertex(mat, (float)xMin, (float)yMax, 0.0f).setColor(eR, eG, eB, eA);
        this.flushIfUnBatched();
    }

    public void gradientFillH(double xMin, double yMin, double xMax, double yMax, int leftColour, int rightColour) {
        this.gradientFillH(SOLID, xMin, yMin, xMax, yMax, leftColour, rightColour);
    }

    public void gradientFillH(RenderType type, double xMin, double yMin, double xMax, double yMax, int leftColour, int rightColour) {
        VertexConsumer buffer = this.buffers().getBuffer(type);
        float sA = (float)FastColor.ARGB32.alpha((int)leftColour) / 255.0f;
        float sR = (float)FastColor.ARGB32.red((int)leftColour) / 255.0f;
        float sG = (float)FastColor.ARGB32.green((int)leftColour) / 255.0f;
        float sB = (float)FastColor.ARGB32.blue((int)leftColour) / 255.0f;
        float eA = (float)FastColor.ARGB32.alpha((int)rightColour) / 255.0f;
        float eR = (float)FastColor.ARGB32.red((int)rightColour) / 255.0f;
        float eG = (float)FastColor.ARGB32.green((int)rightColour) / 255.0f;
        float eB = (float)FastColor.ARGB32.blue((int)rightColour) / 255.0f;
        Matrix4f mat = this.pose.last().pose();
        buffer.addVertex(mat, (float)xMax, (float)yMax, 0.0f).setColor(eR, eG, eB, eA);
        buffer.addVertex(mat, (float)xMax, (float)yMin, 0.0f).setColor(eR, eG, eB, eA);
        buffer.addVertex(mat, (float)xMin, (float)yMin, 0.0f).setColor(sR, sG, sB, sA);
        buffer.addVertex(mat, (float)xMin, (float)yMax, 0.0f).setColor(sR, sG, sB, sA);
        this.flushIfUnBatched();
    }

    public void borderRect(Rectangle rectangle, double borderWidth, int fillColour, int borderColour) {
        this.borderFill(rectangle.x(), rectangle.y(), rectangle.xMax(), rectangle.yMax(), borderWidth, fillColour, borderColour);
    }

    public void borderRect(double x, double y, double width, double height, double borderWidth, int fillColour, int borderColour) {
        this.borderFill(x, y, x + width, y + height, borderWidth, fillColour, borderColour);
    }

    public void borderRect(RenderType type, Rectangle rectangle, double borderWidth, int fillColour, int borderColour) {
        this.borderFill(type, rectangle.x(), rectangle.y(), rectangle.xMax(), rectangle.yMax(), borderWidth, fillColour, borderColour);
    }

    public void borderRect(RenderType type, double x, double y, double width, double height, double borderWidth, int fillColour, int borderColour) {
        this.borderFill(type, x, y, x + width, y + height, borderWidth, fillColour, borderColour);
    }

    public void borderFill(double xMin, double yMin, double xMax, double yMax, double borderWidth, int fillColour, int borderColour) {
        this.borderFill(SOLID, xMin, yMin, xMax, yMax, borderWidth, fillColour, borderColour);
    }

    public void borderFill(RenderType type, double xMin, double yMin, double xMax, double yMax, double borderWidth, int fillColour, int borderColour) {
        if (this.batchDraw) {
            this.borderFillInternal(type, xMin, yMin, xMax, yMax, borderWidth, fillColour, borderColour);
        } else {
            this.batchDraw(() -> this.borderFillInternal(type, xMin, yMin, xMax, yMax, borderWidth, fillColour, borderColour));
        }
    }

    private void borderFillInternal(RenderType type, double xMin, double yMin, double xMax, double yMax, double borderWidth, int fillColour, int borderColour) {
        this.fill(type, xMin, yMin, xMax, yMin + borderWidth, borderColour);
        this.fill(type, xMin, yMin + borderWidth, xMin + borderWidth, yMax - borderWidth, borderColour);
        this.fill(type, xMin, yMax - borderWidth, xMax, yMax, borderColour);
        this.fill(type, xMax - borderWidth, yMin + borderWidth, xMax, yMax - borderWidth, borderColour);
        if (fillColour != 0) {
            this.fill(type, xMin + borderWidth, yMin + borderWidth, xMax - borderWidth, yMax - borderWidth, fillColour);
        }
    }

    public void shadedRect(Rectangle rectangle, double borderWidth, int topLeftColour, int bottomRightColour, int fillColour) {
        this.shadedFill(SOLID, rectangle.x(), rectangle.y(), rectangle.xMax(), rectangle.yMax(), borderWidth, topLeftColour, bottomRightColour, GuiRender.midColour(topLeftColour, bottomRightColour), fillColour);
    }

    public void shadedRect(double x, double y, double width, double height, double borderWidth, int topLeftColour, int bottomRightColour, int fillColour) {
        this.shadedFill(SOLID, x, y, x + width, y + height, borderWidth, topLeftColour, bottomRightColour, GuiRender.midColour(topLeftColour, bottomRightColour), fillColour);
    }

    public void shadedRect(Rectangle rectangle, double borderWidth, int topLeftColour, int bottomRightColour, int cornerMixColour, int fillColour) {
        this.shadedFill(SOLID, rectangle.x(), rectangle.y(), rectangle.xMax(), rectangle.yMax(), borderWidth, topLeftColour, bottomRightColour, cornerMixColour, fillColour);
    }

    public void shadedRect(double x, double y, double width, double height, double borderWidth, int topLeftColour, int bottomRightColour, int cornerMixColour, int fillColour) {
        this.shadedFill(SOLID, x, y, x + width, y + height, borderWidth, topLeftColour, bottomRightColour, cornerMixColour, fillColour);
    }

    public void shadedRect(RenderType type, double x, double y, double width, double height, double borderWidth, int topLeftColour, int bottomRightColour, int cornerMixColour, int fillColour) {
        this.shadedFill(type, x, y, x + width, y + height, borderWidth, topLeftColour, bottomRightColour, cornerMixColour, fillColour);
    }

    public void shadedFill(double xMin, double yMin, double xMax, double yMax, double borderWidth, int topLeftColour, int bottomRightColour, int fillColour) {
        this.shadedFill(SOLID, xMin, yMin, xMax, yMax, borderWidth, topLeftColour, bottomRightColour, GuiRender.midColour(topLeftColour, bottomRightColour), fillColour);
    }

    public void shadedFill(double xMin, double yMin, double xMax, double yMax, double borderWidth, int topLeftColour, int bottomRightColour, int cornerMixColour, int fillColour) {
        this.shadedFill(SOLID, xMin, yMin, xMax, yMax, borderWidth, topLeftColour, bottomRightColour, cornerMixColour, fillColour);
    }

    public void shadedFill(RenderType type, double xMin, double yMin, double xMax, double yMax, double borderWidth, int topLeftColour, int bottomRightColour, int cornerMixColour, int fillColour) {
        if (this.batchDraw) {
            this.shadedFillInternal(type, xMin, yMin, xMax, yMax, borderWidth, topLeftColour, bottomRightColour, cornerMixColour, fillColour);
        } else {
            this.batchDraw(() -> this.shadedFillInternal(type, xMin, yMin, xMax, yMax, borderWidth, topLeftColour, bottomRightColour, cornerMixColour, fillColour));
        }
    }

    public void shadedFillInternal(RenderType type, double xMin, double yMin, double xMax, double yMax, double borderWidth, int topLeftColour, int bottomRightColour, int cornerMixColour, int fillColour) {
        this.fill(type, xMin, yMin, xMax - borderWidth, yMin + borderWidth, topLeftColour);
        this.fill(type, xMin, yMin + borderWidth, xMin + borderWidth, yMax - borderWidth, topLeftColour);
        this.fill(type, xMin + borderWidth, yMax - borderWidth, xMax, yMax, bottomRightColour);
        this.fill(type, xMax - borderWidth, yMin + borderWidth, xMax, yMax - borderWidth, bottomRightColour);
        this.fill(type, xMax - borderWidth, yMin, xMax, yMin + borderWidth, cornerMixColour);
        this.fill(type, xMin, yMax - borderWidth, xMin + borderWidth, yMax, cornerMixColour);
        if (fillColour != 0) {
            this.fill(type, xMin + borderWidth, yMin + borderWidth, xMax - borderWidth, yMax - borderWidth, fillColour);
        }
    }

    public void toolTipBackground(double x, double y, double width, double height) {
        this.toolTipBackground(x, y, width, height, -267386864, 0x505000FF, 1344798847);
    }

    public void toolTipBackground(double x, double y, double width, double height, int backgroundColour, int borderColourTop, int borderColourBottom) {
        this.toolTipBackground(x, y, width, height, backgroundColour, backgroundColour, borderColourTop, borderColourBottom, false);
    }

    public void toolTipBackground(double x, double y, double width, double height, int backgroundColourTop, int backgroundColourBottom, int borderColourTop, int borderColourBottom, boolean empty) {
        if (this.batchDraw) {
            this.toolTipBackgroundInternal(x, y, x + width, y + height, backgroundColourTop, backgroundColourBottom, borderColourTop, borderColourBottom, false);
        } else {
            this.batchDraw(() -> this.toolTipBackgroundInternal(x, y, x + width, y + height, backgroundColourTop, backgroundColourBottom, borderColourTop, borderColourBottom, false));
        }
    }

    private void toolTipBackgroundInternal(double xMin, double yMin, double xMax, double yMax, int backgroundColourTop, int backgroundColourBottom, int borderColourTop, int borderColourBottom, boolean empty) {
        this.fill(xMin + 1.0, yMin, xMax - 1.0, yMin + 1.0, backgroundColourTop);
        this.fill(xMin + 1.0, yMax - 1.0, xMax - 1.0, yMax, backgroundColourBottom);
        this.gradientFillV(xMin, yMin + 1.0, xMin + 1.0, yMax - 1.0, backgroundColourTop, backgroundColourBottom);
        this.gradientFillV(xMax - 1.0, yMin + 1.0, xMax, yMax - 1.0, backgroundColourTop, backgroundColourBottom);
        if (!empty) {
            this.gradientFillV(xMin + 1.0, yMin + 1.0, xMax - 1.0, yMax - 1.0, backgroundColourTop, backgroundColourBottom);
        }
        this.gradientFillV(xMin + 1.0, yMin + 1.0, xMin + 2.0, yMax - 1.0, borderColourTop, borderColourBottom);
        this.gradientFillV(xMax - 2.0, yMin + 1.0, xMax - 1.0, yMax - 1.0, borderColourTop, borderColourBottom);
        this.fill(xMin + 2.0, yMin + 1.0, xMax - 2.0, yMin + 2.0, borderColourTop);
        this.fill(xMin + 2.0, yMax - 2.0, xMax - 2.0, yMax - 1.0, borderColourBottom);
    }

    public void spriteRect(RenderType type, Rectangle rectangle, TextureAtlasSprite sprite) {
        this.spriteRect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), sprite, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void spriteRect(RenderType type, Rectangle rectangle, TextureAtlasSprite sprite, int argb) {
        this.spriteRect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), sprite, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void spriteRect(RenderType type, Rectangle rectangle, TextureAtlasSprite sprite, float red, float green, float blue, float alpha) {
        this.spriteRect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), sprite, red, green, blue, alpha);
    }

    public void spriteRect(RenderType type, double x, double y, double width, double height, TextureAtlasSprite sprite) {
        this.spriteRect(type, x, y, width, height, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void spriteRect(RenderType type, double x, double y, double width, double height, TextureAtlasSprite sprite, int argb) {
        this.spriteRect(type, x, y, width, height, sprite, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void spriteRect(RenderType type, double x, double y, double width, double height, TextureAtlasSprite sprite, float red, float green, float blue, float alpha) {
        this.sprite(type, x, y, x + width, y + height, sprite, red, green, blue, alpha);
    }

    public void sprite(RenderType type, double xMin, double yMin, double xMax, double yMax, TextureAtlasSprite sprite) {
        this.sprite(type, xMin, yMin, xMax, yMax, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void sprite(RenderType type, double xMin, double yMin, double xMax, double yMax, TextureAtlasSprite sprite, int argb) {
        this.sprite(type, xMin, yMin, xMax, yMax, sprite, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void sprite(RenderType type, double xMin, double yMin, double xMax, double yMax, TextureAtlasSprite sprite, float red, float green, float blue, float alpha) {
        VertexConsumer buffer = this.buffers().getBuffer(type);
        Matrix4f mat = this.pose.last().pose();
        buffer.addVertex(mat, (float)xMax, (float)yMax, 0.0f).setColor(red, green, blue, alpha).setUv(sprite.getU1(), sprite.getV1());
        buffer.addVertex(mat, (float)xMax, (float)yMin, 0.0f).setColor(red, green, blue, alpha).setUv(sprite.getU1(), sprite.getV0());
        buffer.addVertex(mat, (float)xMin, (float)yMin, 0.0f).setColor(red, green, blue, alpha).setUv(sprite.getU0(), sprite.getV0());
        buffer.addVertex(mat, (float)xMin, (float)yMax, 0.0f).setColor(red, green, blue, alpha).setUv(sprite.getU0(), sprite.getV1());
        this.flushIfUnBatched();
    }

    public void spriteRect(RenderType type, Rectangle rectangle, int rotation, TextureAtlasSprite sprite) {
        this.spriteRect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), rotation, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void spriteRect(RenderType type, Rectangle rectangle, int rotation, TextureAtlasSprite sprite, int argb) {
        this.spriteRect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), rotation, sprite, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void spriteRect(RenderType type, Rectangle rectangle, int rotation, TextureAtlasSprite sprite, float red, float green, float blue, float alpha) {
        this.spriteRect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), rotation, sprite, red, green, blue, alpha);
    }

    public void spriteRect(RenderType type, double x, double y, double width, double height, int rotation, TextureAtlasSprite sprite) {
        this.spriteRect(type, x, y, width, height, rotation, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void spriteRect(RenderType type, double x, double y, double width, double height, int rotation, TextureAtlasSprite sprite, int argb) {
        this.spriteRect(type, x, y, width, height, rotation, sprite, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void spriteRect(RenderType type, double x, double y, double width, double height, int rotation, TextureAtlasSprite sprite, float red, float green, float blue, float alpha) {
        this.sprite(type, x, y, x + width, y + height, rotation, sprite, red, green, blue, alpha);
    }

    public void sprite(RenderType type, double xMin, double yMin, double xMax, double yMax, int rotation, TextureAtlasSprite sprite) {
        this.sprite(type, xMin, yMin, xMax, yMax, rotation, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void sprite(RenderType type, double xMin, double yMin, double xMax, double yMax, int rotation, TextureAtlasSprite sprite, int argb) {
        this.sprite(type, xMin, yMin, xMax, yMax, rotation, sprite, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void sprite(RenderType type, double xMin, double yMin, double xMax, double yMax, int rotation, TextureAtlasSprite sprite, float red, float green, float blue, float alpha) {
        float[] u = new float[]{sprite.getU0(), sprite.getU1(), sprite.getU1(), sprite.getU0()};
        float[] v = new float[]{sprite.getV1(), sprite.getV1(), sprite.getV0(), sprite.getV0()};
        VertexConsumer buffer = this.buffers().getBuffer(type);
        Matrix4f mat = this.pose.last().pose();
        buffer.addVertex(mat, (float)xMax, (float)yMax, 0.0f).setColor(red, green, blue, alpha).setUv(u[(1 + rotation) % 4], v[(1 + rotation) % 4]);
        buffer.addVertex(mat, (float)xMax, (float)yMin, 0.0f).setColor(red, green, blue, alpha).setUv(u[(2 + rotation) % 4], v[(2 + rotation) % 4]);
        buffer.addVertex(mat, (float)xMin, (float)yMin, 0.0f).setColor(red, green, blue, alpha).setUv(u[(3 + rotation) % 4], v[(3 + rotation) % 4]);
        buffer.addVertex(mat, (float)xMin, (float)yMax, 0.0f).setColor(red, green, blue, alpha).setUv(u[(0 + rotation) % 4], v[(0 + rotation) % 4]);
        this.flushIfUnBatched();
    }

    public void partialSpriteTex(RenderType type, double xMin, double yMin, double xMax, double yMax, TextureAtlasSprite sprite, double texXMin, double texYMin, double texXMax, double texYMax, int argb) {
        this.partialSpriteTex(type, xMin, yMin, xMax, yMax, sprite, texXMin, texYMin, texXMax, texYMax, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void partialSpriteTex(RenderType type, double xMin, double yMin, double xMax, double yMax, TextureAtlasSprite sprite, double texXMin, double texYMin, double texXMax, double texYMax, float red, float green, float blue, float alpha) {
        int width = sprite.contents().width();
        int height = sprite.contents().height();
        this.partialSprite(type, xMin, yMin, xMax, yMax, sprite, (float)texXMin / (float)width, (float)texYMin / (float)height, (float)texXMax / (float)width, (float)texYMax / (float)height, red, green, blue, alpha);
    }

    public void partialSprite(RenderType type, double xMin, double yMin, double xMax, double yMax, TextureAtlasSprite sprite, float uMin, float vMin, float uMax, float vMax, int argb) {
        this.partialSprite(type, xMin, yMin, xMax, yMax, sprite, uMin, vMin, uMax, vMax, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void partialSprite(RenderType type, double xMin, double yMin, double xMax, double yMax, TextureAtlasSprite sprite, float uMin, float vMin, float uMax, float vMax, float red, float green, float blue, float alpha) {
        VertexConsumer buffer = this.buffers().getBuffer(type);
        Matrix4f mat = this.pose.last().pose();
        float u0 = sprite.getU0();
        float v0 = sprite.getV0();
        float u1 = sprite.getU1();
        float v1 = sprite.getV1();
        float ul = u1 - u0;
        float vl = v1 - v0;
        buffer.addVertex(mat, (float)xMax, (float)yMax, 0.0f).setColor(red, green, blue, alpha).setUv(u0 + uMax * ul, v0 + vMax * vl);
        buffer.addVertex(mat, (float)xMax, (float)yMin, 0.0f).setColor(red, green, blue, alpha).setUv(u0 + uMax * ul, v0 + vMin * vl);
        buffer.addVertex(mat, (float)xMin, (float)yMin, 0.0f).setColor(red, green, blue, alpha).setUv(u0 + uMin * ul, v0 + vMin * vl);
        buffer.addVertex(mat, (float)xMin, (float)yMax, 0.0f).setColor(red, green, blue, alpha).setUv(u0 + uMin * ul, v0 + vMax * vl);
        this.flushIfUnBatched();
    }

    public void tileSprite(RenderType type, double xMin, double yMin, double xMax, double yMax, TextureAtlasSprite sprite, int argb) {
        this.tileSprite(type, xMin, yMin, xMax, yMax, sprite, sprite.contents().width(), sprite.contents().height(), argb);
    }

    public void tileSprite(RenderType type, double xMin, double yMin, double xMax, double yMax, TextureAtlasSprite sprite, int textureWidth, int textureHeight, int argb) {
        this.tileSprite(type, xMin, yMin, xMax, yMax, sprite, textureWidth, textureHeight, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void tileSprite(RenderType type, double xMin, double yMin, double xMax, double yMax, TextureAtlasSprite sprite, float red, float green, float blue, float alpha) {
        this.tileSprite(type, xMin, yMin, xMax, yMax, sprite, sprite.contents().width(), sprite.contents().height(), red, green, blue, alpha);
    }

    public void tileSprite(RenderType type, double xMin, double yMin, double xMax, double yMax, TextureAtlasSprite sprite, int textureWidth, int textureHeight, float red, float green, float blue, float alpha) {
        double width = xMax - xMin;
        double height = yMax - yMin;
        if (width <= (double)textureWidth && height <= (double)textureHeight) {
            this.partialSprite(type, xMin, yMin, xMax, yMax, sprite, 0.0f, 0.0f, (float)width / (float)textureWidth, (float)height / (float)textureHeight, red, green, blue, alpha);
        } else {
            Runnable draw = () -> {
                double xPos = xMin;
                do {
                    double sectionWidth = Math.min((double)textureWidth, xMax - xPos);
                    double uWidth = sectionWidth / (double)textureWidth;
                    double yPos = yMin;
                    do {
                        double sectionHeight = Math.min((double)textureHeight, yMax - yPos);
                        double vWidth = sectionHeight / (double)textureHeight;
                        this.partialSprite(type, xPos, yPos, xPos + sectionWidth, yPos + sectionHeight, sprite, 0.0f, 0.0f, (float)uWidth, (float)vWidth, red, green, blue, alpha);
                    } while ((yPos += (double)textureHeight) < yMax);
                } while ((xPos += (double)textureWidth) < xMax);
            };
            if (this.batchDraw) {
                draw.run();
            } else {
                this.batchDraw(draw);
            }
        }
    }

    public void texRect(Material material, Rectangle rectangle) {
        this.texRect(material, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void texRect(Material material, Rectangle rectangle, int argb) {
        this.texRect(material, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void texRect(Material material, Rectangle rectangle, float red, float green, float blue, float alpha) {
        this.texRect(material, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), red, green, blue, alpha);
    }

    public void texRect(Material material, double x, double y, double width, double height) {
        this.texRect(material, x, y, width, height, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void texRect(Material material, double x, double y, double width, double height, int argb) {
        this.texRect(material, x, y, width, height, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void texRect(Material material, double x, double y, double width, double height, float red, float green, float blue, float alpha) {
        this.tex(material, x, y, x + width, y + height, red, green, blue, alpha);
    }

    public void tex(Material material, double xMin, double yMin, double xMax, double yMax) {
        this.tex(material, xMin, yMin, xMax, yMax, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void tex(Material material, double xMin, double yMin, double xMax, double yMax, int argb) {
        this.tex(material, xMin, yMin, xMax, yMax, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void tex(Material material, double xMin, double yMin, double xMax, double yMax, float red, float green, float blue, float alpha) {
        TextureAtlasSprite sprite = material.sprite();
        VertexConsumer buffer = material.buffer((MultiBufferSource)this.buffers, GuiRender::texColType);
        Matrix4f mat = this.pose.last().pose();
        buffer.addVertex(mat, (float)xMax, (float)yMax, 0.0f).setColor(red, green, blue, alpha).setUv(sprite.getU1(), sprite.getV1());
        buffer.addVertex(mat, (float)xMax, (float)yMin, 0.0f).setColor(red, green, blue, alpha).setUv(sprite.getU1(), sprite.getV0());
        buffer.addVertex(mat, (float)xMin, (float)yMin, 0.0f).setColor(red, green, blue, alpha).setUv(sprite.getU0(), sprite.getV0());
        buffer.addVertex(mat, (float)xMin, (float)yMax, 0.0f).setColor(red, green, blue, alpha).setUv(sprite.getU0(), sprite.getV1());
        this.flushIfUnBatched();
    }

    public void texRect(Material material, int rotation, Rectangle rectangle) {
        this.texRect(material, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), rotation, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void texRect(Material material, int rotation, Rectangle rectangle, int argb) {
        this.texRect(material, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), rotation, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void texRect(Material material, int rotation, Rectangle rectangle, float red, float green, float blue, float alpha) {
        this.texRect(material, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), rotation, red, green, blue, alpha);
    }

    public void texRect(Material material, int rotation, double x, double y, double width, double height) {
        this.texRect(material, x, y, width, height, rotation, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void texRect(Material material, int rotation, double x, double y, double width, double height, int argb) {
        this.texRect(material, x, y, width, height, rotation, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void texRect(Material material, double x, double y, double width, double height, int rotation, float red, float green, float blue, float alpha) {
        this.tex(material, x, y, x + width, y + height, rotation, red, green, blue, alpha);
    }

    public void tex(Material material, int rotation, double xMin, double yMin, double xMax, double yMax) {
        this.tex(material, xMin, yMin, xMax, yMax, rotation, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void tex(Material material, double xMin, double yMin, double xMax, double yMax, int rotation, int argb) {
        this.tex(material, xMin, yMin, xMax, yMax, rotation, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void tex(Material material, double xMin, double yMin, double xMax, double yMax, int rotation, float red, float green, float blue, float alpha) {
        TextureAtlasSprite sprite = material.sprite();
        VertexConsumer buffer = material.buffer((MultiBufferSource)this.buffers, GuiRender::texColType);
        float[] u = new float[]{sprite.getU0(), sprite.getU1(), sprite.getU1(), sprite.getU0()};
        float[] v = new float[]{sprite.getV1(), sprite.getV1(), sprite.getV0(), sprite.getV0()};
        Matrix4f mat = this.pose.last().pose();
        buffer.addVertex(mat, (float)xMax, (float)yMax, 0.0f).setColor(red, green, blue, alpha).setUv(u[(1 + rotation) % 4], v[(1 + rotation) % 4]);
        buffer.addVertex(mat, (float)xMax, (float)yMin, 0.0f).setColor(red, green, blue, alpha).setUv(u[(2 + rotation) % 4], v[(2 + rotation) % 4]);
        buffer.addVertex(mat, (float)xMin, (float)yMin, 0.0f).setColor(red, green, blue, alpha).setUv(u[(3 + rotation) % 4], v[(3 + rotation) % 4]);
        buffer.addVertex(mat, (float)xMin, (float)yMax, 0.0f).setColor(red, green, blue, alpha).setUv(u[(0 + rotation) % 4], v[(0 + rotation) % 4]);
        this.flushIfUnBatched();
    }

    public void dynamicTex(Material material, Rectangle rectangle, Borders borders, int argb) {
        this.dynamicTex(material, (int)rectangle.x(), (int)rectangle.y(), (int)rectangle.width(), (int)rectangle.height(), (int)borders.top(), (int)borders.left(), (int)borders.bottom(), (int)borders.right(), argb);
    }

    public void dynamicTex(Material material, Rectangle rectangle, int topBorder, int leftBorder, int bottomBorder, int rightBorder, int argb) {
        this.dynamicTex(material, (int)rectangle.x(), (int)rectangle.y(), (int)rectangle.width(), (int)rectangle.height(), topBorder, leftBorder, bottomBorder, rightBorder, argb);
    }

    public void dynamicTex(Material material, int x, int y, int width, int height, int topBorder, int leftBorder, int bottomBorder, int rightBorder, int argb) {
        this.dynamicTex(material, x, y, width, height, topBorder, leftBorder, bottomBorder, rightBorder, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void dynamicTex(Material material, Rectangle rectangle, Borders borders) {
        this.dynamicTex(material, (int)rectangle.x(), (int)rectangle.y(), (int)rectangle.width(), (int)rectangle.height(), (int)borders.top(), (int)borders.left(), (int)borders.bottom(), (int)borders.right());
    }

    public void dynamicTex(Material material, Rectangle rectangle, int topBorder, int leftBorder, int bottomBorder, int rightBorder) {
        this.dynamicTex(material, (int)rectangle.x(), (int)rectangle.y(), (int)rectangle.width(), (int)rectangle.height(), topBorder, leftBorder, bottomBorder, rightBorder);
    }

    public void dynamicTex(Material material, int x, int y, int width, int height, int topBorder, int leftBorder, int bottomBorder, int rightBorder) {
        this.dynamicTex(material, x, y, width, height, topBorder, leftBorder, bottomBorder, rightBorder, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void dynamicTex(Material material, int x, int y, int width, int height, int topBorder, int leftBorder, int bottomBorder, int rightBorder, float red, float green, float blue, float alpha) {
        if (this.batchDraw) {
            this.dynamicTexInternal(material, x, y, width, height, topBorder, leftBorder, bottomBorder, rightBorder, red, green, blue, alpha);
        } else {
            this.batchDraw(() -> this.dynamicTexInternal(material, x, y, width, height, topBorder, leftBorder, bottomBorder, rightBorder, red, green, blue, alpha));
        }
    }

    private void dynamicTexInternal(Material material, int xPos, int yPos, int xSize, int ySize, int topBorder, int leftBorder, int bottomBorder, int rightBorder, float red, float green, float blue, float alpha) {
        TextureAtlasSprite sprite = material.sprite();
        VertexConsumer buffer = material.buffer((MultiBufferSource)this.buffers, GuiRender::texColType);
        Matrix4f mat = this.pose.last().pose();
        SpriteContents contents = sprite.contents();
        int texWidth = contents.width();
        int texHeight = contents.height();
        int trimWidth = texWidth - leftBorder - rightBorder;
        int trimHeight = texHeight - topBorder - bottomBorder;
        if (xSize <= texWidth) {
            trimWidth = Math.min(trimWidth, xSize - rightBorder);
        }
        if (xSize <= 0 || ySize <= 0 || trimWidth <= 0 || trimHeight <= 0) {
            return;
        }
        for (int x = 0; x < xSize; x += trimWidth) {
            int rWidth = Math.min(xSize - x, trimWidth);
            int trimU = 0;
            if (x != 0) {
                trimU = x + leftBorder + trimWidth <= xSize ? leftBorder : texWidth - (xSize - x);
            }
            this.bufferDynamic(buffer, mat, sprite, xPos + x, yPos, trimU, 0.0f, rWidth, topBorder, red, green, blue, alpha);
            this.bufferDynamic(buffer, mat, sprite, xPos + x, yPos + ySize - bottomBorder, trimU, texHeight - bottomBorder, rWidth, bottomBorder, red, green, blue, alpha);
            rWidth = Math.min(xSize - x - leftBorder - rightBorder, trimWidth);
            for (int y = 0; y < ySize; y += trimHeight) {
                int rHeight = Math.min(ySize - y - topBorder - bottomBorder, trimHeight);
                int trimV = y + (texHeight - topBorder - bottomBorder) <= ySize ? topBorder : texHeight - (ySize - y);
                if (x == 0 && y + topBorder < ySize - bottomBorder) {
                    this.bufferDynamic(buffer, mat, sprite, xPos, yPos + y + topBorder, 0.0f, trimV, leftBorder, rHeight, red, green, blue, alpha);
                    this.bufferDynamic(buffer, mat, sprite, xPos + xSize - rightBorder, yPos + y + topBorder, trimU + texWidth - rightBorder, trimV, rightBorder, rHeight, red, green, blue, alpha);
                }
                if (y + topBorder >= ySize - bottomBorder || x + leftBorder >= xSize - rightBorder) continue;
                this.bufferDynamic(buffer, mat, sprite, xPos + x + leftBorder, yPos + y + topBorder, leftBorder, topBorder, rWidth, rHeight, red, green, blue, alpha);
            }
        }
    }

    private void bufferDynamic(VertexConsumer builder, Matrix4f mat, TextureAtlasSprite tex, int x, int y, float textureX, float textureY, int width, int height, float red, float green, float blue, float alpha) {
        int w = tex.contents().width();
        int h = tex.contents().height();
        builder.addVertex(mat, (float)x, (float)(y + height), 0.0f).setColor(red, green, blue, alpha).setUv(tex.getU(textureX / (float)w), tex.getV((textureY + (float)height) / (float)h));
        builder.addVertex(mat, (float)(x + width), (float)(y + height), 0.0f).setColor(red, green, blue, alpha).setUv(tex.getU((textureX + (float)width) / (float)w), tex.getV((textureY + (float)height) / (float)h));
        builder.addVertex(mat, (float)(x + width), (float)y, 0.0f).setColor(red, green, blue, alpha).setUv(tex.getU((textureX + (float)width) / (float)w), tex.getV(textureY / (float)h));
        builder.addVertex(mat, (float)x, (float)y, 0.0f).setColor(red, green, blue, alpha).setUv(tex.getU(textureX / (float)w), tex.getV(textureY / (float)h));
    }

    public int drawString(@Nullable String message, double x, double y, int colour) {
        return this.drawString(message, x, y, colour, true);
    }

    public int drawString(@Nullable String message, double x, double y, int colour, boolean shadow) {
        if (message == null) {
            return 0;
        }
        int i = this.font().drawInBatch(message, (float)x, (float)y, colour, shadow, this.pose.last().pose(), (MultiBufferSource)this.buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0, this.font().isBidirectional());
        this.flushIfUnBatched();
        return i;
    }

    public int drawString(FormattedCharSequence message, double x, double y, int colour) {
        return this.drawString(message, x, y, colour, true);
    }

    public int drawString(FormattedCharSequence message, double x, double y, int colour, boolean shadow) {
        int i = this.font().drawInBatch(message, (float)x, (float)y, colour, shadow, this.pose.last().pose(), (MultiBufferSource)this.buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.flushIfUnBatched();
        return i;
    }

    public int drawString(Component message, double x, double y, int colour) {
        return this.drawString(message, x, y, colour, true);
    }

    public int drawString(Component message, double x, double y, int colour, boolean shadow) {
        return this.drawString(message.getVisualOrderText(), x, y, colour, shadow);
    }

    public void drawWordWrap(FormattedText message, double x, double y, int width, int colour) {
        this.drawWordWrap(message, x, y, width, colour, false);
    }

    public void drawWordWrap(FormattedText message, double x, double y, int width, int colour, boolean shadow) {
        Objects.requireNonNull(this.font());
        this.drawWordWrap(message, x, y, width, colour, shadow, 9.0);
    }

    public void drawWordWrap(FormattedText message, double x, double y, int width, int colour, boolean shadow, double spacing) {
        for (FormattedCharSequence formattedcharsequence : this.font().split(message, width)) {
            this.drawString(formattedcharsequence, x, y, colour, shadow);
            y += spacing;
        }
    }

    public void drawCenteredString(String message, double x, double y, int colour) {
        this.drawCenteredString(message, x, y, colour, true);
    }

    public void drawCenteredString(String message, double x, double y, int colour, boolean shadow) {
        this.drawString(message, x - (double)this.font().width(message) / 2.0, y, colour, shadow);
    }

    public void drawCenteredString(Component message, double x, double y, int colour) {
        this.drawCenteredString(message, x, y, colour, true);
    }

    public void drawCenteredString(Component message, double x, double y, int colour, boolean shadow) {
        FormattedCharSequence formattedcharsequence = message.getVisualOrderText();
        this.drawString(formattedcharsequence, x - (double)this.font().width(formattedcharsequence) / 2.0, y, colour, shadow);
    }

    public void drawCenteredString(FormattedCharSequence message, double x, double y, int colour) {
        this.drawCenteredString(message, x, y, colour, true);
    }

    public void drawCenteredString(FormattedCharSequence message, double x, double y, int colour, boolean shadow) {
        this.drawString(message, x - (double)this.font().width(message) / 2.0, y, colour, shadow);
    }

    public void drawScrollingString(Component component, double x, double y, double xMax, int colour, boolean shadow) {
        this.drawScrollingString(component, x, y, xMax, colour, shadow, true);
    }

    public void drawScrollingString(Component component, double x, double y, double xMax, int colour, boolean shadow, boolean doScissor) {
        double width;
        int textWidth = this.font().width((FormattedText)component);
        if ((double)textWidth > (width = xMax - x)) {
            double outside = (double)textWidth - width;
            double anim = (double)Util.getMillis() / 1000.0;
            double e = Math.max(outside * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * anim / e)) / 2.0 + 0.5;
            double offset = Mth.lerp((double)f, (double)0.0, (double)outside);
            if (doScissor) {
                Objects.requireNonNull(this.font());
                this.pushScissor(x, y - 1.0, xMax, y + 9.0 + 1.0);
            }
            this.drawString(component, x - offset, y, colour, shadow);
            if (doScissor) {
                this.popScissor();
            }
        } else {
            this.drawCenteredString(component, (x + xMax) / 2.0, y, colour, shadow);
        }
    }

    public void renderTooltip(ItemStack stack, double mouseX, double mouseY) {
        this.renderTooltip(stack, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847);
    }

    public void renderTooltip(ItemStack stack, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        this.tooltipStack = stack;
        this.toolTipWithImage(Screen.getTooltipFromItem((Minecraft)this.mc(), (ItemStack)stack), stack.getTooltipImage(), mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom);
        this.tooltipStack = ItemStack.EMPTY;
    }

    public void toolTipWithImage(List<Component> tooltips, Optional<TooltipComponent> tooltipImage, ItemStack stack, double mouseX, double mouseY) {
        this.toolTipWithImage(tooltips, tooltipImage, stack, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847);
    }

    public void toolTipWithImage(List<Component> tooltips, Optional<TooltipComponent> tooltipImage, ItemStack stack, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        this.tooltipStack = stack;
        this.toolTipWithImage(tooltips, tooltipImage, mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom);
        this.tooltipStack = ItemStack.EMPTY;
    }

    public void toolTipWithImage(List<Component> tooltip, Optional<TooltipComponent> tooltipImage, double mouseX, double mouseY) {
        this.toolTipWithImage(tooltip, tooltipImage, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847);
    }

    public void toolTipWithImage(List<Component> tooltip, Optional<TooltipComponent> tooltipImage, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        List<ClientTooltipComponent> list = PolyLibClient.postGatherTooltipComponents(this.tooltipStack, tooltip, tooltipImage, (int)mouseX, this.guiWidth(), this.guiHeight(), this.font());
        this.renderTooltipInternal(list, mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom, DefaultTooltipPositioner.INSTANCE);
    }

    public void renderTooltip(Component message, double mouseX, double mouseY) {
        this.renderTooltip(message, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847);
    }

    public void renderTooltip(Component message, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        List<ClientTooltipComponent> list = PolyLibClient.postGatherTooltipComponents(this.tooltipStack, List.of(message), Optional.empty(), (int)mouseX, this.guiWidth(), this.guiHeight(), this.font());
        this.renderTooltipInternal(list, mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom, DefaultTooltipPositioner.INSTANCE);
    }

    public void componentTooltip(List<Component> tooltips, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        List<ClientTooltipComponent> components = PolyLibClient.postGatherTooltipComponents(this.tooltipStack, tooltips, Optional.empty(), (int)mouseX, this.guiWidth(), this.guiHeight(), this.font());
        this.renderTooltipInternal(components, mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom, DefaultTooltipPositioner.INSTANCE);
    }

    public void componentTooltip(List<? extends FormattedText> tooltips, double mouseX, double mouseY, ItemStack stack) {
        this.componentTooltip(tooltips, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847, stack);
    }

    public void componentTooltip(List<? extends FormattedText> tooltips, double mouseX, double mouseY) {
        this.componentTooltip(tooltips, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847, ItemStack.EMPTY);
    }

    public void componentTooltip(List<? extends FormattedText> tooltips, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom, ItemStack stack) {
        this.tooltipStack = stack;
        List<ClientTooltipComponent> components = PolyLibClient.postGatherTooltipComponents(stack, tooltips, Optional.empty(), (int)mouseX, this.guiWidth(), this.guiHeight(), this.font());
        this.renderTooltipInternal(components, mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom, DefaultTooltipPositioner.INSTANCE);
        this.tooltipStack = ItemStack.EMPTY;
    }

    public void renderTooltip(List<? extends FormattedCharSequence> tooltips, double mouseX, double mouseY) {
        this.renderTooltip(tooltips, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847);
    }

    public void renderTooltip(List<? extends FormattedCharSequence> tooltips, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        this.renderTooltipInternal(tooltips.stream().map(ClientTooltipComponent::create).collect(Collectors.toList()), mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom, DefaultTooltipPositioner.INSTANCE);
    }

    public void renderTooltip(List<FormattedCharSequence> tooltips, ClientTooltipPositioner positioner, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        this.renderTooltipInternal(tooltips.stream().map(ClientTooltipComponent::create).collect(Collectors.toList()), mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom, positioner);
    }

    private void renderTooltipInternal(List<ClientTooltipComponent> tooltips, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom, ClientTooltipPositioner positioner) {
        if (!tooltips.isEmpty()) {
            ClientTooltipComponent component;
            int i;
            PolyLibClient.ToolTipResult event = PolyLibClient.postRenderTooltipPre(this.tooltipStack, this.renderWrapper, (int)mouseX, (int)mouseY, this.guiWidth(), this.guiHeight(), tooltips, this.font(), positioner);
            if (event.canceled()) {
                return;
            }
            int width = 0;
            int height = tooltips.size() == 1 ? -2 : 0;
            for (ClientTooltipComponent line : tooltips) {
                width = Math.max(width, line.getWidth(event.getFont()));
                height += line.getHeight();
            }
            Vector2ic position = positioner.positionTooltip(this.guiWidth(), this.guiHeight(), event.getX(), event.getY(), width, height);
            int xPos = position.x();
            int yPos = Math.max(position.y(), 3);
            this.pose.pushPose();
            this.pose.translate(0.0f, 0.0f, 400.0f);
            PolyLibClient.ToolTipColour colour = PolyLibClient.postTooltipColour(this.tooltipStack, this.renderWrapper, xPos, yPos, backgroundTop, backgroundBottom, borderTop, borderBottom, event.getFont(), tooltips);
            this.toolTipBackground(xPos - 3, yPos - 3, width + 6, height + 6, colour.getBackgroundStart(), colour.getBackgroundEnd(), colour.getBorderStart(), colour.getBorderEnd(), true);
            int linePos = yPos;
            for (i = 0; i < tooltips.size(); ++i) {
                component = tooltips.get(i);
                component.renderText(event.getFont(), xPos, linePos, this.pose.last().pose(), this.buffers);
                linePos += component.getHeight() + (i == 0 ? 2 : 0);
            }
            linePos = yPos;
            for (i = 0; i < tooltips.size(); ++i) {
                component = tooltips.get(i);
                component.renderImage(event.getFont(), xPos, linePos, (GuiGraphics)this.renderWrapper);
                linePos += component.getHeight() + (i == 0 ? 2 : 0);
            }
            this.pose.popPose();
        }
    }

    public void renderComponentHoverEffect(@Nullable Style style, int mouseX, int mouseY) {
        if (style != null && style.getHoverEvent() != null) {
            HoverEvent event = style.getHoverEvent();
            HoverEvent.ItemStackInfo stackInfo = (HoverEvent.ItemStackInfo)event.getValue(HoverEvent.Action.SHOW_ITEM);
            if (stackInfo != null) {
                this.renderTooltip(stackInfo.getItemStack(), (double)mouseX, (double)mouseY);
            } else {
                HoverEvent.EntityTooltipInfo tooltipInfo = (HoverEvent.EntityTooltipInfo)event.getValue(HoverEvent.Action.SHOW_ENTITY);
                if (tooltipInfo != null) {
                    if (this.mc().options.advancedItemTooltips) {
                        this.componentTooltip(tooltipInfo.getTooltipLines(), mouseX, mouseY);
                    }
                } else {
                    Component component = (Component)event.getValue(HoverEvent.Action.SHOW_TEXT);
                    if (component != null) {
                        this.renderTooltip(this.font().split((FormattedText)component, Math.max(this.guiWidth() / 2, 200)), (double)mouseX, (double)mouseY);
                    }
                }
            }
        }
    }

    public void renderItem(ItemStack stack, double x, double y) {
        this.renderItem(stack, x, y, 16.0);
    }

    public void renderItem(ItemStack stack, double x, double y, double size) {
        this.renderItem((LivingEntity)this.mc().player, (Level)this.mc().level, stack, x, y, size, 0);
    }

    public void renderItem(ItemStack stack, double x, double y, double size, int modelRand) {
        this.renderItem((LivingEntity)this.mc().player, (Level)this.mc().level, stack, x, y, size, modelRand);
    }

    public void renderFakeItem(ItemStack stack, double x, double y) {
        this.renderFakeItem(stack, x, y, 16.0);
    }

    public void renderFakeItem(ItemStack stack, double x, double y, double size) {
        this.renderItem(null, (Level)this.mc().level, stack, x, y, size, 0);
    }

    public void renderItem(LivingEntity entity, ItemStack stack, double x, double y, int modelRand) {
        this.renderItem(entity, stack, x, y, 16.0, modelRand);
    }

    public void renderItem(LivingEntity entity, ItemStack stack, double x, double y, double size, int modelRand) {
        this.renderItem(entity, entity.level(), stack, x, y, size, modelRand);
    }

    public void renderItem(@Nullable LivingEntity entity, @Nullable Level level, ItemStack stack, double x, double y, double size, int modelRand) {
        if (!stack.isEmpty()) {
            BakedModel bakedmodel = this.mc().getItemRenderer().getModel(stack, level, entity, modelRand);
            this.pose.pushPose();
            this.pose.translate(x + size / 2.0, y + size / 2.0, size);
            try {
                boolean flag;
                this.pose.mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
                this.pose.scale((float)size, (float)size, (float)size);
                boolean bl = flag = !bakedmodel.usesBlockLight();
                if (flag) {
                    Lighting.setupForFlatItems();
                }
                this.mc().getItemRenderer().render(stack, ItemDisplayContext.GUI, false, this.pose, (MultiBufferSource)this.buffers, 0xF000F0, OverlayTexture.NO_OVERLAY, bakedmodel);
                this.flush();
                if (flag) {
                    Lighting.setupFor3DItems();
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Rendering item");
                CrashReportCategory crashreportcategory = crashreport.addCategory("Item being rendered");
                crashreportcategory.setDetail("Item Type", () -> String.valueOf(stack.getItem()));
                crashreportcategory.setDetail("Item Stack", () -> String.valueOf(stack.getItem()));
                crashreportcategory.setDetail("Item Damage", () -> String.valueOf(stack.getDamageValue()));
                crashreportcategory.setDetail("Item Foil", () -> String.valueOf(stack.hasFoil()));
                throw new ReportedException(crashreport);
            }
            this.pose.popPose();
        }
    }

    public void renderItemDecorations(ItemStack stack, double x, double y) {
        this.renderItemDecorations(stack, x, y, 16.0);
    }

    public void renderItemDecorations(ItemStack stack, double x, double y, double size) {
        this.renderItemDecorations(stack, x, y, size, null);
    }

    public void renderItemDecorations(ItemStack stack, double x, double y, @Nullable String text) {
        this.renderItemDecorations(stack, x, y, 16.0, text);
    }

    public void renderItemDecorations(ItemStack stack, double x, double y, double size, @Nullable String text) {
        if (!stack.isEmpty()) {
            LocalPlayer localplayer;
            float f;
            this.pose.pushPose();
            float scale = (float)size / 16.0f;
            this.pose.translate(x, y, size * 2.0 - 0.1);
            this.pose.scale(scale, scale, 1.0f);
            this.pose.translate(-x, -y, 0.0);
            if (stack.getCount() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.getCount()) : text;
                this.drawString(s, x + 19.0 - 2.0 - (double)this.font().width(s), y + 6.0 + 3.0, 0xFFFFFF, true);
            }
            if (stack.isBarVisible()) {
                int l = stack.getBarWidth();
                int i = stack.getBarColor();
                double j = x + 2.0;
                double k = y + 13.0;
                this.pose.translate(0.0, 0.0, 0.04);
                this.fill(j, k, j + 13.0, k + 2.0, -16777216);
                this.pose.translate(0.0, 0.0, 0.02);
                this.fill(j, k, j + (double)l, k + 1.0, i | 0xFF000000);
            }
            float f2 = f = (localplayer = this.mc().player) == null ? 0.0f : localplayer.getCooldowns().getCooldownPercent(stack.getItem(), (float)this.mc().getFrameTimeNs());
            if (f > 0.0f) {
                double i1 = y + (double)Mth.floor((float)(16.0f * (1.0f - f)));
                double j1 = i1 + (double)Mth.ceil((float)(16.0f * f));
                this.pose.translate(0.0, 0.0, 0.02);
                this.fill(x, i1, x + 16.0, j1, Integer.MAX_VALUE);
            }
            this.pose.popPose();
            if (size == 16.0) {
                PolyLibClient.onItemDecorate(this.renderWrapper, this.font(), stack, (int)x, (int)y);
            }
        }
    }

    public void pushScissorRect(Rectangle rectangle) {
        this.pushScissorRect(rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height());
    }

    public void pushScissorRect(double x, double y, double width, double height) {
        this.flushIfBatched();
        this.scissorHandler.pushGuiScissor(x, y, width, height);
    }

    public void pushScissor(double xMin, double yMin, double xMax, double yMax) {
        this.flushIfBatched();
        this.scissorHandler.pushGuiScissor(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    public void popScissor() {
        this.scissorHandler.popScissor();
    }

    public void setColor(float red, float green, float blue, float alpha) {
        this.flushIfBatched();
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static boolean isInRect(double minX, double minY, double width, double height, double testX, double testY) {
        return testX >= minX && testX < minX + width && testY >= minY && testY < minY + height;
    }

    public static boolean isInRect(int minX, int minY, int width, int height, double testX, double testY) {
        return testX >= (double)minX && testX < (double)(minX + width) && testY >= (double)minY && testY < (double)(minY + height);
    }

    public static int mixColours(int colour1, int colour2) {
        return GuiRender.mixColours(colour1, colour2, false);
    }

    public static int mixColours(int colour1, int colour2, boolean subtract) {
        int alpha1 = colour1 >> 24 & 0xFF;
        int alpha2 = colour2 >> 24 & 0xFF;
        int red1 = colour1 >> 16 & 0xFF;
        int red2 = colour2 >> 16 & 0xFF;
        int green1 = colour1 >> 8 & 0xFF;
        int green2 = colour2 >> 8 & 0xFF;
        int blue1 = colour1 & 0xFF;
        int blue2 = colour2 & 0xFF;
        int alpha = Mth.clamp((int)(alpha1 + (subtract ? -alpha2 : alpha2)), (int)0, (int)255);
        int red = Mth.clamp((int)(red1 + (subtract ? -red2 : red2)), (int)0, (int)255);
        int green = Mth.clamp((int)(green1 + (subtract ? -green2 : green2)), (int)0, (int)255);
        int blue = Mth.clamp((int)(blue1 + (subtract ? -blue2 : blue2)), (int)0, (int)255);
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public static int midColour(int colour1, int colour2) {
        int alpha1 = colour1 >> 24 & 0xFF;
        int alpha2 = colour2 >> 24 & 0xFF;
        int red1 = colour1 >> 16 & 0xFF;
        int red2 = colour2 >> 16 & 0xFF;
        int green1 = colour1 >> 8 & 0xFF;
        int green2 = colour2 >> 8 & 0xFF;
        int blue1 = colour1 & 0xFF;
        int blue2 = colour2 & 0xFF;
        return (alpha2 + (alpha1 - alpha2) / 2 & 0xFF) << 24 | (red2 + (red1 - red2) / 2 & 0xFF) << 16 | (green2 + (green1 - green2) / 2 & 0xFF) << 8 | blue2 + (blue1 - blue2) / 2 & 0xFF;
    }

    private static float r(int argb) {
        return (float)FastColor.ARGB32.red((int)argb) / 255.0f;
    }

    private static float g(int argb) {
        return (float)FastColor.ARGB32.green((int)argb) / 255.0f;
    }

    private static float b(int argb) {
        return (float)FastColor.ARGB32.blue((int)argb) / 255.0f;
    }

    private static float a(int argb) {
        return (float)FastColor.ARGB32.alpha((int)argb) / 255.0f;
    }

    public static RenderType texType(ResourceLocation location) {
        return RenderType.create((String)"tex_type", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionTexShader)).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(location, false, false)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setCullState(RenderStateShard.NO_CULL).createCompositeState(false));
    }

    public static RenderType texColType(ResourceLocation location) {
        return RenderType.create((String)"tex_col_type", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionTexColorShader)).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(location, false, false)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setCullState(RenderStateShard.NO_CULL).createCompositeState(false));
    }

    public static class RenderWrapper
    extends GuiGraphics {
        private final GuiRender wrapped;

        private RenderWrapper(GuiRender wrapped) {
            super(wrapped.mc(), wrapped.pose(), wrapped.buffers());
            this.wrapped = wrapped;
        }

        public void drawManaged(Runnable runnable) {
            this.wrapped.batchDraw(runnable);
        }

        public void flush() {
            this.wrapped.flush();
        }

        protected void flushIfManaged() {
            this.wrapped.flushIfBatched();
        }

        protected void flushIfUnmanaged() {
            this.wrapped.flushIfUnBatched();
        }
    }
}

