/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.elements;

import java.util.function.Supplier;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Borders;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.sprite.Material;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiTexture
extends GuiElement<GuiTexture>
implements BackgroundRender {
    private Supplier<Material> getMaterial;
    private Supplier<Integer> colour = () -> -1;
    private Borders dynamicBorders = null;

    public GuiTexture(@NotNull GuiParent<?> parent) {
        super(parent);
    }

    public GuiTexture(@NotNull GuiParent<?> parent, Supplier<Material> supplier) {
        super(parent);
        this.setMaterial(supplier);
    }

    public GuiTexture(@NotNull GuiParent<?> parent, Material material) {
        super(parent);
        this.setMaterial(material);
    }

    public GuiTexture setMaterial(Supplier<Material> supplier) {
        this.getMaterial = supplier;
        return this;
    }

    public GuiTexture setMaterial(Material material) {
        this.getMaterial = () -> material;
        return this;
    }

    @Nullable
    public Material getMaterial() {
        return this.getMaterial == null ? null : this.getMaterial.get();
    }

    public GuiTexture dynamicTexture() {
        return this.dynamicTexture(5);
    }

    public GuiTexture dynamicTexture(int textureBorders) {
        return this.dynamicTexture(Borders.create(textureBorders));
    }

    public GuiTexture dynamicTexture(Borders textureBorders) {
        this.dynamicBorders = textureBorders;
        return this;
    }

    public GuiTexture setColour(int colourARGB) {
        return this.setColour(() -> colourARGB);
    }

    public GuiTexture setColour(Supplier<Integer> colour) {
        this.colour = colour;
        return this;
    }

    @Override
    public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        Material material = this.getMaterial();
        if (material == null) {
            return;
        }
        if (this.dynamicBorders != null) {
            render.dynamicTex(material, this.getRectangle(), this.dynamicBorders, this.colour.get());
        } else {
            render.texRect(material, this.getRectangle(), this.colour.get());
        }
    }
}

