/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.gif;

import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;

public class GifSequenceWriter {
    protected ImageWriter writer = ImageIO.getImageWritersBySuffix("gif").next();
    protected ImageWriteParam params = this.writer.getDefaultWriteParam();
    protected IIOMetadata metadata;

    public GifSequenceWriter(ImageOutputStream out, int imageType, int delay, boolean loop) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(imageType);
        this.metadata = this.writer.getDefaultImageMetadata(imageTypeSpecifier, this.params);
        this.configureRootMetadata(delay, loop);
        this.writer.setOutput(out);
        this.writer.prepareWriteSequence(null);
    }

    private void configureRootMetadata(int delay, boolean loop) throws IIOInvalidTreeException {
        String metaFormatName = this.metadata.getNativeMetadataFormatName();
        IIOMetadataNode root = (IIOMetadataNode)this.metadata.getAsTree(metaFormatName);
        IIOMetadataNode graphicsControlExtensionNode = GifSequenceWriter.getNode(root, "GraphicControlExtension");
        graphicsControlExtensionNode.setAttribute("disposalMethod", "none");
        graphicsControlExtensionNode.setAttribute("userInputFlag", "FALSE");
        graphicsControlExtensionNode.setAttribute("transparentColorFlag", "FALSE");
        graphicsControlExtensionNode.setAttribute("delayTime", Integer.toString(delay / 10));
        graphicsControlExtensionNode.setAttribute("transparentColorIndex", "0");
        IIOMetadataNode commentsNode = GifSequenceWriter.getNode(root, "CommentExtensions");
        commentsNode.setAttribute("CommentExtension", "Recorded using BlockShot: https://blockshot.ch");
        IIOMetadataNode appExtensionsNode = GifSequenceWriter.getNode(root, "ApplicationExtensions");
        IIOMetadataNode child = new IIOMetadataNode("ApplicationExtension");
        child.setAttribute("applicationID", "NETSCAPE");
        child.setAttribute("authenticationCode", "2.0");
        int loopContinuously = loop ? 0 : 1;
        child.setUserObject(new byte[]{1, (byte)(loopContinuously & 0xFF), (byte)(loopContinuously >> 8 & 0xFF)});
        appExtensionsNode.appendChild(child);
        this.metadata.setFromTree(metaFormatName, root);
    }

    private static IIOMetadataNode getNode(IIOMetadataNode rootNode, String nodeName) {
        int nNodes = rootNode.getLength();
        for (int i = 0; i < nNodes; ++i) {
            if (!rootNode.item(i).getNodeName().equalsIgnoreCase(nodeName)) continue;
            return (IIOMetadataNode)rootNode.item(i);
        }
        IIOMetadataNode node = new IIOMetadataNode(nodeName);
        rootNode.appendChild(node);
        return node;
    }

    public void writeToSequence(RenderedImage img) throws IOException {
        this.writer.writeToSequence(new IIOImage(img, null, this.metadata), this.params);
    }

    public void close() throws IOException {
        this.writer.endWriteSequence();
    }
}

