/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.network;

import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.silentchaos512.gear.block.alloymaker.AlloyMakerContainer;
import net.silentchaos512.gear.item.ICycleItem;
import net.silentchaos512.gear.item.blueprint.book.BlueprintBookItem;
import net.silentchaos512.gear.network.payload.client.AckPayload;
import net.silentchaos512.gear.network.payload.client.AlloyMakerUpdatePayload;
import net.silentchaos512.gear.network.payload.client.KeyPressOnItemPayload;
import net.silentchaos512.gear.network.payload.client.RecalculateStatsPayload;
import net.silentchaos512.gear.network.payload.client.SelectBlueprintInBookPayload;
import net.silentchaos512.gear.network.payload.client.SwingGearPayload;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public class SgServerPayloadHandler {
    private static final SgServerPayloadHandler INSTANCE = new SgServerPayloadHandler();

    public static SgServerPayloadHandler getInstance() {
        return INSTANCE;
    }

    private static void handleData(IPayloadContext ctx, Runnable handler) {
        ctx.enqueueWork(handler).exceptionally(e -> {
            ctx.disconnect((Component)Component.translatable((String)"network.silentgear.failure", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleAck(AckPayload data, IPayloadContext ctx) {
    }

    public void handleAlloyMakerUpdate(AlloyMakerUpdatePayload data, IPayloadContext ctx) {
        SgServerPayloadHandler.handleData(ctx, () -> {
            Player player = ctx.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof AlloyMakerContainer) {
                AlloyMakerContainer container = (AlloyMakerContainer)patt0$temp;
                container.setWorkEnabled(data.workEnabled());
            }
        });
    }

    public void handleSwingGear(SwingGearPayload data, IPayloadContext ctx) {
        SgServerPayloadHandler.handleData(ctx, () -> {
            Player player = ctx.player();
            ItemStack stack = player.getMainHandItem();
            if (GearHelper.isGear(stack)) {
                GearHelper.onItemSwing(stack, (LivingEntity)player);
            }
        });
    }

    public void handleKeyPressOnItem(KeyPressOnItemPayload data, IPayloadContext ctx) {
        SgServerPayloadHandler.handleData(ctx, () -> {
            Slot inventorySlot;
            ItemStack stack;
            Player player = ctx.player();
            if (data.slot() >= 0 && data.slot() < player.containerMenu.slots.size() && !(stack = (inventorySlot = player.containerMenu.getSlot(data.slot())).getItem()).isEmpty()) {
                switch (data.keyPressType()) {
                    case CYCLE_BACK: 
                    case CYCLE_NEXT: {
                        Item patt0$temp = stack.getItem();
                        if (!(patt0$temp instanceof ICycleItem)) break;
                        ICycleItem cycleItem = (ICycleItem)patt0$temp;
                        cycleItem.onCycleKeyPress(stack, data.keyPressType().direction);
                        player.containerMenu.slotsChanged(inventorySlot.container);
                        break;
                    }
                }
            }
        });
    }

    public void handleRecalculateStats(RecalculateStatsPayload data, IPayloadContext ctx) {
        SgServerPayloadHandler.handleData(ctx, () -> {
            ItemStack stack;
            Player player = ctx.player();
            if (data.slot() >= 0 && data.slot() < player.getInventory().getContainerSize() && GearHelper.isGear(stack = player.getInventory().getItem(data.slot()))) {
                GearData.recalculateGearData(stack, player);
            }
        });
    }

    public void handleSelectBlueprintInBook(SelectBlueprintInBookPayload data, IPayloadContext ctx) {
        SgServerPayloadHandler.handleData(ctx, () -> {
            ItemStack book;
            Player player = ctx.player();
            if (data.bookSlot() >= 0 && data.bookSlot() < player.containerMenu.slots.size() && !(book = player.containerMenu.getSlot(data.bookSlot()).getItem()).isEmpty() && book.getItem() instanceof BlueprintBookItem) {
                BlueprintBookItem.setSelectedSlot(book, data.blueprintSlot());
            }
        });
    }
}

