/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.api.traits.TraitEffect;
import net.silentchaos512.gear.api.traits.TraitEffectType;
import net.silentchaos512.gear.core.MagnetPullTracker;
import net.silentchaos512.gear.setup.gear.TraitEffectTypes;

public class ItemMagnetTraitEffect
extends TraitEffect {
    public static final MapCodec<ItemMagnetTraitEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("pull_strength").forGetter(e -> Float.valueOf(e.pullStrength)), (App)Codec.FLOAT.fieldOf("effect_range").forGetter(e -> Float.valueOf(e.effectRange)), (App)Ingredient.CODEC.optionalFieldOf("affected_items", (Object)Ingredient.EMPTY).forGetter(e -> e.affectedItems), (App)Codec.STRING.optionalFieldOf("affected_items_text_for_wiki").forGetter(e -> e.affectedItems.isEmpty() ? Optional.empty() : Optional.of(e.affectedItemsTextForWiki))).apply((Applicative)instance, (pullStrength, pullRange, affectedItems, wikiText) -> wikiText.map(s -> new ItemMagnetTraitEffect(pullStrength.floatValue(), pullRange.floatValue(), (Ingredient)affectedItems, (String)s)).orElseGet(() -> new ItemMagnetTraitEffect(pullStrength.floatValue(), pullRange.floatValue(), (Ingredient)affectedItems))));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemMagnetTraitEffect> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, e -> Float.valueOf(e.pullStrength), (StreamCodec)ByteBufCodecs.FLOAT, e -> Float.valueOf(e.effectRange), (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, e -> e.affectedItems, ItemMagnetTraitEffect::new);
    private final float pullStrength;
    private final float effectRange;
    private final Ingredient affectedItems;
    private final String affectedItemsTextForWiki;

    public ItemMagnetTraitEffect(float pullStrength, float effectRange, Ingredient affectedItems) {
        this(pullStrength, effectRange, affectedItems, !affectedItems.isEmpty() ? "some items" : "all items");
    }

    public ItemMagnetTraitEffect(float pullStrength, float effectRange, Ingredient affectedItems, String affectedItemsTextForWiki) {
        this.pullStrength = pullStrength;
        this.effectRange = effectRange;
        this.affectedItems = affectedItems;
        this.affectedItemsTextForWiki = affectedItemsTextForWiki;
    }

    @Override
    public TraitEffectType<?> type() {
        return TraitEffectTypes.ITEM_MAGNET.get();
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        return List.of("Attracts " + this.affectedItemsTextForWiki + " towards the player");
    }

    @Override
    public void onUpdate(TraitActionContext context, boolean isEquipped) {
        Player player = context.player();
        if (!isEquipped || player == null || player.level().isClientSide) {
            return;
        }
        this.tickMagnet(player, context.traitLevel());
    }

    private boolean isCrouchDisabled(Player player) {
        return player.isCrouching() && (Boolean)Config.Common.magnetPullDisabledOnCrouch.get() != false;
    }

    private boolean canAffectItem(ItemStack stack) {
        return this.affectedItems.isEmpty() || this.affectedItems.test(stack);
    }

    private boolean canMagneticPullItem(ItemEntity entity) {
        return !entity.hasPickUpDelay() && !entity.getPersistentData().getBoolean("PreventRemoteMovement") && this.canAffectItem(entity.getItem());
    }

    private void tickMagnet(Player player, int traitLevel) {
        if (this.isCrouchDisabled(player)) {
            return;
        }
        float range = this.effectRange * (float)traitLevel + 1.0f;
        Vec3 target = new Vec3(player.getX(), player.getY(0.5), player.getZ());
        AABB aabb = new AABB(player.getX() - (double)range, player.getY() - (double)range, player.getZ() - (double)range, player.getX() + (double)range + 1.0, player.getY() + (double)range + 1.0, player.getZ() + (double)range + 1.0);
        for (ItemEntity entity : player.level().getEntitiesOfClass(ItemEntity.class, aabb, e -> e.distanceToSqr((Entity)player) < (double)(range * range))) {
            if (!this.canMagneticPullItem(entity)) continue;
            Vec3 vec = entity.getDismountLocationForPassenger((LivingEntity)player).vectorTo(target);
            vec = vec.normalize().scale((double)this.pullStrength);
            if (entity.getY() < target.y) {
                double xzDistanceSq = (entity.getX() - target.x) * (entity.getX() - target.x) + (entity.getZ() - target.z) * (entity.getZ() - target.z);
                vec = vec.add(0.0, 0.005 + xzDistanceSq / 1000.0, 0.0);
            }
            MagnetPullTracker.pushItem(entity, vec);
        }
    }
}

