/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.recipes;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.core.Holder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.part.GearPart;
import net.silentchaos512.gear.api.part.MaterialGrade;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.core.SoundPlayback;
import net.silentchaos512.gear.crafting.ingredient.BlueprintIngredient;
import net.silentchaos512.gear.crafting.ingredient.CustomAlloyIngredient;
import net.silentchaos512.gear.crafting.ingredient.GearPartIngredient;
import net.silentchaos512.gear.crafting.ingredient.PartMaterialIngredient;
import net.silentchaos512.gear.crafting.recipe.FillRepairKitRecipe;
import net.silentchaos512.gear.crafting.recipe.GearPartSwapRecipe;
import net.silentchaos512.gear.crafting.recipe.ModKitRemovePartRecipe;
import net.silentchaos512.gear.crafting.recipe.QuickRepairRecipe;
import net.silentchaos512.gear.crafting.recipe.ShapedGearRecipe;
import net.silentchaos512.gear.crafting.recipe.ShapelessCompoundPartRecipe;
import net.silentchaos512.gear.crafting.recipe.ShapelessGearRecipe;
import net.silentchaos512.gear.crafting.recipe.press.MaterialPressingRecipe;
import net.silentchaos512.gear.crafting.recipe.salvage.SalvagingRecipe;
import net.silentchaos512.gear.data.recipes.CompoundingRecipeBuilder;
import net.silentchaos512.gear.data.recipes.GearSmithingRecipeBuilder;
import net.silentchaos512.gear.data.recipes.SalvagingRecipeBuilder;
import net.silentchaos512.gear.data.recipes.ShapelessConversionBuilder;
import net.silentchaos512.gear.data.recipes.ToolActionRecipeBuilder;
import net.silentchaos512.gear.gear.material.MaterialCategories;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.CustomMaterialItem;
import net.silentchaos512.gear.item.GearItemSet;
import net.silentchaos512.gear.item.MainPartItem;
import net.silentchaos512.gear.item.RepairKitItem;
import net.silentchaos512.gear.item.blueprint.PartBlueprintItem;
import net.silentchaos512.gear.item.gear.GearArmorItem;
import net.silentchaos512.gear.item.gear.GearMaceItem;
import net.silentchaos512.gear.setup.GearItemSets;
import net.silentchaos512.gear.setup.SgBlocks;
import net.silentchaos512.gear.setup.SgItems;
import net.silentchaos512.gear.setup.SgRecipes;
import net.silentchaos512.gear.setup.SgSounds;
import net.silentchaos512.gear.setup.SgTags;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.lib.data.recipe.ExtendedShapedRecipeBuilder;
import net.silentchaos512.lib.data.recipe.ExtendedShapelessRecipeBuilder;
import net.silentchaos512.lib.data.recipe.LibRecipeProvider;
import net.silentchaos512.lib.util.NameUtils;

public class ModRecipesProvider
extends LibRecipeProvider {
    private static final boolean ADD_TEST_RECIPES = true;
    private static final SoundPlayback HAMMER_SOUND = new SoundPlayback((SoundEvent)SgSounds.STONE_ANVIL_HAMMER.get(), 1.0f, 1.0f, 0.1f);
    private static final SoundPlayback KNIFE_SOUND = new SoundPlayback((SoundEvent)SgSounds.STONE_ANVIL_KNIFE.get(), 1.0f, 1.0f, 0.1f);
    private static final Map<Tier, DataResource<Material>> TOOL_MATERIALS = ImmutableMap.builder().put((Object)Tiers.NETHERITE, Const.Materials.DIAMOND).put((Object)Tiers.DIAMOND, Const.Materials.DIAMOND).put((Object)Tiers.GOLD, Const.Materials.GOLD).put((Object)Tiers.IRON, Const.Materials.IRON).put((Object)Tiers.STONE, Const.Materials.STONE).put((Object)Tiers.WOOD, Const.Materials.WOOD).build();
    private static final Map<Holder<ArmorMaterial>, DataResource<Material>> ARMOR_MATERIALS = ImmutableMap.builder().put((Object)ArmorMaterials.NETHERITE, Const.Materials.DIAMOND).put((Object)ArmorMaterials.DIAMOND, Const.Materials.DIAMOND).put((Object)ArmorMaterials.GOLD, Const.Materials.GOLD).put((Object)ArmorMaterials.IRON, Const.Materials.IRON).put((Object)ArmorMaterials.LEATHER, Const.Materials.LEATHER).build();

    public ModRecipesProvider(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), event.getLookupProvider(), "silentgear");
    }

    protected void buildRecipes(RecipeOutput consumer) {
        this.metals(consumer, 0.5f, new Metals("blaze_gold", CraftingItems.BLAZE_GOLD_INGOT, SgTags.Items.INGOTS_BLAZE_GOLD).block((ItemLike)SgBlocks.BLAZE_GOLD_BLOCK, SgTags.Items.STORAGE_BLOCKS_BLAZE_GOLD).dust(CraftingItems.BLAZE_GOLD_DUST, SgTags.Items.DUSTS_BLAZE_GOLD).nugget(CraftingItems.BLAZE_GOLD_NUGGET, SgTags.Items.NUGGETS_BLAZE_GOLD));
        this.metals(consumer, 1.0f, new Metals("crimson_iron", CraftingItems.CRIMSON_IRON_INGOT, SgTags.Items.INGOTS_CRIMSON_IRON).block((ItemLike)SgBlocks.CRIMSON_IRON_BLOCK, SgTags.Items.STORAGE_BLOCKS_CRIMSON_IRON).dust(CraftingItems.CRIMSON_IRON_DUST, SgTags.Items.DUSTS_CRIMSON_IRON).ore((ItemLike)SgBlocks.CRIMSON_IRON_ORE, SgTags.Items.ORES_CRIMSON_IRON, CraftingItems.RAW_CRIMSON_IRON, (ItemLike)SgBlocks.RAW_CRIMSON_IRON_BLOCK).nugget(CraftingItems.CRIMSON_IRON_NUGGET, SgTags.Items.NUGGETS_CRIMSON_IRON));
        this.metals(consumer, 0.5f, new Metals("crimson_steel", CraftingItems.CRIMSON_STEEL_INGOT, SgTags.Items.INGOTS_CRIMSON_STEEL).block((ItemLike)SgBlocks.CRIMSON_STEEL_BLOCK, SgTags.Items.STORAGE_BLOCKS_CRIMSON_STEEL).dust(CraftingItems.CRIMSON_STEEL_DUST, SgTags.Items.DUSTS_CRIMSON_STEEL).nugget(CraftingItems.CRIMSON_STEEL_NUGGET, SgTags.Items.NUGGETS_CRIMSON_STEEL));
        this.metals(consumer, 1.5f, new Metals("azure_silver", CraftingItems.AZURE_SILVER_INGOT, SgTags.Items.INGOTS_AZURE_SILVER).block((ItemLike)SgBlocks.AZURE_SILVER_BLOCK, SgTags.Items.STORAGE_BLOCKS_AZURE_SILVER).dust(CraftingItems.AZURE_SILVER_DUST, SgTags.Items.DUSTS_AZURE_SILVER).ore((ItemLike)SgBlocks.AZURE_SILVER_ORE, SgTags.Items.ORES_AZURE_SILVER, CraftingItems.RAW_AZURE_SILVER, (ItemLike)SgBlocks.RAW_AZURE_SILVER_BLOCK).nugget(CraftingItems.AZURE_SILVER_NUGGET, SgTags.Items.NUGGETS_AZURE_SILVER));
        this.metals(consumer, 0.5f, new Metals("azure_electrum", CraftingItems.AZURE_ELECTRUM_INGOT, SgTags.Items.INGOTS_AZURE_ELECTRUM).block((ItemLike)SgBlocks.AZURE_ELECTRUM_BLOCK, SgTags.Items.STORAGE_BLOCKS_AZURE_ELECTRUM).dust(CraftingItems.AZURE_ELECTRUM_DUST, SgTags.Items.DUSTS_AZURE_ELECTRUM).nugget(CraftingItems.AZURE_ELECTRUM_NUGGET, SgTags.Items.NUGGETS_AZURE_ELECTRUM));
        this.metals(consumer, 0.75f, new Metals("tyrian_steel", CraftingItems.TYRIAN_STEEL_INGOT, SgTags.Items.INGOTS_TYRIAN_STEEL).block((ItemLike)SgBlocks.TYRIAN_STEEL_BLOCK, SgTags.Items.STORAGE_BLOCKS_TYRIAN_STEEL).dust(CraftingItems.TYRIAN_STEEL_DUST, SgTags.Items.DUSTS_TYRIAN_STEEL).nugget(CraftingItems.TYRIAN_STEEL_NUGGET, SgTags.Items.NUGGETS_TYRIAN_STEEL));
        this.metals(consumer, 1.0f, new Metals("bort", CraftingItems.BORT, SgTags.Items.GEMS_BORT).block((ItemLike)SgBlocks.BORT_BLOCK, SgTags.Items.STORAGE_BLOCKS_BORT));
        this.registerSpecialRecipes(consumer);
        this.registerCraftingItems(consumer);
        this.registerCrudeTools(consumer);
        this.registerBlueprints(consumer);
        this.registerCompoundParts(consumer);
        this.registerGear(consumer);
        this.registerModifierKits(consumer);
        this.registerMachines(consumer);
        this.registerCompounding(consumer);
        this.registerPressing(consumer);
        this.registerSmithing(consumer);
        this.registerSalvaging(consumer);
        this.registerTestRecipes(consumer);
    }

    private void registerTestRecipes(RecipeOutput consumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BUCKET).pattern("# #").pattern(" # ").define(Character.valueOf('#'), new Ingredient((ICustomIngredient)PartMaterialIngredient.builder((PartType)PartTypes.MAIN.get()).withMaterial(DataResource.material("copper")).withGrade(MaterialGrade.A, null).build())).unlockedBy("impossible", CriteriaTriggers.IMPOSSIBLE.createCriterion((CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance())).save(consumer, this.modId("graded_mat_test"));
    }

    private void registerSpecialRecipes(RecipeOutput consumer) {
        this.special(consumer, (RecipeSerializer<? extends CraftingRecipe>)((RecipeSerializer)SgRecipes.FILL_REPAIR_KIT.get()), FillRepairKitRecipe::new);
        this.special(consumer, (RecipeSerializer<? extends CraftingRecipe>)((RecipeSerializer)SgRecipes.SWAP_GEAR_PART.get()), GearPartSwapRecipe::new);
        this.special(consumer, (RecipeSerializer<? extends CraftingRecipe>)((RecipeSerializer)SgRecipes.QUICK_REPAIR.get()), QuickRepairRecipe::new);
        this.special(consumer, (RecipeSerializer<? extends CraftingRecipe>)((RecipeSerializer)SgRecipes.MOD_KIT_REMOVE_PART.get()), ModKitRemovePartRecipe::new);
    }

    private void registerBlueprints(RecipeOutput consumer) {
        this.toolBlueprint(consumer, "sword", GearItemSets.SWORD, "#", "#", "/");
        this.toolBlueprint(consumer, "katana", GearItemSets.KATANA, "##", "# ", "/ ");
        this.toolBlueprint(consumer, "machete", GearItemSets.MACHETE, "  #", " ##", "/  ");
        this.toolBlueprint(consumer, "spear", GearItemSets.SPEAR, "#  ", " / ", "  /");
        this.toolBlueprint(consumer, "knife", GearItemSets.KNIFE, " #", "/ ");
        this.toolBlueprint(consumer, "dagger", GearItemSets.DAGGER, "#", "/");
        this.toolBlueprint(consumer, "pickaxe", GearItemSets.PICKAXE, "###", " / ", " / ");
        this.toolBlueprint(consumer, "shovel", GearItemSets.SHOVEL, "#", "/", "/");
        this.toolBlueprint(consumer, "axe", GearItemSets.AXE, "##", "#/", " /");
        this.toolBlueprint(consumer, "paxel", GearItemSets.PAXEL, "###", "#/#", " /#");
        this.toolBlueprint(consumer, "hammer", GearItemSets.HAMMER, "###", "###", " / ");
        this.toolBlueprint(consumer, "excavator", GearItemSets.EXCAVATOR, "# #", "###", " / ");
        this.toolBlueprint(consumer, "saw", GearItemSets.SAW, "###", "##/", "  /");
        this.toolBlueprint(consumer, "hoe", GearItemSets.HOE, "##", " /", " /");
        this.toolBlueprint(consumer, "mattock", GearItemSets.MATTOCK, "## ", "#/#", " / ");
        this.toolBlueprint(consumer, "prospector_hammer", GearItemSets.PROSPECTOR_HAMMER, Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), "##", " /", " @");
        this.toolBlueprint(consumer, "sickle", GearItemSets.SICKLE, " #", "##", "/ ");
        this.toolBlueprint(consumer, "shears", GearItemSets.SHEARS, " #", "#/");
        this.toolBlueprint(consumer, "fishing_rod", GearItemSets.FISHING_ROD, "  /", " /#", "/ #");
        this.toolBlueprint(consumer, "bow", GearItemSets.BOW, " #/", "# /", " #/");
        this.toolBlueprint(consumer, "crossbow", GearItemSets.CROSSBOW, "/#/", "###", " / ");
        this.toolBlueprint(consumer, "slingshot", GearItemSets.SLINGSHOT, "# #", " / ", " / ");
        this.toolBlueprint(consumer, "shield", GearItemSets.SHIELD, Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), "#@#", "///", " # ");
        this.toolBlueprint(consumer, "arrow", GearItemSets.ARROW, Ingredient.of((TagKey)Tags.Items.FEATHERS), "#", "/", "@");
        this.armorBlueprint(consumer, "helmet", GearItemSets.HELMET, "###", "# #");
        this.armorBlueprint(consumer, "chestplate", GearItemSets.CHESTPLATE, "# #", "###", "###");
        this.armorBlueprint(consumer, "leggings", GearItemSets.LEGGINGS, "###", "# #", "# #");
        this.armorBlueprint(consumer, "boots", GearItemSets.BOOTS, "# #", "# #");
        this.shaped(RecipeCategory.MISC, (ItemLike)GearItemSets.TRIDENT.blueprint()).define(Character.valueOf('#'), SgTags.Items.BLUEPRINT_PAPER).define(Character.valueOf('H'), (ItemLike)Items.HEART_OF_THE_SEA).define(Character.valueOf('T'), (ItemLike)Items.TRIDENT).pattern("#H#").pattern("#T#").pattern(" # ").unlockedBy("has_item", ModRecipesProvider.has((ItemLike)Items.TRIDENT)).save(consumer);
        this.shaped(RecipeCategory.MISC, (ItemLike)GearItemSets.MACE.blueprint()).define(Character.valueOf('#'), SgTags.Items.BLUEPRINT_PAPER).define(Character.valueOf('/'), Tags.Items.RODS_BREEZE).pattern(" # ").pattern("###").pattern(" / ").unlockedBy("has_item", ModRecipesProvider.has((TagKey)Tags.Items.RODS_BREEZE)).save(consumer);
        this.shaped(RecipeCategory.MISC, (ItemLike)GearItemSets.MACE.template()).define(Character.valueOf('#'), SgTags.Items.TEMPLATE_BOARDS).define(Character.valueOf('/'), Tags.Items.RODS_BREEZE).pattern(" # ").pattern("###").pattern(" / ").unlockedBy("has_item", ModRecipesProvider.has((TagKey)Tags.Items.RODS_BREEZE)).save(consumer);
        this.shaped(RecipeCategory.MISC, (ItemLike)GearItemSets.ELYTRA.blueprint()).define(Character.valueOf('#'), SgTags.Items.BLUEPRINT_PAPER).define(Character.valueOf('/'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('e'), (ItemLike)Items.ELYTRA).define(Character.valueOf('p'), (ItemLike)Items.PHANTOM_MEMBRANE).pattern("/e/").pattern("p#p").pattern("p p").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.BLUEPRINT_PAPER)).save(consumer);
        this.shaped(RecipeCategory.MISC, (ItemLike)GearItemSets.ELYTRA.template()).define(Character.valueOf('#'), SgTags.Items.TEMPLATE_BOARDS).define(Character.valueOf('/'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('e'), (ItemLike)Items.ELYTRA).define(Character.valueOf('p'), (ItemLike)Items.PHANTOM_MEMBRANE).pattern("/e/").pattern("p#p").pattern("p p").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.TEMPLATE_BOARDS)).save(consumer);
        this.shaped(RecipeCategory.MISC, (ItemLike)GearItemSets.RING.blueprint()).group("silentgear:blueprints/ring").define(Character.valueOf('#'), SgTags.Items.BLUEPRINT_PAPER).define(Character.valueOf('/'), (ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get(), (GearType)GearTypes.CURIO.get(), MaterialCategories.METAL)).pattern(" #/").pattern("# #").pattern("/# ").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.BLUEPRINT_PAPER)).save(consumer);
        this.shaped(RecipeCategory.MISC, (ItemLike)GearItemSets.RING.blueprint()).group("silentgear:blueprints/ring").define(Character.valueOf('#'), SgTags.Items.BLUEPRINT_PAPER).define(Character.valueOf('/'), Tags.Items.INGOTS_GOLD).pattern(" #/").pattern("# #").pattern("/# ").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.BLUEPRINT_PAPER)).save(consumer, SilentGear.getId("ring_blueprint_alt"));
        this.shaped(RecipeCategory.MISC, (ItemLike)GearItemSets.RING.template()).group("silentgear:blueprints/ring").define(Character.valueOf('#'), SgTags.Items.TEMPLATE_BOARDS).define(Character.valueOf('/'), (ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get(), (GearType)GearTypes.CURIO.get(), MaterialCategories.METAL)).pattern(" #/").pattern("# #").pattern("/# ").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.TEMPLATE_BOARDS)).save(consumer);
        this.shaped(RecipeCategory.MISC, (ItemLike)GearItemSets.BRACELET.blueprint()).group("silentgear:blueprints/bracelet").define(Character.valueOf('#'), SgTags.Items.BLUEPRINT_PAPER).define(Character.valueOf('/'), (ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get(), (GearType)GearTypes.CURIO.get(), MaterialCategories.METAL)).pattern("###").pattern("/#/").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.BLUEPRINT_PAPER)).save(consumer);
        this.shaped(RecipeCategory.MISC, (ItemLike)GearItemSets.BRACELET.blueprint()).group("silentgear:blueprints/bracelet").define(Character.valueOf('#'), SgTags.Items.BLUEPRINT_PAPER).define(Character.valueOf('/'), Tags.Items.INGOTS_GOLD).pattern("###").pattern("/#/").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.BLUEPRINT_PAPER)).save(consumer, SilentGear.getId("bracelet_blueprint_alt"));
        this.shaped(RecipeCategory.MISC, (ItemLike)GearItemSets.BRACELET.template()).group("silentgear:blueprints/bracelet").define(Character.valueOf('#'), SgTags.Items.TEMPLATE_BOARDS).define(Character.valueOf('/'), (ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get(), (GearType)GearTypes.CURIO.get(), MaterialCategories.METAL)).pattern("###").pattern("/#/").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.TEMPLATE_BOARDS)).save(consumer);
        this.shaped(RecipeCategory.MISC, (ItemLike)GearItemSets.NECKLACE.blueprint()).group("silentgear:blueprints/necklace").define(Character.valueOf('#'), SgTags.Items.BLUEPRINT_PAPER).define(Character.valueOf('/'), (ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get(), (GearType)GearTypes.CURIO.get(), MaterialCategories.METAL)).pattern("/#/").pattern("# #").pattern("###").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.BLUEPRINT_PAPER)).save(consumer);
        this.shaped(RecipeCategory.MISC, (ItemLike)GearItemSets.NECKLACE.blueprint()).group("silentgear:blueprints/necklace").define(Character.valueOf('#'), SgTags.Items.BLUEPRINT_PAPER).define(Character.valueOf('/'), Tags.Items.INGOTS_GOLD).pattern("/#/").pattern("# #").pattern("###").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.BLUEPRINT_PAPER)).save(consumer, SilentGear.getId("necklace_blueprint_alt"));
        this.shaped(RecipeCategory.MISC, (ItemLike)GearItemSets.NECKLACE.template()).group("silentgear:blueprints/necklace").define(Character.valueOf('#'), SgTags.Items.TEMPLATE_BOARDS).define(Character.valueOf('/'), (ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get(), (GearType)GearTypes.CURIO.get(), MaterialCategories.METAL)).pattern("/#/").pattern("# #").pattern("###").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.TEMPLATE_BOARDS)).save(consumer);
        this.shaped(RecipeCategory.MISC, (ItemLike)SgItems.JEWELER_TOOLS).pattern("  p").pattern("d#s").pattern("ips").define(Character.valueOf('p'), ItemTags.PLANKS).define(Character.valueOf('d'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('#'), SgTags.Items.BLUEPRINT_PAPER).define(Character.valueOf('s'), Tags.Items.RODS_WOODEN).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.BLUEPRINT_PAPER)).save(consumer);
        this.shapeless(RecipeCategory.MISC, (ItemLike)SgItems.BINDING_BLUEPRINT).group("silentgear:blueprints/binding").requires(Ingredient.of(SgTags.Items.BLUEPRINT_PAPER), 1).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.BINDING.get(), (GearType)GearTypes.TOOL.get()), 2).unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.BLUEPRINT_PAPER)).save(consumer);
        this.shapeless(RecipeCategory.MISC, (ItemLike)SgItems.BINDING_BLUEPRINT).group("silentgear:blueprints/binding").requires(SgTags.Items.BLUEPRINT_PAPER).requires(Tags.Items.STRINGS, 2).unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.BLUEPRINT_PAPER)).save(consumer, SilentGear.getId("binding_blueprint_alt"));
        this.shapeless(RecipeCategory.MISC, (ItemLike)SgItems.BINDING_TEMPLATE).group("silentgear:blueprints/binding").requires(Ingredient.of(SgTags.Items.TEMPLATE_BOARDS), 1).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.BINDING.get(), (GearType)GearTypes.TOOL.get()), 2).unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.TEMPLATE_BOARDS)).save(consumer);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)SgItems.CORD_BLUEPRINT).group("silentgear:blueprints/cord").define(Character.valueOf('#'), SgTags.Items.BLUEPRINT_PAPER).define(Character.valueOf('/'), (ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.CORD.get(), (GearType)GearTypes.TOOL.get())).pattern("#/").pattern("#/").pattern("#/").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.BLUEPRINT_PAPER)).save(consumer);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)SgItems.CORD_BLUEPRINT).group("silentgear:blueprints/cord").define(Character.valueOf('#'), SgTags.Items.BLUEPRINT_PAPER).define(Character.valueOf('/'), Tags.Items.STRINGS).pattern("#/").pattern("#/").pattern("#/").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.BLUEPRINT_PAPER)).save(consumer, SilentGear.getId("cord_blueprint_alt"));
        this.shaped(RecipeCategory.TOOLS, (ItemLike)SgItems.CORD_TEMPLATE).group("silentgear:blueprints/cord").define(Character.valueOf('#'), SgTags.Items.TEMPLATE_BOARDS).define(Character.valueOf('/'), (ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.CORD.get(), (GearType)GearTypes.TOOL.get())).pattern("#/").pattern("#/").pattern("#/").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.TEMPLATE_BOARDS)).save(consumer);
        this.shapeless(RecipeCategory.TOOLS, (ItemLike)SgItems.FLETCHING_BLUEPRINT).group("silentgear:blueprints/fletching").requires(Ingredient.of(SgTags.Items.BLUEPRINT_PAPER), 2).requires(Tags.Items.FEATHERS).unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.BLUEPRINT_PAPER)).save(consumer);
        this.shapeless(RecipeCategory.TOOLS, (ItemLike)SgItems.FLETCHING_TEMPLATE).group("silentgear:blueprints/fletching").requires(Ingredient.of(SgTags.Items.TEMPLATE_BOARDS), 2).requires(Tags.Items.FEATHERS).unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.TEMPLATE_BOARDS)).save(consumer);
        this.shapeless(RecipeCategory.TOOLS, (ItemLike)SgItems.GRIP_BLUEPRINT).group("silentgear:blueprints/grip").requires(Ingredient.of(SgTags.Items.BLUEPRINT_PAPER), 2).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.GRIP.get(), (GearType)GearTypes.TOOL.get())).unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.BLUEPRINT_PAPER)).save(consumer);
        this.shapeless(RecipeCategory.TOOLS, (ItemLike)SgItems.GRIP_BLUEPRINT).group("silentgear:blueprints/grip").requires(Ingredient.of(SgTags.Items.BLUEPRINT_PAPER), 2).requires(ItemTags.WOOL).unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.BLUEPRINT_PAPER)).save(consumer, SilentGear.getId("grip_blueprint_alt"));
        this.shapeless(RecipeCategory.TOOLS, (ItemLike)SgItems.GRIP_TEMPLATE).group("silentgear:blueprints/grip").requires(Ingredient.of(SgTags.Items.TEMPLATE_BOARDS), 2).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.GRIP.get(), (GearType)GearTypes.TOOL.get())).unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.TEMPLATE_BOARDS)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, SgItems.LINING_BLUEPRINT).group("silentgear:blueprints/lining").requires(Ingredient.of(SgTags.Items.BLUEPRINT_PAPER), 3).requires(Ingredient.of((TagKey)ItemTags.WOOL), 2).requires(Ingredient.of((TagKey)Tags.Items.STRINGS), 2).unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.BLUEPRINT_PAPER)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, SgItems.LINING_TEMPLATE).group("silentgear:blueprints/lining").requires(Ingredient.of(SgTags.Items.TEMPLATE_BOARDS), 3).requires(Ingredient.of((TagKey)ItemTags.WOOL), 2).requires(Ingredient.of((TagKey)Tags.Items.STRINGS), 2).unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.TEMPLATE_BOARDS)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, SgItems.ROD_BLUEPRINT).group("silentgear:blueprints/rod").define(Character.valueOf('#'), SgTags.Items.BLUEPRINT_PAPER).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).pattern("#/").pattern("#/").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.BLUEPRINT_PAPER)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, SgItems.ROD_TEMPLATE).group("silentgear:blueprints/rod").define(Character.valueOf('#'), SgTags.Items.TEMPLATE_BOARDS).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).pattern("#/").pattern("#/").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.TEMPLATE_BOARDS)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, SgItems.TIP_BLUEPRINT).group("silentgear:blueprints/tip").requires(Ingredient.of(SgTags.Items.BLUEPRINT_PAPER), 2).requires(SgTags.Items.PAPER).requires(Tags.Items.STONES).unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.BLUEPRINT_PAPER)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, SgItems.TIP_TEMPLATE).group("silentgear:blueprints/tip").requires(Ingredient.of(SgTags.Items.TEMPLATE_BOARDS), 2).requires(SgTags.Items.PAPER).requires(Tags.Items.STONES).unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.TEMPLATE_BOARDS)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, SgItems.COATING_BLUEPRINT).group("silentgear:blueprints/coating").requires(Ingredient.of(SgTags.Items.BLUEPRINT_PAPER), 4).requires(Tags.Items.GEMS_DIAMOND).requires(Tags.Items.GEMS_EMERALD).unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.BLUEPRINT_PAPER)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, SgItems.COATING_TEMPLATE).group("silentgear:blueprints/coating").requires(Ingredient.of(SgTags.Items.TEMPLATE_BOARDS), 4).requires(Tags.Items.GEMS_DIAMOND).requires(Tags.Items.GEMS_EMERALD).unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.TEMPLATE_BOARDS)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, SgItems.BLUEPRINT_BOOK).requires((ItemLike)Items.BOOK).requires(ItemTags.WOOL).requires(Tags.Items.INGOTS_GOLD).requires(Ingredient.of(SgTags.Items.TEMPLATE_BOARDS), 3).unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.TEMPLATE_BOARDS)).save(consumer);
    }

    private ExtendedShapelessRecipeBuilder.Basic<ShapelessCompoundPartRecipe> compoundPart(DeferredItem<?> item, int count) {
        return this.compoundPart(RecipeCategory.MISC, item, count);
    }

    private ExtendedShapelessRecipeBuilder.Basic<ShapelessCompoundPartRecipe> compoundPart(RecipeCategory category, MainPartItem mainPartItem, int count) {
        ItemStack resultStack = new ItemStack((ItemLike)mainPartItem, count);
        return new ExtendedShapelessRecipeBuilder.Basic(category, resultStack, ShapelessCompoundPartRecipe::new);
    }

    private ExtendedShapelessRecipeBuilder.Basic<ShapelessCompoundPartRecipe> compoundPart(RecipeCategory category, DeferredItem<?> item, int count) {
        return new ExtendedShapelessRecipeBuilder.Basic(category, item.toStack(count), ShapelessCompoundPartRecipe::new);
    }

    private void registerCompoundParts(RecipeOutput consumer) {
        this.compoundPart(SgItems.SETTING, 1).requires((ICustomIngredient)BlueprintIngredient.of((PartBlueprintItem)SgItems.JEWELER_TOOLS.get())).requires((ItemLike)CraftingItems.BORT).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.SETTING.get())).save(consumer, SilentGear.getId("part/adornment"));
        this.compoundPart(SgItems.ROD, 4).requires((ICustomIngredient)BlueprintIngredient.of((PartBlueprintItem)SgItems.ROD_BLUEPRINT.get())).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.ROD.get()), 2).save(consumer, SilentGear.getId("part/rod"));
        this.compoundPart(SgItems.BINDING, 1).requires((ICustomIngredient)BlueprintIngredient.of((PartBlueprintItem)SgItems.BINDING_BLUEPRINT.get())).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.BINDING.get())).save(consumer, SilentGear.getId("part/binding"));
        this.compoundPart(SgItems.CORD, 1).requires((ICustomIngredient)BlueprintIngredient.of((PartBlueprintItem)SgItems.CORD_BLUEPRINT.get())).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.CORD.get()), 3).save(consumer, SilentGear.getId("part/cord"));
        this.compoundPart(SgItems.FLETCHING, 1).requires((ICustomIngredient)BlueprintIngredient.of((PartBlueprintItem)SgItems.FLETCHING_BLUEPRINT.get())).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.FLETCHING.get()), 1).save(consumer, SilentGear.getId("part/fletching"));
        this.compoundPart(SgItems.GRIP, 1).requires((ICustomIngredient)BlueprintIngredient.of((PartBlueprintItem)SgItems.GRIP_BLUEPRINT.get())).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.GRIP.get())).save(consumer, SilentGear.getId("part/grip"));
        this.compoundPart(SgItems.LINING, 1).requires((ICustomIngredient)BlueprintIngredient.of((PartBlueprintItem)SgItems.LINING_BLUEPRINT.get())).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.LINING.get())).save(consumer, SilentGear.getId("part/lining"));
        this.compoundPart(SgItems.TIP, 1).requires((ICustomIngredient)BlueprintIngredient.of((PartBlueprintItem)SgItems.TIP_BLUEPRINT.get())).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.TIP.get())).save(consumer, SilentGear.getId("part/tip"));
        this.compoundPart(SgItems.COATING, 1).requires((ICustomIngredient)BlueprintIngredient.of((PartBlueprintItem)SgItems.COATING_BLUEPRINT.get())).requires((ItemLike)Items.GLASS_BOTTLE).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.COATING.get())).save(consumer, SilentGear.getId("part/coating"));
    }

    private ExtendedShapelessRecipeBuilder.Basic<ShapelessGearRecipe> shapelessGear(RecipeCategory category, DeferredItem<?> item) {
        return new ExtendedShapelessRecipeBuilder.Basic(category, item.toStack(), ShapelessGearRecipe::new);
    }

    private ExtendedShapelessRecipeBuilder.Basic<ShapelessGearRecipe> shapelessGear(RecipeCategory category, ItemLike item) {
        return new ExtendedShapelessRecipeBuilder.Basic(category, new ItemStack(item), ShapelessGearRecipe::new);
    }

    private ExtendedShapedRecipeBuilder.Basic<ShapedGearRecipe> shapedGear(RecipeCategory category, DeferredItem<?> item) {
        return new ExtendedShapedRecipeBuilder.Basic(category, item.toStack(), ShapedGearRecipe::new);
    }

    private ExtendedShapedRecipeBuilder.Basic<ShapedGearRecipe> shapedGear(RecipeCategory category, ItemLike item) {
        return new ExtendedShapedRecipeBuilder.Basic(category, new ItemStack(item), ShapedGearRecipe::new);
    }

    private ExtendedShapelessRecipeBuilder.Basic<ShapelessCompoundPartRecipe> shapelessPart(RecipeCategory category, ItemLike item) {
        return new ExtendedShapelessRecipeBuilder.Basic(category, new ItemStack(item), ShapelessCompoundPartRecipe::new);
    }

    private void registerGear(RecipeOutput consumer) {
        this.toolRecipes(consumer, "sword", 2, GearItemSets.SWORD);
        this.toolRecipes(consumer, "katana", 3, GearItemSets.KATANA);
        this.toolRecipes(consumer, "machete", 3, GearItemSets.MACHETE);
        this.toolRecipes(consumer, "spear", 1, GearItemSets.SPEAR);
        this.toolRecipes(consumer, "trident", 3, GearItemSets.TRIDENT);
        this.maceRecipes(consumer);
        this.toolRecipes(consumer, "knife", 1, GearItemSets.KNIFE);
        this.toolRecipes(consumer, "dagger", 1, GearItemSets.DAGGER);
        this.toolRecipes(consumer, "pickaxe", 3, GearItemSets.PICKAXE);
        this.toolRecipes(consumer, "shovel", 1, GearItemSets.SHOVEL);
        this.toolRecipes(consumer, "axe", 3, GearItemSets.AXE);
        this.toolRecipes(consumer, "paxel", 5, GearItemSets.PAXEL);
        this.toolRecipes(consumer, "hammer", 6, GearItemSets.HAMMER);
        this.toolRecipes(consumer, "excavator", 5, GearItemSets.EXCAVATOR);
        this.toolRecipes(consumer, "hoe", 2, GearItemSets.HOE);
        this.toolRecipes(consumer, "mattock", 4, GearItemSets.MATTOCK);
        this.toolRecipes(consumer, "prospector_hammer", 2, GearItemSets.PROSPECTOR_HAMMER);
        this.toolRecipes(consumer, "saw", 5, GearItemSets.SAW);
        this.toolRecipes(consumer, "sickle", 3, GearItemSets.SICKLE);
        this.toolRecipes(consumer, "shears", 2, GearItemSets.SHEARS);
        this.bowRecipes(consumer, "fishing_rod", 2, GearItemSets.FISHING_ROD);
        this.bowRecipes(consumer, "bow", 3, GearItemSets.BOW);
        this.bowRecipes(consumer, "crossbow", 3, GearItemSets.CROSSBOW);
        this.bowRecipes(consumer, "slingshot", 2, GearItemSets.SLINGSHOT);
        this.arrowRecipes(consumer, "arrow", GearItemSets.ARROW);
        this.curioRecipes(consumer, "ring", 2, GearItemSets.RING);
        this.curioRecipes(consumer, "bracelet", 3, GearItemSets.BRACELET);
        this.curioRecipes(consumer, "necklace", 3, GearItemSets.NECKLACE);
        this.shapelessPart(RecipeCategory.COMBAT, (ItemLike)GearItemSets.SHIELD.mainPart()).requires((ICustomIngredient)BlueprintIngredient.of(GearItemSets.SHIELD)).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get(), (GearType)GearTypes.SHIELD.get()), 2).save(consumer, SilentGear.getId("gear/shield_plate"));
        this.shapelessGear(RecipeCategory.COMBAT, GearItemSets.SHIELD.gearItem()).requires((ItemLike)GearItemSets.SHIELD.mainPart()).requires((ICustomIngredient)GearPartIngredient.of((PartType)PartTypes.ROD.get())).save(consumer, SilentGear.getId("gear/shield"));
        this.shapelessGear(RecipeCategory.COMBAT, GearItemSets.SHIELD.gearItem()).requires((ICustomIngredient)BlueprintIngredient.of(GearItemSets.SHIELD)).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get(), (GearType)GearTypes.SHIELD.get()), 2).requires((ICustomIngredient)GearPartIngredient.of((PartType)PartTypes.ROD.get())).save(consumer, SilentGear.getId("gear/shield_quick"));
        this.armorRecipes(consumer, 5, GearItemSets.HELMET);
        this.armorRecipes(consumer, 8, GearItemSets.CHESTPLATE);
        this.armorRecipes(consumer, 7, GearItemSets.LEGGINGS);
        this.armorRecipes(consumer, 4, GearItemSets.BOOTS);
        this.compoundPart(RecipeCategory.COMBAT, GearItemSets.ELYTRA.mainPart(), 1).requires((ICustomIngredient)BlueprintIngredient.of(GearItemSets.ELYTRA)).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get(), (GearType)GearTypes.ELYTRA.get(), MaterialCategories.CLOTH, MaterialCategories.SHEET), 6).save(consumer, SilentGear.getId("gear/elytra_wings"));
        this.shapelessGear(RecipeCategory.COMBAT, GearItemSets.ELYTRA.gearItem()).requires((ItemLike)GearItemSets.ELYTRA.mainPart()).requires((ICustomIngredient)GearPartIngredient.of((PartType)PartTypes.BINDING.get())).save(consumer, SilentGear.getId("gear/elytra"));
        this.toolConversion(consumer, GearItemSets.SWORD, 2, Items.NETHERITE_SWORD, Items.DIAMOND_SWORD, Items.GOLDEN_SWORD, Items.IRON_SWORD, Items.STONE_SWORD, Items.WOODEN_SWORD);
        this.toolConversion(consumer, GearItemSets.PICKAXE, 3, Items.NETHERITE_PICKAXE, Items.DIAMOND_PICKAXE, Items.GOLDEN_PICKAXE, Items.IRON_PICKAXE, Items.STONE_PICKAXE, Items.WOODEN_PICKAXE);
        this.toolConversion(consumer, GearItemSets.SHOVEL, 1, Items.NETHERITE_SHOVEL, Items.DIAMOND_SHOVEL, Items.GOLDEN_SHOVEL, Items.IRON_SHOVEL, Items.STONE_SHOVEL, Items.WOODEN_SHOVEL);
        this.toolConversion(consumer, GearItemSets.AXE, 3, Items.NETHERITE_AXE, Items.DIAMOND_AXE, Items.GOLDEN_AXE, Items.IRON_AXE, Items.STONE_AXE, Items.WOODEN_AXE);
        this.toolConversion(consumer, GearItemSets.HOE, 2, Items.NETHERITE_HOE, Items.DIAMOND_HOE, Items.GOLDEN_HOE, Items.IRON_HOE, Items.STONE_HOE, Items.WOODEN_HOE);
        this.armorConversion(consumer, GearItemSets.HELMET, 5, Items.NETHERITE_HELMET, Items.DIAMOND_HELMET, Items.GOLDEN_HELMET, Items.IRON_HELMET, Items.LEATHER_HELMET);
        this.armorConversion(consumer, GearItemSets.CHESTPLATE, 8, Items.NETHERITE_CHESTPLATE, Items.DIAMOND_CHESTPLATE, Items.GOLDEN_CHESTPLATE, Items.IRON_CHESTPLATE, Items.LEATHER_CHESTPLATE);
        this.armorConversion(consumer, GearItemSets.LEGGINGS, 7, Items.NETHERITE_LEGGINGS, Items.DIAMOND_LEGGINGS, Items.GOLDEN_LEGGINGS, Items.IRON_LEGGINGS, Items.LEATHER_LEGGINGS);
        this.armorConversion(consumer, GearItemSets.BOOTS, 4, Items.NETHERITE_BOOTS, Items.DIAMOND_BOOTS, Items.GOLDEN_BOOTS, Items.IRON_BOOTS, Items.LEATHER_BOOTS);
    }

    private void registerModifierKits(RecipeOutput consumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SgItems.MOD_KIT).define(Character.valueOf('#'), SgTags.Items.TEMPLATE_BOARDS).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).define(Character.valueOf('o'), Tags.Items.INGOTS_IRON).pattern("##o").pattern("##/").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.TEMPLATE_BOARDS)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SgItems.VERY_CRUDE_REPAIR_KIT).define(Character.valueOf('#'), SgTags.Items.TEMPLATE_BOARDS).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).define(Character.valueOf('o'), Tags.Items.STONES).pattern(" / ").pattern("#o#").pattern("###").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.TEMPLATE_BOARDS)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SgItems.CRUDE_REPAIR_KIT).define(Character.valueOf('#'), SgTags.Items.TEMPLATE_BOARDS).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).define(Character.valueOf('o'), Tags.Items.INGOTS_IRON).pattern(" / ").pattern("#o#").pattern("###").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.TEMPLATE_BOARDS)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SgItems.STURDY_REPAIR_KIT).define(Character.valueOf('#'), Tags.Items.INGOTS_IRON).define(Character.valueOf('/'), SgTags.Items.RODS_IRON).define(Character.valueOf('o'), Tags.Items.GEMS_DIAMOND).pattern(" / ").pattern("#o#").pattern("###").unlockedBy("has_item", ModRecipesProvider.has((TagKey)Tags.Items.INGOTS_IRON)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SgItems.CRIMSON_REPAIR_KIT).define(Character.valueOf('#'), SgTags.Items.INGOTS_CRIMSON_STEEL).define(Character.valueOf('/'), Tags.Items.RODS_BLAZE).define(Character.valueOf('o'), SgTags.Items.INGOTS_BLAZE_GOLD).pattern(" / ").pattern("#o#").pattern("###").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.INGOTS_CRIMSON_STEEL)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SgItems.AZURE_REPAIR_KIT).define(Character.valueOf('#'), SgTags.Items.INGOTS_AZURE_ELECTRUM).define(Character.valueOf('/'), (ItemLike)Items.END_ROD).define(Character.valueOf('o'), Tags.Items.GEMS_EMERALD).pattern(" / ").pattern("#o#").pattern("###").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.INGOTS_AZURE_ELECTRUM)).save(consumer);
        for (RepairKitItem item : SgItems.getItems(RepairKitItem.class)) {
            this.shapeless(RecipeCategory.MISC, (ItemLike)item).requires((ItemLike)item).requires(Tags.Items.RODS_WOODEN).save(consumer, SilentGear.getId(NameUtils.fromItem((ItemLike)item).getPath() + "_empty"));
        }
    }

    private void registerMachines(RecipeOutput consumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, SgBlocks.STONE_ANVIL).define(Character.valueOf('#'), Tags.Items.COBBLESTONES).define(Character.valueOf('/'), ItemTags.DIRT).pattern(" # ").pattern("#/#").unlockedBy("has_item", ModRecipesProvider.has((TagKey)Tags.Items.COBBLESTONES)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, SgBlocks.ALLOY_FORGE).define(Character.valueOf('/'), SgTags.Items.INGOTS_CRIMSON_STEEL).define(Character.valueOf('i'), Tags.Items.STORAGE_BLOCKS_IRON).define(Character.valueOf('#'), (ItemLike)Blocks.BLACKSTONE).pattern("/#/").pattern("/ /").pattern("#i#").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.INGOTS_CRIMSON_STEEL)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, SgBlocks.RECRYSTALLIZER).define(Character.valueOf('/'), SgTags.Items.INGOTS_AZURE_ELECTRUM).define(Character.valueOf('g'), Tags.Items.STORAGE_BLOCKS_GOLD).define(Character.valueOf('d'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('e'), Tags.Items.GEMS_EMERALD).define(Character.valueOf('#'), (ItemLike)Blocks.PURPUR_BLOCK).pattern("/e/").pattern("/d/").pattern("#g#").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.INGOTS_AZURE_ELECTRUM)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, SgBlocks.REFABRICATOR).define(Character.valueOf('/'), Tags.Items.INGOTS_IRON).define(Character.valueOf('i'), Tags.Items.STORAGE_BLOCKS_IRON).define(Character.valueOf('d'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('b'), SgTags.Items.GEMS_BORT).define(Character.valueOf('#'), ItemTags.PLANKS).pattern("/ /").pattern("dbd").pattern("#i#").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.GEMS_BORT)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, SgBlocks.METAL_PRESS).define(Character.valueOf('#'), Tags.Items.OBSIDIANS).define(Character.valueOf('t'), SgTags.Items.INGOTS_TYRIAN_STEEL).define(Character.valueOf('/'), SgTags.Items.RODS_IRON).pattern("#t#").pattern("/ /").pattern("#t#").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.INGOTS_TYRIAN_STEEL)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, SgBlocks.CRUDE_MIXER).define(Character.valueOf('#'), Tags.Items.STONES).define(Character.valueOf('/'), ItemTags.PLANKS).define(Character.valueOf('F'), (ItemLike)CraftingItems.FLAX_STRING).pattern("#F#").pattern("#/#").pattern(" # ").unlockedBy("has_item", ModRecipesProvider.has((TagKey)Tags.Items.STONES)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, SgBlocks.SUPER_MIXER).define(Character.valueOf('#'), SgTags.Items.STORAGE_BLOCKS_TYRIAN_STEEL).define(Character.valueOf('B'), (ItemLike)Items.BEACON).define(Character.valueOf('D'), new Ingredient((ICustomIngredient)CustomAlloyIngredient.of((CustomMaterialItem)SgItems.CUSTOM_GEM.get(), Const.Materials.DIMERALD))).pattern("#D#").pattern("#B#").pattern(" # ").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.INGOTS_TYRIAN_STEEL)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, SgBlocks.STARLIGHT_CHARGER).define(Character.valueOf('#'), (ItemLike)Blocks.POLISHED_BLACKSTONE).define(Character.valueOf('/'), SgTags.Items.STORAGE_BLOCKS_BLAZE_GOLD).define(Character.valueOf('q'), (ItemLike)Blocks.QUARTZ_BLOCK).define(Character.valueOf('g'), Tags.Items.GLASS_BLOCKS_COLORLESS).pattern("qgq").pattern("#g#").pattern("#/#").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.INGOTS_BLAZE_GOLD)).save(consumer);
    }

    private void registerCompounding(RecipeOutput consumer) {
        CompoundingRecipeBuilder.gemBuilder(SgItems.CUSTOM_GEM, 1).withCustomMaterial(Const.Materials.DIMERALD).addIngredient((TagKey<Item>)Tags.Items.GEMS_DIAMOND).addIngredient((TagKey<Item>)Tags.Items.GEMS_EMERALD).save(consumer);
        CompoundingRecipeBuilder.metalBuilder(SgItems.CUSTOM_INGOT, 1).withCustomMaterial(DataResource.material("high_carbon_steel")).addIngredient((TagKey<Item>)Tags.Items.INGOTS_IRON).addIngredient((TagKey<Item>)ItemTags.COALS, 3).save(consumer);
        CompoundingRecipeBuilder.metalBuilder(CraftingItems.TYRIAN_STEEL_INGOT, 4).addIngredient(SgTags.Items.INGOTS_CRIMSON_STEEL).addIngredient(SgTags.Items.INGOTS_AZURE_ELECTRUM).addIngredient(CraftingItems.CRUSHED_SHULKER_SHELL).addIngredient((ItemLike)Items.NETHERITE_SCRAP).save(consumer);
        CompoundingRecipeBuilder.metalBuilder(CraftingItems.BLAZE_GOLD_INGOT, 1).addIngredient((TagKey<Item>)Tags.Items.INGOTS_GOLD).addIngredient((ItemLike)Items.BLAZE_POWDER, 2).save(consumer);
        CompoundingRecipeBuilder.metalBuilder(CraftingItems.CRIMSON_STEEL_INGOT, 3).addIngredient(SgTags.Items.STORAGE_BLOCKS_CRIMSON_IRON).addIngredient((TagKey<Item>)Tags.Items.RODS_BLAZE, 2).addIngredient((ItemLike)Items.MAGMA_CREAM).save(consumer);
        CompoundingRecipeBuilder.metalBuilder(CraftingItems.AZURE_ELECTRUM_INGOT, 3).addIngredient(SgTags.Items.STORAGE_BLOCKS_AZURE_SILVER).addIngredient((TagKey<Item>)Tags.Items.INGOTS_GOLD, 2).addIngredient((TagKey<Item>)Tags.Items.ENDER_PEARLS).save(consumer);
    }

    private void registerPressing(RecipeOutput consumer) {
        new SingleItemRecipeBuilder(RecipeCategory.MISC, MaterialPressingRecipe::new, new Ingredient((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get(), MaterialCategories.METAL)), SgItems.SHEET_METAL, 2).unlockedBy("impossible", CriteriaTriggers.IMPOSSIBLE.createCriterion((CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance())).save(consumer);
    }

    private void registerCraftingItems(RecipeOutput consumer) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, SgItems.GUIDE_BOOK).requires((ItemLike)Items.BOOK).requires(SgTags.Items.TEMPLATE_BOARDS).unlockedBy("has_template_board", ModRecipesProvider.has(SgTags.Items.TEMPLATE_BOARDS)).save(consumer);
        this.shapeless(RecipeCategory.MISC, CraftingItems.CRUDE_TOOL_PARTS, 4).requires(Tags.Items.COBBLESTONES).requires(ItemTags.DIRT).requires(Tags.Items.RODS_WOODEN).unlockedBy("has_item", ModRecipesProvider.has((TagKey)Tags.Items.RODS_WOODEN)).save(consumer);
        this.shapeless(RecipeCategory.MISC, CraftingItems.GLOWING_DUST, 4).requires((ItemLike)Items.STICK).requires(Tags.Items.DUSTS_GLOWSTONE, 2).requires(Tags.Items.GEMS_QUARTZ).unlockedBy("has_item", ModRecipesProvider.has((TagKey)Tags.Items.DUSTS_GLOWSTONE)).save(consumer);
        this.toolAction(consumer, SgTags.Items.TOOLS_HAMMER, (TagKey<Item>)Tags.Items.COBBLESTONES, 1, (ItemLike)SgItems.PEBBLE, 9, HAMMER_SOUND).save(consumer);
        this.toolAction(consumer, SgTags.Items.TOOLS_KNIFE, (TagKey<Item>)ItemTags.LOGS, 1, (ItemLike)CraftingItems.TEMPLATE_BOARD, 6, KNIFE_SOUND).save(consumer);
        this.toolAction(consumer, SgTags.Items.TOOLS_HAMMER, (ItemLike)Items.SHULKER_SHELL, 10, (ItemLike)CraftingItems.CRUSHED_SHULKER_SHELL, 1, HAMMER_SOUND).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.AZURE_ELECTRUM_INGOT).define(Character.valueOf('/'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('#'), SgTags.Items.INGOTS_AZURE_SILVER).define(Character.valueOf('o'), Tags.Items.ENDER_PEARLS).pattern("/ /").pattern("#o#").pattern("# #").unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.AZURE_SILVER_INGOT)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BLUE_DYE).requires((ItemLike)CraftingItems.FLAX_FLOWERS, 4).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.FLAX_FLOWERS)).save(consumer, SilentGear.getId("blue_dye_from_flax_flowers"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.MAGNETIC_UPGRADE).pattern("i i").pattern("c c").pattern("#c/").define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('c'), SgTags.Items.INGOTS_CRIMSON_STEEL).define(Character.valueOf('#'), (ItemLike)CraftingItems.ADVANCED_UPGRADE_BASE).define(Character.valueOf('/'), Tags.Items.RODS_BREEZE).unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.INGOTS_CRIMSON_STEEL)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.ROAD_MAKER_UPGRADE).requires((ItemLike)CraftingItems.ADVANCED_UPGRADE_BASE).requires((ItemLike)Items.IRON_SHOVEL).requires(Tags.Items.DYES_ORANGE).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.UPGRADE_BASE)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.SPOON_UPGRADE).requires((ItemLike)CraftingItems.ADVANCED_UPGRADE_BASE).requires((ItemLike)Items.DIAMOND_SHOVEL).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.UPGRADE_BASE)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.WIDE_PLATE_UPGRADE).requires((ItemLike)CraftingItems.ADVANCED_UPGRADE_BASE).requires(SgTags.Items.STORAGE_BLOCKS_CRIMSON_IRON).requires(SgTags.Items.INGOTS_CRIMSON_STEEL).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.UPGRADE_BASE)).save(consumer);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(SgTags.Items.NETHERWOOD_LOGS), (RecipeCategory)RecipeCategory.MISC, SgItems.NETHERWOOD_CHARCOAL, (float)0.15f, (int)200).unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.NETHERWOOD_LOGS)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SgBlocks.NETHERWOOD_CHARCOAL_BLOCK).define(Character.valueOf('#'), SgItems.NETHERWOOD_CHARCOAL).pattern("###").pattern("###").pattern("###").unlockedBy("has_item", ModRecipesProvider.has(SgItems.NETHERWOOD_CHARCOAL)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, SgItems.NETHERWOOD_CHARCOAL, (int)9).requires(SgBlocks.NETHERWOOD_CHARCOAL_BLOCK).unlockedBy("has_item", ModRecipesProvider.has(SgBlocks.NETHERWOOD_CHARCOAL_BLOCK)).save(consumer, SilentGear.getId("netherwood_charcoal_from_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.FLUFFY_FABRIC).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)CraftingItems.FLUFFY_PUFF).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.FLUFFY_PUFF)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.FLUFFY_PUFF, (int)4).requires((ItemLike)CraftingItems.FLUFFY_FABRIC).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.FLUFFY_PUFF)).save(consumer, SilentGear.getId("fluffy_puff_from_fabric"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, SgBlocks.WHITE_FLUFFY_BLOCK).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)CraftingItems.FLUFFY_FABRIC).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.FLUFFY_PUFF)).save(consumer, SilentGear.getId("fluffy_block_base"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.FLUFFY_FABRIC, (int)4).requires(SgTags.Items.FLUFFY_BLOCKS).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.FLUFFY_PUFF)).save(consumer, SilentGear.getId("fluffy_fabric_from_block"));
        this.dyeFluffyBlock(consumer, (ItemLike)SgBlocks.WHITE_FLUFFY_BLOCK, (TagKey<Item>)Tags.Items.DYES_WHITE);
        this.dyeFluffyBlock(consumer, (ItemLike)SgBlocks.ORANGE_FLUFFY_BLOCK, (TagKey<Item>)Tags.Items.DYES_ORANGE);
        this.dyeFluffyBlock(consumer, (ItemLike)SgBlocks.MAGENTA_FLUFFY_BLOCK, (TagKey<Item>)Tags.Items.DYES_MAGENTA);
        this.dyeFluffyBlock(consumer, (ItemLike)SgBlocks.LIGHT_BLUE_FLUFFY_BLOCK, (TagKey<Item>)Tags.Items.DYES_LIGHT_BLUE);
        this.dyeFluffyBlock(consumer, (ItemLike)SgBlocks.YELLOW_FLUFFY_BLOCK, (TagKey<Item>)Tags.Items.DYES_YELLOW);
        this.dyeFluffyBlock(consumer, (ItemLike)SgBlocks.LIME_FLUFFY_BLOCK, (TagKey<Item>)Tags.Items.DYES_LIME);
        this.dyeFluffyBlock(consumer, (ItemLike)SgBlocks.PINK_FLUFFY_BLOCK, (TagKey<Item>)Tags.Items.DYES_PINK);
        this.dyeFluffyBlock(consumer, (ItemLike)SgBlocks.GRAY_FLUFFY_BLOCK, (TagKey<Item>)Tags.Items.DYES_GRAY);
        this.dyeFluffyBlock(consumer, (ItemLike)SgBlocks.LIGHT_GRAY_FLUFFY_BLOCK, (TagKey<Item>)Tags.Items.DYES_LIGHT_GRAY);
        this.dyeFluffyBlock(consumer, (ItemLike)SgBlocks.CYAN_FLUFFY_BLOCK, (TagKey<Item>)Tags.Items.DYES_CYAN);
        this.dyeFluffyBlock(consumer, (ItemLike)SgBlocks.PURPLE_FLUFFY_BLOCK, (TagKey<Item>)Tags.Items.DYES_PURPLE);
        this.dyeFluffyBlock(consumer, (ItemLike)SgBlocks.BLUE_FLUFFY_BLOCK, (TagKey<Item>)Tags.Items.DYES_BLUE);
        this.dyeFluffyBlock(consumer, (ItemLike)SgBlocks.BROWN_FLUFFY_BLOCK, (TagKey<Item>)Tags.Items.DYES_BROWN);
        this.dyeFluffyBlock(consumer, (ItemLike)SgBlocks.GREEN_FLUFFY_BLOCK, (TagKey<Item>)Tags.Items.DYES_GREEN);
        this.dyeFluffyBlock(consumer, (ItemLike)SgBlocks.RED_FLUFFY_BLOCK, (TagKey<Item>)Tags.Items.DYES_RED);
        this.dyeFluffyBlock(consumer, (ItemLike)SgBlocks.BLACK_FLUFFY_BLOCK, (TagKey<Item>)Tags.Items.DYES_BLACK);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, SgItems.FLUFFY_SEEDS).requires((ItemLike)CraftingItems.FLUFFY_PUFF).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.FLUFFY_PUFF)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.FLUFFY_FEATHER).pattern(" ##").pattern("## ").pattern("#  ").define(Character.valueOf('#'), (ItemLike)CraftingItems.FLUFFY_PUFF).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.FLUFFY_PUFF)).save(consumer);
        this.shapeless(RecipeCategory.MISC, (ItemLike)Items.FEATHER).requires((ItemLike)CraftingItems.FLUFFY_FEATHER).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.FLUFFY_STRING).pattern("###").define(Character.valueOf('#'), (ItemLike)CraftingItems.FLUFFY_PUFF).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.FLUFFY_PUFF)).save(consumer);
        this.shapeless(RecipeCategory.MISC, (ItemLike)Items.STRING).requires((ItemLike)CraftingItems.FLUFFY_STRING).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.WHITE_WOOL).pattern("###").pattern("#~#").pattern("###").define(Character.valueOf('#'), (ItemLike)CraftingItems.FLUFFY_PUFF).define(Character.valueOf('~'), Tags.Items.STRINGS).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.FLUFFY_PUFF)).save(consumer, SilentGear.getId("fluffy_wool"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.FINE_SILK_CLOTH).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)CraftingItems.FINE_SILK).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.FINE_SILK)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.FINE_SILK, (int)4).requires((ItemLike)CraftingItems.FINE_SILK_CLOTH).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.FINE_SILK)).save(consumer);
        this.shapeless(RecipeCategory.MISC, CraftingItems.NETHER_STAR_FRAGMENT, 9).requires((ItemLike)Items.NETHER_STAR).save(consumer);
        this.shaped(RecipeCategory.MISC, (ItemLike)Items.NETHER_STAR).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)CraftingItems.NETHER_STAR_FRAGMENT).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)Items.NETHER_STAR)).save(consumer, SilentGear.getId("nether_star_from_fragments"));
        this.shapeless(RecipeCategory.MISC, CraftingItems.STARMETAL_DUST, 3).requires(SgTags.Items.DUSTS_AZURE_ELECTRUM, 1).requires(SgTags.Items.DUSTS_AZURE_SILVER, 2).requires(SgTags.Items.DUSTS_BLAZE_GOLD, 1).requires((ItemLike)CraftingItems.NETHER_STAR_FRAGMENT).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.NETHER_STAR_FRAGMENT)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.ADVANCED_UPGRADE_BASE).define(Character.valueOf('/'), SgTags.Items.NUGGETS_DIAMOND).define(Character.valueOf('D'), Tags.Items.DYES_BLUE).define(Character.valueOf('U'), (ItemLike)CraftingItems.UPGRADE_BASE).define(Character.valueOf('G'), Tags.Items.NUGGETS_GOLD).pattern("///").pattern("DUD").pattern("GGG").unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.UPGRADE_BASE)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.BLAZE_GOLD_INGOT).requires(Tags.Items.INGOTS_GOLD).requires((ItemLike)Items.BLAZE_POWDER, 4).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)Items.BLAZE_POWDER)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.BLAZING_DUST, (int)4).requires(SgTags.Items.DUSTS_BLAZE_GOLD).requires(Ingredient.of((TagKey)Tags.Items.DUSTS_GLOWSTONE), 2).unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.DUSTS_BLAZE_GOLD)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.BLUEPRINT_PAPER, (int)4).requires(Ingredient.of(SgTags.Items.PAPER), 4).requires(Tags.Items.DYES_BLUE).unlockedBy("has_paper", ModRecipesProvider.has(SgTags.Items.PAPER)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.COBBLESTONE).requires(SgItems.PEBBLE, 9).unlockedBy("has_pebble", ModRecipesProvider.has(SgItems.PEBBLE)).save(consumer, SilentGear.getId("cobblestone_from_pebbles"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.CRIMSON_STEEL_INGOT).define(Character.valueOf('/'), Tags.Items.RODS_BLAZE).define(Character.valueOf('#'), SgTags.Items.INGOTS_CRIMSON_IRON).define(Character.valueOf('C'), (ItemLike)Items.MAGMA_CREAM).pattern("/ /").pattern("#C#").pattern("# #").unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.CRIMSON_IRON_INGOT)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.DIAMOND_SHARD, (int)9).requires(Tags.Items.GEMS_DIAMOND).unlockedBy("has_item", ModRecipesProvider.has((TagKey)Tags.Items.GEMS_DIAMOND)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.DIAMOND).define(Character.valueOf('#'), SgTags.Items.NUGGETS_DIAMOND).pattern("###").pattern("###").pattern("###").unlockedBy("has_item", ModRecipesProvider.has((TagKey)Tags.Items.GEMS_DIAMOND)).save(consumer, SilentGear.getId("diamond_from_shards"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{CraftingItems.SINEW}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.DRIED_SINEW, (float)0.35f, (int)200).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.SINEW)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.EMERALD_SHARD, (int)9).requires(Tags.Items.GEMS_EMERALD).unlockedBy("has_item", ModRecipesProvider.has((TagKey)Tags.Items.GEMS_EMERALD)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.EMERALD).define(Character.valueOf('#'), SgTags.Items.NUGGETS_EMERALD).pattern("###").pattern("###").pattern("###").unlockedBy("has_item", ModRecipesProvider.has((TagKey)Tags.Items.GEMS_EMERALD)).save(consumer, SilentGear.getId("emerald_from_shards"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.FLAX_STRING).requires((ItemLike)CraftingItems.FLAX_FIBER, 2).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.FLAX_FIBER)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.GLITTERY_DUST, (int)8).define(Character.valueOf('o'), (ItemLike)Items.POPPED_CHORUS_FRUIT).define(Character.valueOf('/'), SgTags.Items.NUGGETS_EMERALD).define(Character.valueOf('#'), Tags.Items.DUSTS_GLOWSTONE).define(Character.valueOf('b'), SgItems.NETHER_BANANA).pattern("o/o").pattern("#b#").pattern("o/o").unlockedBy("has_item", ModRecipesProvider.has(SgItems.NETHER_BANANA)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SgItems.GOLDEN_NETHER_BANANA).define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('b'), SgItems.NETHER_BANANA).pattern("ggg").pattern("gbg").pattern("ggg").unlockedBy("has_item", ModRecipesProvider.has(SgItems.NETHER_BANANA)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.IRON_ROD, (int)4).define(Character.valueOf('/'), Tags.Items.INGOTS_IRON).pattern("/").pattern("/").unlockedBy("has_item", ModRecipesProvider.has((ItemLike)Items.IRON_INGOT)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.LEATHER).define(Character.valueOf('#'), (ItemLike)CraftingItems.LEATHER_SCRAP).pattern("###").pattern("###").pattern("###").unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.LEATHER_SCRAP)).save(consumer, SilentGear.getId("leather_from_scraps"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.LEATHER_SCRAP, (int)9).requires((ItemLike)Items.LEATHER).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.LEATHER_SCRAP)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SgBlocks.MATERIAL_GRADER).define(Character.valueOf('Q'), Tags.Items.GEMS_QUARTZ).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('#'), (ItemLike)CraftingItems.ADVANCED_UPGRADE_BASE).define(Character.valueOf('G'), SgTags.Items.INGOTS_BLAZE_GOLD).pattern("QIQ").pattern("I#I").pattern("GGG").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.INGOTS_BLAZE_GOLD)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SgBlocks.NETHERWOOD_DOOR, (int)3).define(Character.valueOf('#'), SgBlocks.NETHERWOOD_PLANKS).pattern("##").pattern("##").pattern("##").unlockedBy("has_item", ModRecipesProvider.has(SgBlocks.NETHERWOOD_PLANKS)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SgBlocks.NETHERWOOD_TRAPDOOR, (int)2).define(Character.valueOf('#'), SgBlocks.NETHERWOOD_PLANKS).pattern("###").pattern("###").unlockedBy("has_item", ModRecipesProvider.has(SgBlocks.NETHERWOOD_PLANKS)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SgBlocks.NETHERWOOD_FENCE, (int)3).define(Character.valueOf('#'), SgBlocks.NETHERWOOD_PLANKS).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).pattern("#/#").pattern("#/#").unlockedBy("has_item", ModRecipesProvider.has(SgBlocks.NETHERWOOD_PLANKS)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SgBlocks.NETHERWOOD_FENCE_GATE, (int)1).define(Character.valueOf('#'), SgBlocks.NETHERWOOD_PLANKS).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).pattern("/#/").pattern("/#/").unlockedBy("has_item", ModRecipesProvider.has(SgBlocks.NETHERWOOD_PLANKS)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, SgBlocks.NETHERWOOD_PLANKS, (int)4).requires(SgTags.Items.NETHERWOOD_LOGS).unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.NETHERWOOD_LOGS)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SgBlocks.NETHERWOOD_WOOD, (int)3).define(Character.valueOf('#'), SgBlocks.NETHERWOOD_LOG).pattern("##").pattern("##").unlockedBy("has_item", ModRecipesProvider.has(SgBlocks.NETHERWOOD_LOG)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SgBlocks.NETHERWOOD_PLANKS).define(Character.valueOf('#'), SgBlocks.NETHERWOOD_SLAB).pattern("#").pattern("#").unlockedBy("has_item", ModRecipesProvider.has(SgBlocks.NETHERWOOD_LOG)).save(consumer, SilentGear.getId("netherwood_planks_from_slabs"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SgBlocks.NETHERWOOD_PLANKS, (int)3).define(Character.valueOf('#'), SgBlocks.NETHERWOOD_STAIRS).pattern("##").pattern("##").unlockedBy("has_item", ModRecipesProvider.has(SgBlocks.NETHERWOOD_LOG)).save(consumer, SilentGear.getId("netherwood_planks_from_stairs"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SgBlocks.NETHERWOOD_SLAB, (int)6).define(Character.valueOf('#'), SgBlocks.NETHERWOOD_PLANKS).pattern("###").unlockedBy("has_item", ModRecipesProvider.has(SgBlocks.NETHERWOOD_LOG)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SgBlocks.NETHERWOOD_STAIRS, (int)4).define(Character.valueOf('#'), SgBlocks.NETHERWOOD_PLANKS).pattern("#  ").pattern("## ").pattern("###").unlockedBy("has_item", ModRecipesProvider.has(SgBlocks.NETHERWOOD_LOG)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.NETHERWOOD_STICK, (int)4).define(Character.valueOf('#'), SgBlocks.NETHERWOOD_PLANKS).pattern(" #").pattern("# ").unlockedBy("has_item", ModRecipesProvider.has(SgBlocks.NETHERWOOD_LOG)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.RED_CARD_UPGRADE, (int)4).requires((ItemLike)CraftingItems.UPGRADE_BASE).requires(Tags.Items.DYES_RED).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.UPGRADE_BASE)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SgBlocks.SALVAGER).define(Character.valueOf('P'), (ItemLike)Blocks.PISTON).define(Character.valueOf('/'), SgTags.Items.INGOTS_CRIMSON_IRON).define(Character.valueOf('I'), Tags.Items.STORAGE_BLOCKS_IRON).define(Character.valueOf('#'), Tags.Items.OBSIDIANS).pattern(" P ").pattern("/I/").pattern("/#/").unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.INGOTS_CRIMSON_IRON)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.SINEW_FIBER, (int)3).requires((ItemLike)CraftingItems.DRIED_SINEW).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.SINEW)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.STONE_ROD, (int)4).define(Character.valueOf('#'), Tags.Items.COBBLESTONES).pattern("#").pattern("#").unlockedBy("has_item", ModRecipesProvider.has((TagKey)Tags.Items.COBBLESTONES)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SgBlocks.STONE_TORCH, (int)4).define(Character.valueOf('#'), ItemTags.COALS).define(Character.valueOf('/'), SgTags.Items.RODS_STONE).pattern("#").pattern("/").unlockedBy("has_item", ModRecipesProvider.has((TagKey)ItemTags.COALS)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)CraftingItems.UPGRADE_BASE, (int)4).requires(Ingredient.of(SgTags.Items.PAPER), 2).requires(ItemTags.PLANKS).requires(Tags.Items.STONES).unlockedBy("has_item", ModRecipesProvider.has((TagKey)ItemTags.PLANKS)).save(consumer);
    }

    private void dyeFluffyBlock(RecipeOutput consumer, ItemLike block, TagKey<Item> dye) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, block, 8).pattern("###").pattern("#d#").pattern("###").define(Character.valueOf('#'), SgTags.Items.FLUFFY_BLOCKS).define(Character.valueOf('d'), dye).unlockedBy("has_item", ModRecipesProvider.has(SgBlocks.WHITE_FLUFFY_BLOCK)).save(consumer);
    }

    private void registerCrudeTools(RecipeOutput output) {
        this.shaped(RecipeCategory.TOOLS, (ItemLike)SgItems.CRUDE_KNIFE).pattern("#").pattern("/").define(Character.valueOf('#'), Tags.Items.COBBLESTONES).define(Character.valueOf('/'), (ItemLike)CraftingItems.CRUDE_TOOL_PARTS).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.CRUDE_TOOL_PARTS)).save(output);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)SgItems.CRUDE_HAMMER).pattern("##").pattern(" /").define(Character.valueOf('#'), Tags.Items.COBBLESTONES).define(Character.valueOf('/'), (ItemLike)CraftingItems.CRUDE_TOOL_PARTS).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)CraftingItems.CRUDE_TOOL_PARTS)).save(output);
    }

    private void registerSmithing(RecipeOutput consumer) {
        SgItems.getItems(item -> item instanceof GearItem).forEach(item -> {
            if (((GearItem)item).getGearType() != GearTypes.ELYTRA.get()) {
                GearSmithingRecipeBuilder.coating((ItemLike)item).save(consumer);
            }
            GearSmithingRecipeBuilder.upgrade((ItemLike)item, (PartType)PartTypes.MISC_UPGRADE.get()).save(consumer);
        });
        this.shapeless(RecipeCategory.MISC, (ItemLike)SgItems.COATING_SMITHING_TEMPLATE).requires((ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE).requires(SgTags.Items.BLUEPRINT_PAPER).requires(SgTags.Items.GEMS_BORT).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE)).save(consumer);
        this.shaped(RecipeCategory.MISC, (ItemLike)SgItems.COATING_SMITHING_TEMPLATE, 2).pattern("dtd").pattern("dnd").pattern("ddd").define(Character.valueOf('d'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('t'), SgItems.COATING_SMITHING_TEMPLATE).define(Character.valueOf('n'), Tags.Items.NETHERRACKS).unlockedBy("has_item", ModRecipesProvider.has(SgItems.COATING_SMITHING_TEMPLATE)).save(consumer, SilentGear.getId("coating_smithing_template_duplication"));
    }

    private void registerSalvaging(RecipeOutput consumer) {
        SgItems.getItems(item -> item instanceof GearItem).forEach(item -> ModRecipesProvider.gearSalvage(consumer, (GearItem)item));
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.NETHERITE_SWORD, (ItemLike)Items.DIAMOND, 2, 1, (ItemLike)Items.NETHERITE_INGOT);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.NETHERITE_PICKAXE, (ItemLike)Items.DIAMOND, 3, 2, (ItemLike)Items.NETHERITE_INGOT);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.NETHERITE_SHOVEL, (ItemLike)Items.DIAMOND, 1, 2, (ItemLike)Items.NETHERITE_INGOT);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.NETHERITE_AXE, (ItemLike)Items.DIAMOND, 3, 2, (ItemLike)Items.NETHERITE_INGOT);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.NETHERITE_HOE, (ItemLike)Items.DIAMOND, 2, 2, (ItemLike)Items.NETHERITE_INGOT);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.NETHERITE_HELMET, (ItemLike)Items.DIAMOND, 5, 0, (ItemLike)Items.NETHERITE_INGOT);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.NETHERITE_CHESTPLATE, (ItemLike)Items.DIAMOND, 8, 0, (ItemLike)Items.NETHERITE_INGOT);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.NETHERITE_LEGGINGS, (ItemLike)Items.DIAMOND, 7, 0, (ItemLike)Items.NETHERITE_INGOT);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.NETHERITE_BOOTS, (ItemLike)Items.DIAMOND, 4, 0, (ItemLike)Items.NETHERITE_INGOT);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.DIAMOND_SWORD, (ItemLike)Items.DIAMOND, 2, 1);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.DIAMOND_PICKAXE, (ItemLike)Items.DIAMOND, 3, 2);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.DIAMOND_SHOVEL, (ItemLike)Items.DIAMOND, 1, 2);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.DIAMOND_AXE, (ItemLike)Items.DIAMOND, 3, 2);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.DIAMOND_HOE, (ItemLike)Items.DIAMOND, 2, 2);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.DIAMOND_HELMET, (ItemLike)Items.DIAMOND, 5, 0);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.DIAMOND_CHESTPLATE, (ItemLike)Items.DIAMOND, 8, 0);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.DIAMOND_LEGGINGS, (ItemLike)Items.DIAMOND, 7, 0);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.DIAMOND_BOOTS, (ItemLike)Items.DIAMOND, 4, 0);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.GOLDEN_SWORD, (ItemLike)Items.GOLD_INGOT, 2, 1);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.GOLDEN_PICKAXE, (ItemLike)Items.GOLD_INGOT, 3, 2);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.GOLDEN_SHOVEL, (ItemLike)Items.GOLD_INGOT, 1, 2);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.GOLDEN_AXE, (ItemLike)Items.GOLD_INGOT, 3, 2);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.GOLDEN_HOE, (ItemLike)Items.GOLD_INGOT, 2, 2);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.GOLDEN_HELMET, (ItemLike)Items.GOLD_INGOT, 5, 0);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.GOLDEN_CHESTPLATE, (ItemLike)Items.GOLD_INGOT, 8, 0);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.GOLDEN_LEGGINGS, (ItemLike)Items.GOLD_INGOT, 7, 0);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.GOLDEN_BOOTS, (ItemLike)Items.GOLD_INGOT, 4, 0);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.IRON_SWORD, (ItemLike)Items.IRON_INGOT, 2, 1);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.IRON_PICKAXE, (ItemLike)Items.IRON_INGOT, 3, 2);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.IRON_SHOVEL, (ItemLike)Items.IRON_INGOT, 1, 2);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.IRON_AXE, (ItemLike)Items.IRON_INGOT, 3, 2);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.IRON_HOE, (ItemLike)Items.IRON_INGOT, 2, 2);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.IRON_HELMET, (ItemLike)Items.IRON_INGOT, 5, 0);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.IRON_CHESTPLATE, (ItemLike)Items.IRON_INGOT, 8, 0);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.IRON_LEGGINGS, (ItemLike)Items.IRON_INGOT, 7, 0);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.IRON_BOOTS, (ItemLike)Items.IRON_INGOT, 4, 0);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.SHEARS, (ItemLike)Items.IRON_INGOT, 2, 0);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.LEATHER_HELMET, (ItemLike)Items.LEATHER, 5, 0);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.LEATHER_CHESTPLATE, (ItemLike)Items.LEATHER, 8, 0);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.LEATHER_LEGGINGS, (ItemLike)Items.LEATHER, 7, 0);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.LEATHER_BOOTS, (ItemLike)Items.LEATHER, 4, 0);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.LEATHER_HORSE_ARMOR, (ItemLike)Items.LEATHER, 7, 0);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.STONE_SWORD, (ItemLike)Items.COBBLESTONE, 2, 1);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.STONE_PICKAXE, (ItemLike)Items.COBBLESTONE, 3, 2);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.STONE_SHOVEL, (ItemLike)Items.COBBLESTONE, 1, 2);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.STONE_AXE, (ItemLike)Items.COBBLESTONE, 3, 2);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.STONE_HOE, (ItemLike)Items.COBBLESTONE, 2, 2);
        ModRecipesProvider.vanillaSalvage(consumer, (ItemLike)Items.BOW, (ItemLike)Items.STRING, 3, 3);
        SalvagingRecipeBuilder.builder((ItemLike)Items.DIAMOND_HORSE_ARMOR).addResult((ItemLike)Items.DIAMOND, 6).addResult((ItemLike)Items.LEATHER).save(consumer, SilentGear.getId("salvaging/diamond_horse_armor"));
        SalvagingRecipeBuilder.builder((ItemLike)Items.GOLDEN_HORSE_ARMOR).addResult((ItemLike)Items.GOLD_INGOT, 6).addResult((ItemLike)Items.LEATHER).save(consumer, SilentGear.getId("salvaging/golden_horse_armor"));
        SalvagingRecipeBuilder.builder((ItemLike)Items.IRON_HORSE_ARMOR).addResult((ItemLike)Items.IRON_INGOT, 6).addResult((ItemLike)Items.LEATHER).save(consumer, SilentGear.getId("salvaging/iron_horse_armor"));
        SalvagingRecipeBuilder.builder((ItemLike)Items.CROSSBOW).addResult((ItemLike)Items.STICK, 3).addResult((ItemLike)Items.STRING, 2).addResult((ItemLike)Items.IRON_INGOT).addResult((ItemLike)Items.TRIPWIRE_HOOK).save(consumer, SilentGear.getId("salvaging/crossbow"));
        SalvagingRecipeBuilder.builder((ItemLike)Items.CLOCK).addResult((ItemLike)Items.GOLD_INGOT, 4).addResult((ItemLike)Items.REDSTONE).save(consumer, SilentGear.getId("salvaging/clock"));
        SalvagingRecipeBuilder.builder((ItemLike)Items.COMPASS).addResult((ItemLike)Items.IRON_INGOT, 4).addResult((ItemLike)Items.REDSTONE).save(consumer, SilentGear.getId("salvaging/compass"));
    }

    private ExtendedShapelessRecipeBuilder<ShapelessRecipe> shapeless(RecipeCategory recipeCategory, ItemLike item) {
        return this.shapeless(recipeCategory, item, 1);
    }

    private ExtendedShapelessRecipeBuilder<ShapelessRecipe> shapeless(RecipeCategory recipeCategory, ItemLike item, int count) {
        return new ExtendedShapelessRecipeBuilder.Basic(recipeCategory, new ItemStack(item, count), ShapelessRecipe::new);
    }

    private ExtendedShapedRecipeBuilder.Basic<ShapedRecipe> shaped(RecipeCategory recipeCategory, ItemLike item) {
        return this.shaped(recipeCategory, item, 1);
    }

    private ExtendedShapedRecipeBuilder.Basic<ShapedRecipe> shaped(RecipeCategory recipeCategory, ItemLike item, int count) {
        return new ExtendedShapedRecipeBuilder.Basic(recipeCategory, new ItemStack(item, count), ShapedRecipe::new);
    }

    private void special(RecipeOutput consumer, RecipeSerializer<? extends CraftingRecipe> serializer, Function<CraftingBookCategory, Recipe<?>> factory) {
        SpecialRecipeBuilder.special(factory).save(consumer, NameUtils.fromRecipeSerializer(serializer).toString());
    }

    private void toolRecipes(RecipeOutput consumer, String name, int mainCount, GearItemSet<?> itemSet) {
        this.shapelessPart(RecipeCategory.TOOLS, (ItemLike)itemSet.mainPart()).requires((ICustomIngredient)BlueprintIngredient.of(itemSet)).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get(), itemSet.type()), mainCount).save(consumer, SilentGear.getId("gear/" + name + "_head"));
        this.shapelessGear(RecipeCategory.TOOLS, (ItemLike)itemSet.gearItem()).requires((ItemLike)itemSet.mainPart()).requires((ICustomIngredient)GearPartIngredient.of((PartType)PartTypes.ROD.get())).save(consumer, SilentGear.getId("gear/" + name));
        this.shapelessGear(RecipeCategory.TOOLS, (ItemLike)itemSet.gearItem()).requires((ICustomIngredient)BlueprintIngredient.of(itemSet)).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get(), itemSet.type()), mainCount).requires((ICustomIngredient)GearPartIngredient.of((PartType)PartTypes.ROD.get())).save(consumer, SilentGear.getId("gear/" + name + "_quick"));
    }

    private void maceRecipes(RecipeOutput output) {
        GearItemSet<GearMaceItem> itemSet = GearItemSets.MACE;
        this.shapelessPart(RecipeCategory.TOOLS, (ItemLike)itemSet.mainPart()).requires((ICustomIngredient)BlueprintIngredient.of(itemSet)).requires((ItemLike)Items.HEAVY_CORE).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get(), itemSet.type()), 3).save(output, SilentGear.getId("gear/mace_core"));
        this.shapelessGear(RecipeCategory.TOOLS, itemSet.gearItem()).requires((ItemLike)itemSet.mainPart()).requires((ICustomIngredient)GearPartIngredient.of((PartType)PartTypes.ROD.get())).save(output, SilentGear.getId("gear/mace"));
        this.shapelessGear(RecipeCategory.TOOLS, itemSet.gearItem()).requires((ICustomIngredient)BlueprintIngredient.of(itemSet)).requires((ItemLike)Items.HEAVY_CORE).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get(), itemSet.type()), 3).requires((ICustomIngredient)GearPartIngredient.of((PartType)PartTypes.ROD.get())).save(output, SilentGear.getId("gear/mace_quick"));
    }

    private void bowRecipes(RecipeOutput consumer, String name, int mainCount, GearItemSet<?> itemSet) {
        this.shapelessPart(RecipeCategory.COMBAT, (ItemLike)itemSet.mainPart()).requires((ICustomIngredient)BlueprintIngredient.of(itemSet)).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get(), itemSet.type()), mainCount).save(consumer, SilentGear.getId("gear/" + name + "_main"));
        this.shapelessGear(RecipeCategory.COMBAT, (ItemLike)itemSet.gearItem()).requires((ItemLike)itemSet.mainPart()).requires((ICustomIngredient)GearPartIngredient.of((PartType)PartTypes.ROD.get())).requires((ICustomIngredient)GearPartIngredient.of((PartType)PartTypes.CORD.get())).save(consumer, SilentGear.getId("gear/" + name));
        this.shapelessGear(RecipeCategory.COMBAT, (ItemLike)itemSet.gearItem()).requires((ICustomIngredient)BlueprintIngredient.of(itemSet)).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get(), itemSet.type()), mainCount).requires((ICustomIngredient)GearPartIngredient.of((PartType)PartTypes.ROD.get())).requires((ICustomIngredient)GearPartIngredient.of((PartType)PartTypes.CORD.get())).save(consumer, SilentGear.getId("gear/" + name + "_quick"));
    }

    private void arrowRecipes(RecipeOutput consumer, String name, GearItemSet<?> itemSet) {
        BlueprintIngredient blueprint = BlueprintIngredient.of(itemSet);
        this.shapelessPart(RecipeCategory.COMBAT, (ItemLike)itemSet.mainPart()).requires((ICustomIngredient)blueprint).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get(), itemSet.type())).save(consumer, SilentGear.getId("gear/" + name + "_head"));
        this.shapelessGear(RecipeCategory.COMBAT, (ItemLike)itemSet.gearItem()).requires((ItemLike)itemSet.mainPart()).requires((ICustomIngredient)GearPartIngredient.of((PartType)PartTypes.ROD.get())).requires((ICustomIngredient)GearPartIngredient.of((PartType)PartTypes.FLETCHING.get())).save(consumer, SilentGear.getId("gear/" + name));
        this.shapelessGear(RecipeCategory.COMBAT, (ItemLike)itemSet.gearItem()).requires((ICustomIngredient)BlueprintIngredient.of(itemSet)).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get(), itemSet.type())).requires((ICustomIngredient)GearPartIngredient.of((PartType)PartTypes.ROD.get())).requires((ICustomIngredient)GearPartIngredient.of((PartType)PartTypes.FLETCHING.get())).save(consumer, SilentGear.getId("gear/" + name + "_quick"));
    }

    private void armorRecipes(RecipeOutput consumer, int mainCount, GearItemSet<? extends GearArmorItem> itemSet) {
        this.shapelessPart(RecipeCategory.COMBAT, (ItemLike)itemSet.mainPart()).requires((ICustomIngredient)BlueprintIngredient.of(itemSet)).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get(), itemSet.type()), mainCount).save(consumer, SilentGear.getId("gear/" + NameUtils.fromItem((ItemLike)itemSet.mainPart()).getPath()));
        this.shapelessGear(RecipeCategory.COMBAT, itemSet.gearItem()).requires((ItemLike)itemSet.mainPart()).save(consumer, SilentGear.getId("gear/" + NameUtils.fromItem((ItemLike)itemSet.gearItem()).getPath()));
        this.shapelessGear(RecipeCategory.COMBAT, itemSet.gearItem()).requires((ItemLike)itemSet.mainPart()).requires((ICustomIngredient)GearPartIngredient.of((PartType)PartTypes.LINING.get())).save(consumer, SilentGear.getId("gear/" + NameUtils.fromItem((ItemLike)itemSet.gearItem()).getPath() + "_with_lining"));
    }

    private void curioRecipes(RecipeOutput consumer, String name, int mainCount, GearItemSet<?> itemSet) {
        this.shapelessPart(RecipeCategory.MISC, (ItemLike)itemSet.mainPart()).requires((ICustomIngredient)BlueprintIngredient.of(itemSet)).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get(), itemSet.type(), MaterialCategories.METAL), mainCount).save(consumer, SilentGear.getId("gear/" + name + "_main_only"));
        this.shapelessGear(RecipeCategory.MISC, (ItemLike)itemSet.gearItem()).requires((ICustomIngredient)BlueprintIngredient.of((PartBlueprintItem)SgItems.JEWELER_TOOLS.get())).requires((ItemLike)itemSet.mainPart()).save(consumer, SilentGear.getId("gear/" + name));
        this.shapelessGear(RecipeCategory.MISC, (ItemLike)itemSet.gearItem()).requires((ICustomIngredient)BlueprintIngredient.of((PartBlueprintItem)SgItems.JEWELER_TOOLS.get())).requires((ItemLike)itemSet.mainPart()).requires((ICustomIngredient)GearPartIngredient.of((PartType)PartTypes.SETTING.get())).save(consumer, SilentGear.getId("gear/" + name + "_with_gem"));
        this.shapelessGear(RecipeCategory.MISC, (ItemLike)itemSet.gearItem()).requires((ICustomIngredient)BlueprintIngredient.of(itemSet)).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get(), itemSet.type(), MaterialCategories.METAL), mainCount).requires((ICustomIngredient)GearPartIngredient.of((PartType)PartTypes.SETTING.get())).save(consumer, SilentGear.getId("gear/" + name + "_quick"));
    }

    private void toolBlueprint(RecipeOutput consumer, String group, GearItemSet<?> itemSet, String ... pattern) {
        this.toolBlueprint(consumer, group, itemSet, Ingredient.EMPTY, pattern);
    }

    private void toolBlueprint(RecipeOutput consumer, String group, GearItemSet<?> itemSet, Ingredient extra, String ... pattern) {
        ShapedRecipeBuilder builderBlueprint = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)itemSet.blueprint()).group("silentgear:blueprints/" + group).define(Character.valueOf('#'), SgTags.Items.BLUEPRINT_PAPER).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.BLUEPRINT_PAPER));
        ShapedRecipeBuilder builderTemplate = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)itemSet.template()).group("silentgear:blueprints/" + group).define(Character.valueOf('#'), SgTags.Items.TEMPLATE_BOARDS).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.TEMPLATE_BOARDS));
        if (extra != Ingredient.EMPTY) {
            builderBlueprint.define(Character.valueOf('@'), extra);
            builderTemplate.define(Character.valueOf('@'), extra);
        }
        for (String line : pattern) {
            builderBlueprint.pattern(line);
            builderTemplate.pattern(line);
        }
        builderBlueprint.save(consumer);
        builderTemplate.save(consumer);
    }

    private void armorBlueprint(RecipeOutput consumer, String group, GearItemSet<?> itemSet, String ... pattern) {
        ShapedRecipeBuilder builderBlueprint = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)itemSet.blueprint()).group("silentgear:blueprints/" + group).define(Character.valueOf('#'), SgTags.Items.BLUEPRINT_PAPER).unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.BLUEPRINT_PAPER));
        for (String line : pattern) {
            builderBlueprint.pattern(line);
        }
        builderBlueprint.save(consumer);
        ShapedRecipeBuilder builderTemplate = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)itemSet.template()).group("silentgear:blueprints/" + group).define(Character.valueOf('#'), SgTags.Items.TEMPLATE_BOARDS).unlockedBy("has_item", ModRecipesProvider.has(SgTags.Items.TEMPLATE_BOARDS));
        for (String line : pattern) {
            builderTemplate.pattern(line);
        }
        builderTemplate.save(consumer);
    }

    private ShapelessConversionBuilder shapelessConversion(RecipeCategory category, GearItem result, List<PartInstance> parts) {
        return new ShapelessConversionBuilder(category, result, parts);
    }

    private void toolConversion(RecipeOutput consumer, GearItemSet<? extends GearItem> itemSet, int mainCount, Item ... toolItems) {
        for (Item input : toolItems) {
            assert (input instanceof TieredItem);
            Tier tier = ((TieredItem)input).getTier();
            DataResource<Material> coating = tier == Tiers.NETHERITE ? Const.Materials.NETHERITE : null;
            this.shapelessConversion(RecipeCategory.MISC, itemSet.gearItem(), ModRecipesProvider.buildConversionParts(itemSet.type(), DataResource.part(itemSet.partName()), TOOL_MATERIALS.getOrDefault(tier, Const.Materials.EMERALD), mainCount, Const.Materials.WOOD, coating)).requires((ItemLike)input).save(consumer, SilentGear.getId("gear/convert/" + NameUtils.fromItem((ItemLike)input).getPath()));
        }
    }

    private void armorConversion(RecipeOutput consumer, GearItemSet<? extends GearItem> itemSet, int mainCount, Item ... armorItems) {
        for (Item input : armorItems) {
            assert (input instanceof ArmorItem);
            Holder armorMaterial = ((ArmorItem)input).getMaterial();
            DataResource<Material> coating = armorMaterial == ArmorMaterials.NETHERITE ? Const.Materials.NETHERITE : null;
            this.shapelessConversion(RecipeCategory.MISC, itemSet.gearItem(), ModRecipesProvider.buildConversionParts(itemSet.type(), DataResource.part(itemSet.partName()), ARMOR_MATERIALS.getOrDefault(armorMaterial, Const.Materials.EMERALD), mainCount, null, coating)).requires((ItemLike)input).save(consumer, SilentGear.getId("gear/convert/" + NameUtils.fromItem((ItemLike)input).getPath()));
        }
    }

    private static void gearSalvage(RecipeOutput consumer, GearItem item) {
        if (item == GearItemSets.ARROW.gearItem()) {
            return;
        }
        SalvagingRecipeBuilder.gearBuilder(item).save(consumer, SilentGear.getId("salvaging/gear/" + NameUtils.fromItem((ItemLike)item).getPath()));
    }

    private static void vanillaSalvage(RecipeOutput consumer, ItemLike gear, ItemLike main, int mainCount, int rodCount) {
        ModRecipesProvider.vanillaSalvage(consumer, gear, main, mainCount, rodCount, null);
    }

    private static void vanillaSalvage(RecipeOutput consumer, ItemLike gear, ItemLike main, int mainCount, int rodCount, @Nullable ItemLike secondary) {
        SalvagingRecipeBuilder<SalvagingRecipe> builder = SalvagingRecipeBuilder.builder(gear).addResult(main, mainCount);
        if (secondary != null) {
            builder.addResult(secondary);
        }
        if (rodCount > 0) {
            builder.addResult((ItemLike)Items.STICK, rodCount);
        }
        ResourceLocation inputId = NameUtils.fromItem((ItemLike)gear);
        builder.save(consumer, SilentGear.getId("salvaging/" + inputId.getPath()));
    }

    private static List<PartInstance> buildConversionParts(GearType gearType, DataResource<GearPart> mainPart, DataResource<Material> main, int mainCount, @Nullable DataResource<Material> rod, @Nullable DataResource<Material> coating) {
        ArrayList<PartInstance> ret = new ArrayList<PartInstance>();
        ArrayList<MaterialInstance> mainMaterials = new ArrayList<MaterialInstance>();
        for (int i = 0; i < mainCount; ++i) {
            mainMaterials.add(MaterialInstance.of(main));
        }
        ret.add(PartInstance.create(mainPart, ((PartType)PartTypes.MAIN.get()).getCompoundPartItem(gearType).orElseThrow(), mainMaterials));
        if (rod != null) {
            ret.add(PartInstance.create(Const.Parts.ROD, (CompoundPartItem)((Object)SgItems.ROD.get()), rod));
        }
        if (coating != null) {
            ret.add(PartInstance.create(Const.Parts.COATING, (CompoundPartItem)((Object)SgItems.COATING.get()), coating));
        }
        return ret;
    }

    private ToolActionRecipeBuilder toolAction(RecipeOutput recipeOutput, TagKey<Item> tool, ItemLike ingredient, int damageToTool, ItemLike result, int count, SoundPlayback sound) {
        return new ToolActionRecipeBuilder(Ingredient.of(tool), Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), damageToTool, new ItemStack(result, count), sound);
    }

    private ToolActionRecipeBuilder toolAction(RecipeOutput recipeOutput, TagKey<Item> tool, TagKey<Item> ingredient, int damageToTool, ItemLike result, int count, SoundPlayback sound) {
        return new ToolActionRecipeBuilder(Ingredient.of(tool), Ingredient.of(ingredient), damageToTool, new ItemStack(result, count), sound);
    }

    private void metals(RecipeOutput consumer, float smeltingXp, Metals metal) {
        if (metal.ore != null) {
            SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of(metal.oreTag), (RecipeCategory)RecipeCategory.MISC, (ItemLike)metal.ingot, (float)smeltingXp, (int)100).unlockedBy("has_item", ModRecipesProvider.has(metal.oreTag)).save(consumer, SilentGear.getId(metal.name + "_ore_blasting"));
            SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(metal.oreTag), (RecipeCategory)RecipeCategory.MISC, (ItemLike)metal.ingot, (float)smeltingXp, (int)200).unlockedBy("has_item", ModRecipesProvider.has(metal.oreTag)).save(consumer, SilentGear.getId(metal.name + "_ore_smelting"));
        }
        if (metal.rawOre != null) {
            SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{metal.rawOre}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)metal.ingot, (float)smeltingXp, (int)100).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)metal.rawOre)).save(consumer, SilentGear.getId(metal.name + "_raw_ore_blasting"));
            SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{metal.rawOre}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)metal.ingot, (float)smeltingXp, (int)200).unlockedBy("has_item", ModRecipesProvider.has((ItemLike)metal.rawOre)).save(consumer, SilentGear.getId(metal.name + "_raw_ore_smelting"));
            this.compressionRecipes(consumer, metal.rawOreBlock, metal.rawOre, null);
        }
        Criterion hasIngot = ModRecipesProvider.has(metal.ingotTag);
        if (metal.block != null) {
            this.compressionRecipes(consumer, metal.block, metal.ingot, metal.nugget);
        }
        if (metal.dustTag != null) {
            Ingredient dust = Ingredient.of(metal.dustTag);
            SimpleCookingRecipeBuilder.blasting((Ingredient)dust, (RecipeCategory)RecipeCategory.MISC, (ItemLike)metal.ingot, (float)smeltingXp, (int)100).unlockedBy("has_item", hasIngot).save(consumer, SilentGear.getId(metal.name + "_dust_blasting"));
            SimpleCookingRecipeBuilder.smelting((Ingredient)dust, (RecipeCategory)RecipeCategory.MISC, (ItemLike)metal.ingot, (float)smeltingXp, (int)200).unlockedBy("has_item", hasIngot).save(consumer, SilentGear.getId(metal.name + "_dust_smelting"));
        }
        if (metal.dust != null) {
            this.toolAction(consumer, SgTags.Items.TOOLS_HAMMER, metal.ingotTag, 1, metal.dust, 1, HAMMER_SOUND).save(consumer);
        }
    }

    private static class Metals {
        private final String name;
        private ItemLike ore;
        private TagKey<Item> oreTag;
        private ItemLike rawOre;
        private ItemLike rawOreBlock;
        private ItemLike block;
        private TagKey<Item> blockTag;
        private final ItemLike ingot;
        private final TagKey<Item> ingotTag;
        private ItemLike nugget;
        private TagKey<Item> nuggetTag;
        private ItemLike dust;
        private TagKey<Item> dustTag;

        public Metals(String name, ItemLike ingot, TagKey<Item> ingotTag) {
            this.name = name;
            this.ingot = ingot;
            this.ingotTag = ingotTag;
        }

        public Metals ore(ItemLike item, TagKey<Item> tag) {
            this.ore = item;
            this.oreTag = tag;
            return this;
        }

        public Metals ore(ItemLike oreBlockItem, TagKey<Item> oreTag, ItemLike rawOre, ItemLike rawOreBlock) {
            this.ore = oreBlockItem;
            this.oreTag = oreTag;
            this.rawOre = rawOre;
            this.rawOreBlock = rawOreBlock;
            return this;
        }

        public Metals block(ItemLike item, TagKey<Item> tag) {
            this.block = item;
            this.blockTag = tag;
            return this;
        }

        public Metals nugget(ItemLike item, TagKey<Item> tag) {
            this.nugget = item;
            this.nuggetTag = tag;
            return this;
        }

        public Metals dust(ItemLike item, TagKey<Item> tag) {
            this.dust = item;
            this.dustTag = tag;
            return this;
        }
    }
}

