/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.part.MaterialGrade;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.util.TextUtil;

public final class GradeCommand {
    private GradeCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgear_grade").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"set").then(Commands.argument((String)"grade", (ArgumentType)StringArgumentType.string()).executes(context -> GradeCommand.runSet((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"grade"))))));
    }

    private static int runSet(CommandContext<CommandSourceStack> context, String gradeStr) throws CommandSyntaxException {
        MaterialGrade grade = MaterialGrade.fromString(gradeStr);
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ItemStack stack = player.getMainHandItem();
        MaterialInstance material = MaterialInstance.from(stack);
        if (material != null) {
            grade.setGradeOnStack(stack);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> TextUtil.translate("command", "grade.success", grade.name(), stack.getHoverName()), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)TextUtil.translate("command", "grade.notMaterial", stack.getHoverName()));
        return 0;
    }
}

