/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.part;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.CraftingInput;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartSerializer;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.util.GearComponent;
import net.silentchaos512.gear.api.util.PropertyKey;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.PartTypes;

public interface GearPart
extends GearComponent<PartInstance> {
    public PartType getType();

    default public GearType getGearType() {
        return (GearType)GearTypes.ALL.get();
    }

    public PartSerializer<?> getSerializer();

    default public String getPackName() {
        return "PACK UNKNOWN";
    }

    default public void retainData(@Nullable GearPart oldPart) {
    }

    public List<MaterialInstance> getMaterials(PartInstance var1);

    @Nullable
    default public MaterialInstance getPrimaryMaterial(PartInstance part) {
        List<MaterialInstance> materials = this.getMaterials(part);
        return !materials.isEmpty() ? materials.getFirst() : null;
    }

    default public double getSalvageLossRate(PartInstance part, ItemStack gear, double normalLossRate) {
        return normalLossRate;
    }

    default public boolean isCraftingAllowed(PartInstance part, GearType gearType) {
        if (gearType.isGear() && this.getType() == PartTypes.MAIN.get()) {
            PropertyKey key = PropertyKey.of(gearType.durabilityStat().get(), gearType);
            return ((Float)this.getPropertyUnclamped(part, (Supplier<PartType>)PartTypes.MAIN, key)).floatValue() > 0.0f;
        }
        return true;
    }

    @Override
    default public boolean isCraftingAllowed(PartInstance part, PartType partType, GearType gearType, @Nullable CraftingInput craftingInput) {
        return this.isCraftingAllowed(part, gearType);
    }

    default public void onGearDamaged(PartInstance part, ItemStack gear, int amount) {
    }

    public int getColor(PartInstance var1, GearType var2, int var3, int var4);

    public Component getDisplayName(@Nullable PartInstance var1);

    default public Component getMaterialName(@Nullable PartInstance part, ItemStack gear) {
        return this.getDisplayName(part);
    }

    default public Component getDisplayNamePrefix(@Nullable PartInstance part, ItemStack gear) {
        return Component.empty();
    }

    default public String getModelKey(PartInstance part) {
        return SilentGear.shortenId(SgRegistries.PART.getKey(this));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addInformation(PartInstance var1, ItemStack var2, List<Component> var3, TooltipFlag var4);

    default public boolean isVisible() {
        return true;
    }

    default public PartInstance randomizeData(GearType gearType, int tier) {
        return PartInstance.of(this);
    }

    public boolean canAddToGear(ItemStack var1, PartInstance var2);

    default public boolean replacesExistingInPosition(PartInstance part) {
        return true;
    }

    default public void onAddToGear(ItemStack gear, PartInstance part) {
    }

    default public void onRemoveFromGear(ItemStack gear, PartInstance part) {
    }
}

