/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.datastructure;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class MultitransformIterator<T, F>
implements Iterator<T> {
    private final Iterator<? extends F> it;
    private final Function<F, Iterator<? extends T>> transformer;
    private Iterator<? extends T> lastIt = Iterators.forArray((Object[])new Object[0]);
    private Iterator<? extends T> removalIt = null;

    public MultitransformIterator(Iterator<? extends F> it, Function<F, Iterator<? extends T>> transformer) {
        this.it = it;
        this.transformer = transformer;
    }

    @Override
    public boolean hasNext() {
        if (this.lastIt.hasNext()) {
            return true;
        }
        while (this.it.hasNext()) {
            this.lastIt = this.transformer.apply(this.it.next());
            if (!this.lastIt.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.removalIt = this.lastIt;
        return this.lastIt.next();
    }

    @Override
    public void remove() {
        if (this.removalIt == null) {
            throw new IllegalStateException("Attempted to call #remove before #next");
        }
        this.removalIt.remove();
    }

    public static <T> Iterator<T> flattenIterableIterator(Iterator<? extends Iterable<T>> it) {
        return new MultitransformIterator<T, Iterable>(it, Iterable::iterator);
    }
}

