/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.cyclops.cyclopscore.config.ConfigurableTypeCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigRegistry;
import org.cyclops.cyclopscore.init.IModBase;

public abstract class RecipeTypeConfigCommon<T extends Recipe<?>, M extends IModBase>
extends ExtendedConfigRegistry<RecipeTypeConfigCommon<T, M>, RecipeType<T>, M> {
    public RecipeTypeConfigCommon(M mod, String namedId) {
        super(mod, namedId, eConfig -> RecipeTypeConfigCommon.simpleRecipeType(ResourceLocation.fromNamespaceAndPath((String)mod.getModId(), (String)namedId)));
    }

    @Override
    public String getTranslationKey() {
        return "recipetype." + this.getMod().getModId() + "." + this.getNamedId();
    }

    @Override
    public String getFullTranslationKey() {
        return this.getTranslationKey();
    }

    @Override
    public ConfigurableTypeCommon getConfigurableType() {
        return ConfigurableTypeCommon.RECIPE_TYPE;
    }

    @Override
    public Registry<? super RecipeType<T>> getRegistry() {
        return BuiltInRegistries.RECIPE_TYPE;
    }

    public static <T extends Recipe<?>> RecipeType<T> simpleRecipeType(ResourceLocation name) {
        final String toString = name.toString();
        return new RecipeType<T>(){

            public String toString() {
                return toString;
            }
        };
    }
}

