/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.ConfigurableTypesNeoForge;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.init.ModBase;

public abstract class FluidConfig
extends ExtendedConfig<FluidConfig, BaseFlowingFluid.Properties> {
    public FluidConfig(ModBase<?> mod, String namedId, Function<FluidConfig, BaseFlowingFluid.Properties> elementConstructor) {
        super(mod, namedId, elementConstructor);
    }

    protected static BaseFlowingFluid.Properties getDefaultFluidProperties(final ModBase<?> mod, final String texturePrefixPath, Consumer<FluidType.Properties> fluidAttributesConsumer) {
        FluidType.Properties fluidAttributes = FluidType.Properties.create();
        fluidAttributesConsumer.accept(fluidAttributes);
        FluidType fluidType = new FluidType(fluidAttributes){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){
                    private final ResourceLocation STILL;
                    private final ResourceLocation FLOW;
                    {
                        this.STILL = ResourceLocation.fromNamespaceAndPath((String)mod.getModId(), (String)(texturePrefixPath + "_still"));
                        this.FLOW = ResourceLocation.fromNamespaceAndPath((String)mod.getModId(), (String)(texturePrefixPath + "_flow"));
                    }

                    public ResourceLocation getStillTexture() {
                        return this.STILL;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return this.FLOW;
                    }
                });
            }
        };
        Wrapper<BaseFlowingFluid.Properties> properties = new Wrapper<BaseFlowingFluid.Properties>();
        Wrapper source = new Wrapper();
        Wrapper flowing = new Wrapper();
        properties.set(new BaseFlowingFluid.Properties(() -> fluidType, () -> {
            if (source.get() == null) {
                source.set(new BaseFlowingFluid.Source((BaseFlowingFluid.Properties)properties.get()));
            }
            return (Fluid)source.get();
        }, () -> {
            if (flowing.get() == null) {
                flowing.set(new BaseFlowingFluid.Flowing((BaseFlowingFluid.Properties)properties.get()));
            }
            return (Fluid)flowing.get();
        }));
        return (BaseFlowingFluid.Properties)properties.get();
    }

    @Override
    public String getTranslationKey() {
        return "block." + ((ModBase)this.getMod()).getModId() + ".block_" + this.getNamedId();
    }

    @Override
    public ConfigurableType getConfigurableType() {
        return ConfigurableTypesNeoForge.FLUID;
    }

    public ResourceLocation getIconLocationStill() {
        return ResourceLocation.fromNamespaceAndPath((String)((ModBase)this.getMod()).getModId(), (String)("blocks/" + this.getNamedId() + "_still"));
    }

    public ResourceLocation getIconLocationFlow() {
        return ResourceLocation.fromNamespaceAndPath((String)((ModBase)this.getMod()).getModId(), (String)("blocks/" + this.getNamedId() + "_flow"));
    }
}

