/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.logistics;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.klikli_dev.theurgy.content.behaviour.logistics.ExtractorNodeBehaviour;
import com.klikli_dev.theurgy.content.behaviour.logistics.InserterNodeBehaviour;
import com.klikli_dev.theurgy.content.behaviour.logistics.LeafNodeBehaviour;
import com.klikli_dev.theurgy.content.behaviour.logistics.LeafNodeMode;
import com.klikli_dev.theurgy.logistics.Logistics;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.minecraft.core.GlobalPos;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;

public class LogisticsNetwork {
    private final Set<GlobalPos> nodes = new ObjectOpenHashSet();
    private final Set<GlobalPos> leafNodes = new ObjectOpenHashSet();
    private final SetMultimap<Key, GlobalPos> keyToLeafNodes = HashMultimap.create();

    public Set<GlobalPos> nodes() {
        return this.nodes;
    }

    public Set<GlobalPos> getLeafNodes(Key key) {
        return this.keyToLeafNodes.get((Object)key);
    }

    public Set<GlobalPos> getLeafNodes(BlockCapability<?, ?> capability, int frequency) {
        return this.getLeafNodes(new Key(capability, frequency));
    }

    public void addNode(GlobalPos pos) {
        this.nodes.add(pos);
    }

    public void removeNode(GlobalPos pos) {
        this.nodes.remove(pos);
    }

    public void addLeafNode(LeafNodeBehaviour<?, ?> leafNode) {
        GlobalPos pos = leafNode.globalPos();
        this.leafNodes.add(pos);
        this.keyToLeafNodes.put((Object)new Key(leafNode.capabilityType(), leafNode.frequency()), (Object)pos);
        if (leafNode.mode() == LeafNodeMode.INSERT) {
            this.onLoadInsertNode(leafNode.asInserter());
        }
        if (leafNode.mode() == LeafNodeMode.EXTRACT) {
            this.onLoadExtractNode(leafNode.asExtractor());
        }
    }

    public void removeLeafNode(LeafNodeBehaviour<?, ?> leafNode) {
        GlobalPos pos = leafNode.globalPos();
        this.leafNodes.remove(pos);
        this.keyToLeafNodes.remove((Object)new Key(leafNode.capabilityType(), leafNode.frequency()), (Object)pos);
        if (leafNode.mode() == LeafNodeMode.INSERT) {
            this.onUnloadInsertNode(leafNode.asInserter());
        }
        if (leafNode.mode() == LeafNodeMode.EXTRACT) {
            this.onUnloadExtractNode(leafNode.asExtractor());
        }
    }

    public <T, C> void onInserterNodeTargetAdded(GlobalPos targetPos, BlockCapabilityCache<T, C> capability, InserterNodeBehaviour<T, C> leafNode) {
        Set<GlobalPos> otherNodes = this.getLeafNodes(leafNode.capabilityType(), leafNode.frequency());
        for (GlobalPos other : otherNodes) {
            LeafNodeBehaviour otherLeafNode;
            if (other.equals((Object)leafNode.globalPos()) || (otherLeafNode = Logistics.get().getLeafNode(other, LeafNodeMode.EXTRACT, leafNode.capabilityType())) == null) continue;
            ExtractorNodeBehaviour<T, C> extractNode = otherLeafNode.asExtractor();
            extractNode.onTargetAddedToGraph(targetPos, capability, leafNode);
        }
    }

    public <T, C> void onInserterNodeTargetRemoved(GlobalPos targetPos, InserterNodeBehaviour<T, C> leafNode) {
        Set<GlobalPos> otherNodes = this.getLeafNodes(leafNode.capabilityType(), leafNode.frequency());
        for (GlobalPos other : otherNodes) {
            LeafNodeBehaviour otherLeafNode;
            if (other.equals((Object)leafNode.globalPos()) || (otherLeafNode = Logistics.get().getLeafNode(other, LeafNodeMode.EXTRACT, leafNode.capabilityType())) == null) continue;
            ExtractorNodeBehaviour<T, C> extractNode = otherLeafNode.asExtractor();
            extractNode.onTargetRemovedFromGraph(targetPos, leafNode);
        }
    }

    public <T, C> void onFrequencyChange(LeafNodeBehaviour<T, C> leafNode, BlockCapability<T, C> capability, int oldFrequency, int newFrequency) {
        GlobalPos pos = leafNode.globalPos();
        Key oldKey = new Key(capability, oldFrequency);
        Key newKey = new Key(capability, newFrequency);
        this.keyToLeafNodes.remove((Object)oldKey, (Object)pos);
        this.keyToLeafNodes.put((Object)newKey, (Object)pos);
        if (leafNode.mode() == LeafNodeMode.INSERT) {
            this.onInsertNodeFrequencyChange(leafNode.asInserter(), oldKey, newKey);
        }
        if (leafNode.mode() == LeafNodeMode.EXTRACT) {
            this.onExtractNodeFrequencyChange(leafNode.asExtractor(), oldKey, newKey);
        }
    }

    protected <T, C> void onExtractNodeFrequencyChange(ExtractorNodeBehaviour<T, C> leafNode, Key oldKey, Key newKey) {
        this.onUnloadExtractNode(leafNode, oldKey);
        this.onLoadExtractNode(leafNode, newKey);
    }

    protected <T, C> void onInsertNodeFrequencyChange(InserterNodeBehaviour<T, C> leafNode, Key oldKey, Key newKey) {
        this.onUnloadInsertNode(leafNode, oldKey);
        this.onLoadInsertNode(leafNode, newKey);
    }

    public <T, C> void onLoadExtractNode(ExtractorNodeBehaviour<T, C> leafNode) {
        this.onLoadExtractNode(leafNode, new Key(leafNode.capabilityType(), leafNode.frequency()));
    }

    public <T, C> void onLoadExtractNode(ExtractorNodeBehaviour<T, C> leafNode, Key newKey) {
        Set<GlobalPos> otherNodes = this.getLeafNodes(newKey);
        for (GlobalPos other : otherNodes) {
            LeafNodeBehaviour otherLeafNode;
            if (other.equals((Object)leafNode.globalPos()) || (otherLeafNode = Logistics.get().getLeafNode(other, LeafNodeMode.INSERT, leafNode.capabilityType())) == null) continue;
            leafNode.onLeafNodeAddedToGraph(other, otherLeafNode);
        }
    }

    public <T, C> void onUnloadExtractNode(ExtractorNodeBehaviour<T, C> leafNode) {
        this.onUnloadExtractNode(leafNode, new Key(leafNode.capabilityType(), leafNode.frequency()));
    }

    public <T, C> void onUnloadExtractNode(ExtractorNodeBehaviour<T, C> leafNode, Key oldKey) {
        leafNode.resetInsertTargets();
    }

    public <T, C> void onLoadInsertNode(InserterNodeBehaviour<T, C> leafNode) {
        this.onLoadInsertNode(leafNode, new Key(leafNode.capabilityType(), leafNode.frequency()));
    }

    public <T, C> void onLoadInsertNode(InserterNodeBehaviour<T, C> leafNode, Key newKey) {
        Set newSet = this.keyToLeafNodes.get((Object)newKey);
        for (GlobalPos other : newSet) {
            LeafNodeBehaviour otherLeafNode;
            if (other.equals((Object)leafNode.globalPos()) || (otherLeafNode = Logistics.get().getLeafNode(other, LeafNodeMode.EXTRACT, leafNode.capabilityType())) == null) continue;
            ExtractorNodeBehaviour<T, C> extractNode = otherLeafNode.asExtractor();
            extractNode.onLeafNodeAddedToGraph(leafNode.globalPos(), leafNode);
        }
    }

    public <T, C> void onUnloadInsertNode(InserterNodeBehaviour<T, C> leafNode) {
        this.onUnloadInsertNode(leafNode, new Key(leafNode.capabilityType(), leafNode.frequency()));
    }

    public <T, C> void onUnloadInsertNode(InserterNodeBehaviour<T, C> leafNode, Key oldKey) {
        Set oldSet = this.keyToLeafNodes.get((Object)oldKey);
        for (GlobalPos other : oldSet) {
            LeafNodeBehaviour otherLeafNode;
            if (other.equals((Object)leafNode.globalPos()) || (otherLeafNode = Logistics.get().getLeafNode(other, LeafNodeMode.EXTRACT, leafNode.capabilityType())) == null) continue;
            ExtractorNodeBehaviour<T, C> extractNode = otherLeafNode.asExtractor();
            extractNode.onLeafNodeRemovedFromGraph(leafNode.globalPos(), leafNode);
        }
    }

    public void merge(LogisticsNetwork other) {
        this.nodes.addAll(other.nodes);
        this.leafNodes.addAll(other.leafNodes);
        this.keyToLeafNodes.putAll(other.keyToLeafNodes);
    }

    public void rebuildCaches() {
        LeafNodeBehaviour<?, ?> node;
        Logistics.get().enableLeafNodeCache();
        for (GlobalPos leafNode : this.leafNodes) {
            node = Logistics.get().getLeafNode(leafNode);
            if (node == null) continue;
            if (node.mode() == LeafNodeMode.EXTRACT) {
                this.onUnloadExtractNode(node.asExtractor());
            }
            if (node.mode() != LeafNodeMode.INSERT) continue;
        }
        for (GlobalPos leafNode : this.leafNodes) {
            node = Logistics.get().getLeafNode(leafNode);
            if (node == null) continue;
            if (node.mode() == LeafNodeMode.EXTRACT) {
                // empty if block
            }
            if (node.mode() != LeafNodeMode.INSERT) continue;
            this.onLoadInsertNode(node.asInserter());
        }
        Logistics.get().disableLeafNodeCache();
    }

    public record Key(BlockCapability<?, ?> capability, int frequency) {
    }
}

