/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book.gettingstarted.spagyrics;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class IncubationEntry
extends EntryProvider {
    public static final String ENTRY_ID = "incubation";

    public IncubationEntry(CategoryProvider parent) {
        super((CategoryProviderBase)parent);
    }

    protected void generatePages() {
        this.page("intro", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Incubating Iron");
        this.pageText("The final step is to recombine the three principles into usable Iron Ingots.\n");
        this.page("step1", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Filling the Vessels");
        this.pageText("[#]($INPUT)Right-click[#]() the {0}, {1} and {2} with the Sulfur, Salt and Mercury you obtained earlier respectively to fill them.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.INCUBATOR_SULFUR_VESSEL.get()), this.itemLink((ItemLike)ItemRegistry.INCUBATOR_SALT_VESSEL.get()), this.itemLink((ItemLike)ItemRegistry.INCUBATOR_MERCURY_VESSEL.get())});
        this.page("step2", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Providing Heat");
        this.pageText("Now add fuel, such as Coal, to the {0} below the Incubator to heat it up.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.PYROMANTIC_BRAZIER.get())});
        this.page("step3", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Obtaining the Incubated Item");
        this.pageText("After a while the input items will have been consumed and incubated into the result.\n\\\n\\\nYou can [#]($INPUT)right-click[#]() the {0} with an empty hand to obtain 3x {1}.\n\\\n\\\n*Congratulations, you created 3 Ingots from 1 Raw Metal!*\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.INCUBATOR.get()), this.itemLink((ItemLike)Items.IRON_INGOT)});
    }

    protected String entryName() {
        return "Incubating Iron";
    }

    protected String entryDescription() {
        return "Creating Iron Ingots from Sulfur, Salt and Mercury";
    }

    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ResourceLocation)Theurgy.loc("textures/gui/book/ingot_x3.png"));
    }

    protected String entryId() {
        return ENTRY_ID;
    }
}

