/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.recipe;

import com.klikli_dev.theurgy.content.recipe.input.ItemHandlerRecipeInput;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.RecipeSerializerRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CatalysationRecipe
implements Recipe<ItemHandlerRecipeInput> {
    public static final int DEFAULT_MERCURY_FLUX_PER_TICK = 20;
    public static final MapCodec<CatalysationRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(r -> r.ingredient), (App)Codec.INT.fieldOf("totalMercuryFlux").forGetter(r -> r.totalMercuryFlux), (App)Codec.INT.fieldOf("mercuryFluxPerTick").forGetter(r -> r.mercuryFluxPerTick)).apply((Applicative)instance, CatalysationRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CatalysationRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.ingredient, (StreamCodec)ByteBufCodecs.INT, r -> r.totalMercuryFlux, (StreamCodec)ByteBufCodecs.INT, r -> r.mercuryFluxPerTick, CatalysationRecipe::new);
    protected final Ingredient ingredient;
    protected final int mercuryFluxPerTick;
    protected final int totalMercuryFlux;

    public CatalysationRecipe(Ingredient ingredient, int totalMercuryFlux, int mercuryFluxPerTick) {
        this.ingredient = ingredient;
        this.totalMercuryFlux = totalMercuryFlux;
        this.mercuryFluxPerTick = mercuryFluxPerTick;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getMercuryFluxPerTick() {
        return this.mercuryFluxPerTick;
    }

    public int getTotalMercuryFlux() {
        return this.totalMercuryFlux;
    }

    public boolean isSpecial() {
        return true;
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeTypeRegistry.CATALYSATION.get();
    }

    public boolean matches(@NotNull ItemHandlerRecipeInput pContainer, @NotNull Level pLevel) {
        ItemStack stack = pContainer.getItem(0);
        return this.ingredient.test(stack);
    }

    @NotNull
    public ItemStack assemble(@NotNull ItemHandlerRecipeInput pCraftingContainer, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.ingredient});
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ItemRegistry.MERCURY_CATALYST.get());
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializerRegistry.CATALYSATION.get();
    }

    public static class Serializer
    implements RecipeSerializer<CatalysationRecipe> {
        @NotNull
        public MapCodec<CatalysationRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, CatalysationRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

