/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item.derivative.render;

import com.klikli_dev.theurgy.config.ClientConfig;
import com.klikli_dev.theurgy.content.item.derivative.AlchemicalDerivativeItem;
import com.klikli_dev.theurgy.content.item.derivative.AlchemicalDerivativeTier;
import com.klikli_dev.theurgy.content.item.sulfur.AlchemicalSulfurItem;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class AlchemicalDerivativeBEWLR
extends BlockEntityWithoutLevelRenderer {
    private static final AlchemicalDerivativeBEWLR instance = new AlchemicalDerivativeBEWLR();
    private static final ItemStack labeledEmptyJarStack = new ItemStack((ItemLike)ItemRegistry.EMPTY_JAR_LABELED_ICON.get());
    private static final ItemStack labelStack = new ItemStack((ItemLike)ItemRegistry.JAR_LABEL_ICON.get());
    private static final Map<AlchemicalDerivativeTier, ItemStack> tierToIconMap = Map.of(AlchemicalDerivativeTier.ABUNDANT, new ItemStack((ItemLike)ItemRegistry.JAR_LABEL_FRAME_ABUNDANT_ICON.get()), AlchemicalDerivativeTier.COMMON, new ItemStack((ItemLike)ItemRegistry.JAR_LABEL_FRAME_COMMON_ICON.get()), AlchemicalDerivativeTier.RARE, new ItemStack((ItemLike)ItemRegistry.JAR_LABEL_FRAME_RARE_ICON.get()), AlchemicalDerivativeTier.PRECIOUS, new ItemStack((ItemLike)ItemRegistry.JAR_LABEL_FRAME_PRECIOUS_ICON.get()));

    public AlchemicalDerivativeBEWLR() {
        super(null, null);
    }

    public static AlchemicalDerivativeBEWLR get() {
        return instance;
    }

    private static boolean isLeftHand(ItemDisplayContext displayContext) {
        return displayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || displayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
    }

    public void renderByItem(@NotNull ItemStack stack, @NotNull ItemDisplayContext displayContext, PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        boolean flatLighting;
        Boolean renderSource = (Boolean)ClientConfig.get().rendering.renderSulfurSourceItem.get();
        ItemStack jarStack = renderSource != false ? AlchemicalDerivativeItem.getEmptyJarStack(stack) : labeledEmptyJarStack;
        pPoseStack.popPose();
        pPoseStack.pushPose();
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        if (displayContext == ItemDisplayContext.GUI && Screen.hasShiftDown()) {
            this.renderContainedItemFull(stack, displayContext, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
            return;
        }
        BakedModel model = itemRenderer.getModel(jarStack, null, null, 0);
        boolean bl = flatLighting = displayContext == ItemDisplayContext.GUI && !model.usesBlockLight();
        if (flatLighting) {
            Lighting.setupForFlatItems();
        }
        itemRenderer.render(jarStack, displayContext, AlchemicalDerivativeBEWLR.isLeftHand(displayContext), pPoseStack, pBuffer, pPackedLight, pPackedOverlay, model);
        this.renderLabelFrame(stack, displayContext, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        if (renderSource.booleanValue()) {
            this.renderLabel(stack, displayContext, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
            this.renderContainedItem(stack, displayContext, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        }
    }

    public void renderLabelFrame(ItemStack stack, ItemDisplayContext displayContext, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        ItemStack tierStack = tierToIconMap.get((Object)AlchemicalSulfurItem.getTier(stack));
        BakedModel labelModel = itemRenderer.getModel(tierStack, null, null, 0);
        pPoseStack.pushPose();
        labelModel.applyTransform(displayContext, pPoseStack, AlchemicalDerivativeBEWLR.isLeftHand(displayContext));
        pPoseStack.pushPose();
        float pixel = 0.0625f;
        pPoseStack.translate(0.0, 0.0, (double)pixel * 0.5);
        pPoseStack.scale(1.0f, 1.0f, 0.01f);
        Lighting.setupForFlatItems();
        itemRenderer.render(tierStack, ItemDisplayContext.GUI, AlchemicalDerivativeBEWLR.isLeftHand(displayContext), pPoseStack, pBuffer, pPackedLight, pPackedOverlay, labelModel);
        pPoseStack.popPose();
        pPoseStack.popPose();
    }

    public void renderLabel(ItemStack stack, ItemDisplayContext displayContext, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        BakedModel labelModel = itemRenderer.getModel(labelStack, null, null, 0);
        pPoseStack.pushPose();
        labelModel.applyTransform(displayContext, pPoseStack, AlchemicalDerivativeBEWLR.isLeftHand(displayContext));
        pPoseStack.pushPose();
        float pixel = 0.0625f;
        pPoseStack.translate(0.0, 0.0, (double)pixel * 0.5);
        pPoseStack.scale(1.0f, 1.0f, 0.01f);
        Lighting.setupForFlatItems();
        itemRenderer.render(labelStack, ItemDisplayContext.GUI, AlchemicalDerivativeBEWLR.isLeftHand(displayContext), pPoseStack, pBuffer, pPackedLight, pPackedOverlay, labelModel);
        pPoseStack.popPose();
        pPoseStack.popPose();
    }

    public void renderContainedItem(ItemStack stack, ItemDisplayContext pTransformType, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        Item item = stack.getItem();
        if (!(item instanceof AlchemicalDerivativeItem)) {
            return;
        }
        AlchemicalDerivativeItem item2 = (AlchemicalDerivativeItem)item;
        ItemStack containedStack = item2.getSourceStack(stack);
        if (!containedStack.isEmpty()) {
            BakedModel containedModel = itemRenderer.getModel(containedStack, null, null, 0);
            BakedModel labelModel = itemRenderer.getModel(labelStack, null, null, 0);
            pPoseStack.pushPose();
            labelModel.applyTransform(pTransformType, pPoseStack, AlchemicalDerivativeBEWLR.isLeftHand(pTransformType));
            pPoseStack.pushPose();
            float pixel = 0.0625f;
            pPoseStack.translate(0.0, 0.0, (double)pixel * 0.6);
            float scale = 0.36f;
            pPoseStack.scale(scale, scale, scale);
            pPoseStack.translate(0.0, (double)(-pixel) * 3.2, 0.0);
            pPoseStack.scale(0.74f, 0.74f, 0.01f);
            Lighting.setupForFlatItems();
            itemRenderer.render(containedStack, ItemDisplayContext.GUI, AlchemicalDerivativeBEWLR.isLeftHand(pTransformType), pPoseStack, pBuffer, pPackedLight, pPackedOverlay, containedModel);
            pPoseStack.popPose();
            pPoseStack.popPose();
        }
    }

    public void renderContainedItemFull(ItemStack stack, ItemDisplayContext pTransformType, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        Item item = stack.getItem();
        if (!(item instanceof AlchemicalDerivativeItem)) {
            return;
        }
        AlchemicalDerivativeItem item2 = (AlchemicalDerivativeItem)item;
        ItemStack containedStack = item2.getSourceStack(stack);
        if (!containedStack.isEmpty()) {
            boolean flatLighting;
            BakedModel model = itemRenderer.getModel(containedStack, null, null, 0);
            boolean bl = flatLighting = !model.usesBlockLight();
            if (flatLighting) {
                Lighting.setupForFlatItems();
            }
            itemRenderer.render(containedStack, ItemDisplayContext.GUI, AlchemicalDerivativeBEWLR.isLeftHand(ItemDisplayContext.GUI), pPoseStack, pBuffer, pPackedLight, pPackedOverlay, model);
        }
    }
}

